<?php
echo 1111112134242;
echo '################################';
echo php_ini_loaded_file();
exit;
/*
 * ------------------------------------------------------------
 * GENSOFT FIREBIRD – SCHEMA & TRIGGERS CHECK
 * ------------------------------------------------------------

  Този скрипт:
  - проверява достъпност до Gensoft Firebird сървъра
  - създава Firebird връзка
  - проверява и създава липсващи колони / индекси / генератор
  - открива дали STOKI.ITEM_ID е липсвала (критично състояние)
  - създава нужните тригери
  ------------------------------------------------------------ */
//

/*  1. Зареждане на ci4 services и helpers.
  ------------------------------------------------------------ */
$db       = \Config\Database::connect();
// Service за Firebird connection (reachability + connect)
$fb       = service('firebirdConnection');
// Service за Firebird бизнес логика (schema, тригери, генератори)
$fbServ   = service('firebirdServices');
// Gensoft конфигурация (host, сървър и др.)
$settings = (object) service('settings') -> get('App.gensoft');
// Helper функции (extract IP, проверки и др.)
helper('utils');

/* Извличане на firebird host и ip.
  ------------------------------------------------------------ */
$host = $settings -> gensoftSrv;

/* Извличаме само IP адреса (за ping / socket check)
  ------------------------------------------------------------ */
$ip = h_extractIp($settings -> gensoftSrv);

/* Проверка дали firebird сървърът е достъпен.
  ------------------------------------------------------------ */
if (!$fb -> isReachable($ip) || empty($host)) {
    die();
}

/* Свързване към firebird базата.
  ------------------------------------------------------------ */
$dbh = $fb -> connect($host);

/* Проверка и създаване на колони / индекси / генератор.
  ------------------------------------------------------------ */
if (!$fbServ -> columns_and_Generator($dbh)) {
    die('❌ Грешка при създаване на колони / индекси / генератор');
}

/* Проверка дали колоната ITEM_ID e новосъздадена в firebird db.
  ако е празна сеавтоматично се обновяват
  ------------------------------------------------------------ */
if (!$fbServ -> populate_itemId_firmId($dbh)) {
    die('❌ Грешка при обновяване на  Колоната ITEM_ID');
}

/* Създаване на firebird тригери.
  ------------------------------------------------------------ */
if (!$fbServ -> triggers($dbh)) {
    die('❌ Грешка при създаване на тригери');
}

echo "✅ Всички операции приключиха успешно\n";
