<?php

/*
 * ------------------------------------------------------------
 * GENSOFT FIREBIRD – SCHEMA & TRIGGERS CHECK
 * ------------------------------------------------------------

  Този скрипт:
  - проверява достъпност до Gensoft Firebird сървъра
  - създава Firebird връзка
  - проверява и създава липсващи колони / индекси / генератор
  - открива дали STOKI.ITEM_ID е липсвала (критично състояние)
  - създава нужните тригери
  ------------------------------------------------------------ */
//

/*  1. Зареждане на ci4 services и helpers.
  ------------------------------------------------------------ */
$db       = \Config\Database::connect();
// Service за Firebird connection (reachability + connect)
$fb       = service('firebirdConnection');
// Service за Firebird бизнес логика (schema, тригери, генератори)
$fbServ   = service('firebirdServices');
// Gensoft конфигурация (host, сървър и др.)
$settings = (object) service('settings') -> get('App.gensoft');
// Helper функции (extract IP, проверки и др.)
helper('utils');

for ($i = 0; $i <= 1; $i++) {
    /* Извличане на firebird host и ip.
      ------------------------------------------------------------ */
    $host = ($i === 0) ? ($settings -> gensoftSrv ?? '') : ($settings -> gensoftSrv2 ?? '');

    /* Извличаме само IP адреса (за ping / socket check)
      ------------------------------------------------------------ */
    $ip = h_extractIp($host);

    /* Проверка дали firebird сървърът е достъпен.
      ------------------------------------------------------------ */
    if (!$fb -> isReachable($ip) || empty($host)) {
        die("❌ Сървара $i е недостъпен");
    }

    /* Свързване към firebird базата.
      ------------------------------------------------------------ */
    $dbh = $fb -> connect($host);

    if (!$fbServ -> hasTriggers($dbh)) {
        /* Проверка и създаване на колони / индекси / генератор.
          ------------------------------------------------------------ */
        if (!$fbServ -> columns_and_Generator($dbh)) {
            die('❌ Грешка при създаване на колони / индекси / генератор');
        }

        /* Проверка дали колоната ITEM_ID e новосъздадена в firebird db.
          ако е празна сеавтоматично се обновяват
          ------------------------------------------------------------ */
        if (!$fbServ -> populate_itemId_firmId($dbh)) {
            die('❌ Грешка при обновяване на  Колоната ITEM_ID');
        }

        /* Създаване на firebird тригери.
          ------------------------------------------------------------ */
        if (!$fbServ -> triggers($dbh)) {
            die('❌ Грешка при създаване на тригери');
        }
    }

    $nL = (php_sapi_name() === 'cli' ? PHP_EOL : '<br>');
    echo "✅ Всички операции приключиха успешно склад Gensoft $i\n\n" . $nL;
}

