
<?php

// Инпортиране на мерни единици от Gensoft база данни
require_once dirname(__DIR__, str_contains(__DIR__, 'debug') ? 2 : 1) . '/cronJobs/BaseCron.php';

class CRON__import_Units_from_Gensoft extends BaseCron {

    protected int $maxRuntime = 5; // бр. итерации(колко пъти да се стартира)
    protected int $delay      = 1;
    protected int $staleLock  = 2;

    protected function handleIteration(int $iteration) {
        /*  1. Зареждане на ci4 services и helpers.
          ------------------------------------------------------------ */
        $db       = \Config\Database::connect();
        $fb       = service('firebirdConnection');
        $fbServ   = service('firebirdServices');
        $settings = (object) service('settings') -> get('App.gensoft');

        helper('utils');

        $baseSklad    = [];
        $bravas_sklad = [];

        /* Дефиниране на складовете
          ------------------------------------------------------------ */
        $warehouses = [
            0 => $settings -> gensoftSrv,
            1 => $settings -> gensoftSrv2 ?? null,
        ];

        /* Извличане на мерни единици от Gensoft
          ------------------------------------------------------------ */
        foreach ($warehouses as $i => $host) {
            if (empty($host)) {
                continue;
            }

            $ip = h_extractIp($host);

            if (!$fb -> isReachable($ip) || empty($host)) {
                die('Сървара е недостъпен');
            }

            $dbh = $fb -> connect($host);

            if (!$fbServ -> hasTriggers($dbh)) {
                // Проверка и създаване на колони / индекси / генератор.
                if (!$fbServ -> columns_and_Generator($dbh)) {
                    die('❌ Грешка при създаване на колони / индекси / генератор');
                }

                // Проверка дали колоната ITEM_ID e новосъздадена в firebird db.
                // ако е празна сеавтоматично се обновяват
                if (!$fbServ -> populate_itemId_firmId($dbh)) {
                    die('❌ Грешка при обновяване на  Колоната ITEM_ID');
                }

                // Създаване на firebird тригери.
                if (!$fbServ -> triggers($dbh)) {
                    die('❌ Грешка при създаване на тригери');
                }
            }

            $sth = ibase_query($dbh, "SELECT RAZFAS FROM RAZFAS");

            while ($row = ibase_fetch_object($sth)) {
                $item = h_UTF8($row -> RAZFAS);

                if ($i === 0) {
                    $baseSklad[] = $item;
                } else {
                    $bravas_sklad[] = $item;
                }
            }

            ibase_free_result($sth);
        }

        $grouped = [];

        /* Групиране по canonical / unit_key
          ------------------------------------------------------------ */
        foreach (array_merge($baseSklad ?? [], $bravas_sklad ?? []) as $v) {
            $key = h_normalizeUnit($v);

            // първата срещната печели
            $grouped[$key] ??= [
                'canonical_unit' => $key,
                'mqrka_unit'     => h_formatUnit($v),
            ];
        }

        $grouped = array_values($grouped);

        if (empty($grouped)) {
            return;
        }

        /* UPSERT подготовка (MySQL)
          ------------------------------------------------------------ */
        $total              = count($grouped);
        $list               = array_column($grouped, 'canonical_unit');
        $placeholders       = array_fill(0, count($grouped), '(?, ?)');
        $deletePlaceholders = implode(',', array_fill(0, count($list), '?'));
        $binds              = [];

        foreach ($grouped as $row) {
            $binds[] = $row['mqrka_unit']; // mqrka_unit
            $binds[] = $row['canonical_unit'];   // gensoft_mqrka_id
        }

        $sql = "INSERT INTO _sp_mqrka (mqrka_unit,canonical_unit) VALUES " . implode(',', $placeholders) . " ON DUPLICATE KEY UPDATE  mqrka_unit = VALUES(mqrka_unit)";

        $sqlDelete = "DELETE FROM _sp_mqrka WHERE canonical_unit NOT IN ($deletePlaceholders)";

        $db -> transStart();

// UPSERT
        $db -> query($sql, $binds);

// DELETE липсващите
        if (!empty($list)) {
            $db -> query($sqlDelete, $list);
        }

        $db -> transComplete();

        if ($db -> transStatus() === false) {
            die('Грешка при синхронизация на мерни единици');
        }

        echo "✅ Импортът на мерни единици е успешен: $total реда";
        return true;
    }

}

$cron = new CRON__import_Units_from_Gensoft();
$cron -> run($cron::class);
