
<?php

// Инпортиране на мерни единици от Gensoft база данни
require_once dirname(__DIR__, str_contains(__DIR__, 'debug') ? 2 : 1)  . '/cronJobs/BaseCron.php';

class CRON__import_Groups_from_Gensoft extends BaseCron {

    protected int $maxRuntime = 1; // бр. итерации(колко пъти да се стартира)
    protected int $delay      = 1;
    protected int $staleLock  = 2;

    protected function handleIteration(int $iteration) {

        /*  1. Зареждане на ci4 services и helpers.
          ------------------------------------------------------------ */
        $db       = \Config\Database::connect();
        $fb       = service('firebirdConnection');
        $fbServ   = service('firebirdServices');
        $settings = (object) service('settings') -> get('App.gensoft');

        helper('utils');

        /* Дефиниране на складовете
          ------------------------------------------------------------ */
        $warehouses = [
            0 => $settings -> gensoftSrv,
            1 => $settings -> gensoftSrv2 ?? null,
        ];

        /* Извличане на мерни единици от Gensoft
          ------------------------------------------------------------ */
        $groups = [];
        foreach ($warehouses as $i => $host) {
            if (empty($host)) {
                continue;
            }

            $ip = h_extractIp($host);

            if (!$fb -> isReachable($ip) || empty($host)) {
                die('Сървара е недостъпен');
            }

            $dbh = $fb -> connect($host);

            $sth = ibase_query($dbh, "SELECT DISTINCT DT_CHANGED,GRUPA ,PARENT_GR FROM GRUPI");

            while ($row = ibase_fetch_object($sth)) {
                $grupa = trim(h_UTF8($row -> GRUPA ?? ''));
                if ($grupa === '') {
                    continue; // защита
                }

                $parent = trim(h_UTF8($row -> PARENT_GR ?? '')) ?: null;

                $groups[] = [
                    'sklad_id'   => $i,
                    'skladName'  => $i == 0 ? $_ENV['app.baseSklad'] : $_ENV['app.sklad4'],
                    'grupa'      => $grupa,
                    'gparent'    => $parent,
                    'dt_changed' => $row -> DT_CHANGED ?? null,
                ];
            }

            ibase_free_result($sth);
        }

        if (!empty($groups)) {

            $placeholders = [];
            $binds        = [];

            foreach ($groups as $r) {

                // защита
                if ($r['grupa'] === '') {
                    continue;
                }

                $placeholders[] = '(?, ?, ?, ?, ?)';

                $binds[] = $r['sklad_id'];
                $binds[] = $r['skladName'];
                $binds[] = $r['grupa'];
                $binds[] = $r['gparent'] !== '' ? $r['gparent'] : null;
                $binds[] = $r['dt_changed'];
            }



            $db -> transStart();

            $sql = " INSERT INTO _category_gensoft (sklad_id, skladName, grupa, parent, dt_changed) VALUES " . implode(', ', $placeholders) . "
                    ON DUPLICATE KEY UPDATE
                        grupa    = VALUES(grupa),
                        parent   = IF(VALUES(dt_changed) > dt_changed, VALUES(parent), parent),
                        dt_changed = GREATEST(dt_changed, VALUES(dt_changed))";

            $db -> query($sql, $binds);

            if ($db -> transStatus() === false) {
                die('Грешка при синхронизация на групи');
            }


            $db -> transComplete();
        }

        echo "✅ Импортът на групи е успешен";
        return true;
    }

}

$cron = new CRON__import_Groups_from_Gensoft();
$cron -> run($cron::class);
