<?php

// Експортиране на цени към Gensoft база данни
require_once dirname(__DIR__, str_contains(__DIR__, 'debug') ? 2 : 1) . '/cronJobs/BaseCron.php';

class CRON__export_productPrice_to_Gensoft extends BaseCron {

    protected int $maxRuntime = 5;
    protected int $delay      = 1;
    protected int $staleLock  = 2;

    protected function handleIteration(int $iteration) {
        /*  1. Зареждане на ci4 services и helpers.
          ------------------------------------------------------------ */
        $db       = \Config\Database::connect();
        $fb       = service('firebirdConnection');
        //$fbServ   = service('firebirdServices');
        $settings = (object) service('settings') -> get('App.gensoft');

        helper('utils');

        $host = $settings -> gensoftSrv;
        $ip   = h_extractIp($settings -> gensoftSrv);

        if (!$fb -> isReachable($ip) || empty($host)) {
            die();
        }

        $dbh = $fb -> connect($host);

        $getProducts = "SELECT sp.date_changed, p.gensoft_item_id, p.gensoft_productName, sp.$zenaNivo, ROUND(sp.cenaKKC / 1.2, 2) AS cenaKKC
                FROM _product_priceLevel AS sp
				
                INNER JOIN _product AS p 
                    ON p.product_id = sp.product_id 
                    
		INNER JOIN _product_in_zenovaLista AS z 
                    ON p.product_id = z.product_id 	
					
                WHERE   COALESCE(p.gensoft_productName, '') != '' 
                        AND COALESCE(sp.$zenaNivo, '') != '' 
                        AND COALESCE(sp.cenaKKC, '') != '' 
                        AND DATE(sp.date_changed) = CURDATE()";

        $result = $db -> query($getProducts);

        $batchSize = 100; // Commit every 100 updates
        $counter   = 0;

        if ($result) {
            $transaction = ibase_trans($dbh, IBASE_DEFAULT);

            // Prepare a single statement for all updates
            $stmt = "
                    EXECUTE BLOCK (ZENA_ED DOUBLE PRECISION = ?, ZENA_DR DOUBLE PRECISION = ?, ITEM_ID INT = ?) AS 
                    
                    BEGIN
                        UPDATE STOKI 
                        SET CENA_PROD_ED1 = :ZENA_ED, CENA_PROD_DR1 = :ZENA_DR 
                        WHERE ITEM_ID = :ITEM_ID;

                        UPDATE STOKI_DEF 
                        SET CENA_PROD_ED1 = :ZENA_ED, CENA_PROD_DR1 = :ZENA_DR 
                        WHERE ITEM_ID = :ITEM_ID;

                        UPDATE SER_NO 
                        SET CENA_PROD_ED1 = :ZENA_ED, CENA_PROD_DR1 = :ZENA_DR 
                        WHERE ITEM_ID = :ITEM_ID;
                    END; ";

            $sth = ibase_prepare($transaction, $stmt);

            while ($row = $result -> fetch_assoc()) {
                $stoka           = $row['gensoft_productName'];
                $zenaEd          = $row[$zenaNivo];
                $zenaDr          = $row['cenaKKC'];
                $gensoft_item_id = $row['gensoft_item_id'];

                // Execute the prepared statement
                $success = ibase_execute($sth, $zenaEd, $zenaDr, $gensoft_item_id);

                if (!$success) {
                    //$error[] = "Грешка при обновяване на стока: [ID: $gensoft_item_id]";
                }

                $counter++;

                if ($counter % $batchSize === 0) {
                    ibase_commit($transaction);
                    //echo "Committed batch of $batchSize updates.\n";
                    // Start a new transaction

                    $transaction = ibase_trans($dbh, IBASE_DEFAULT);
                    $sth         = ibase_prepare($transaction, $stmt);
                }
            }

            $result -> free();
            // Commit remaining updates
            if ($counter % $batchSize !== 0) {
                ibase_commit($transaction);
            }
            //echo( $error ?? 0);
            echo "Export is done";
        } else {
            echo "Error fetching products: ";
        }
    }

}

$cron = new CRON__export_productPrice_to_Gensoft();
$cron -> run($cron::class);
