( function ($) {

    $.fn.columntoggle = function (options) {

        // Establish our default settings
        var settings = $.extend({
            showAllColsText: '',
            showBtnText: '',
            divClass: '',
            //Class of column toggle contains toggle link
            toggleContainerClass: 'columntoggle-container',
            toggleContainerId: '',

            //Text in column toggle box
            toggleLabel: '',

            //the prefix of key in localstorage
            keyPrefix: 'columntoggle-',

            //keyname in localstorage, if empty, it will get from URL
            key: ''

        }, options);

        //set default key for storage
        if (settings.key.length == 0) {
            settings.key = window.location.href;
        }

        var toggleLinkStatus = {
            checkStatus: function (el, hidelist, colIndex = null ) {

                $(el).parent().find(settings.divClass).find('.dropdown-menu a').each(function () {

                    var columnindex = $(this).attr('data-columnindex');
                    if (columnindex == 'all') {
                        return;
                    }

                    if ($.inArray(columnindex + '', hidelist) >= 0) {
                        if (colIndex == 'all') {
                            $(this).addClass('bg-info');
                        }
                        else {
                            $(this).removeClass('bg-info');
                        }
                    }
                    else {
                        $(this).addClass('bg-info');
                    }
                });

                if (colIndex == 'all') {
                    sessionStorage.removeItem(settings.keyPrefix + settings.key);
            }
            }
        }

        var toggleStatusStorage = {
            save: function (el) {
                var hidelist = [ ];
                $(el).find('thead:not(.tableFloatingHeader) > tr.labels > th').each(function (index) {
                    //column index start from 1
                    var columnindex = index + 1;
                    if ($(this).is(':visible') === false) {
                        hidelist.push(columnindex + '');
                    }
                });

                sessionStorage.setItem(settings.keyPrefix + settings.key, hidelist.join(','));

                toggleLinkStatus.checkStatus(el, hidelist);
            },
            load: function (el, colIndex = null ) {
                if (settings.key.length > 0) {
                    var hidelistString = sessionStorage.getItem(settings.keyPrefix + settings.key);


                    if (hidelistString !== null && hidelistString.length > 0) {
                        var hidelist = hidelistString.split(',');
                        if (hidelist.length > 0) {
                            $.each(hidelist, function (index, columnindex) {
                                if (colIndex == 'all') {
                                    $(el).find('td:nth-child(' + columnindex + '), tr.labels  th:nth-child(' + columnindex + ')').toggle();
                                }
                                else {

                                    $(el).find('td:nth-child(' + columnindex + '), tr.labels  th:nth-child(' + columnindex + ')').hide();

                                    toggleStatusStorage.colspan(el, columnindex);
                                    //$(el).get(0).scrollIntoView(false); //fix table background bug for hide columns
                                }
                            });
                            toggleLinkStatus.checkStatus(el, hidelist);
                        }

                    }

                    toggleLinkStatus.checkStatus(el, hidelist, colIndex);
            }
            },
            // ако има th colspan
            colspan: function (el, colIndex = null ) {
                // ---- Намери колоната в първия ред (thead tr) като пресметнеш colspan ----
                var total = 0;
                var $headerCells = $(el).find('thead tr:not(.labels) th');

                $headerCells.each(function () {
                    var colspan = parseInt($(this).attr('colspan')) || 1;
                    total += colspan;

                    if (colIndex == total) {
                        $(this).toggle(); // Скрий тази клетка
                        return false; // спри обхождането
                    }
                });
            }
        };


        return this.each(function () {

            //Detect to prevent add more togglebox to a table (ussally from react didUpdate)
            if ($(this).prev().hasClass(settings.toggleContainerClass)) {
                $(this).prev().remove();
            }

            var table = $(this);

            //find table header to extract columns
            var toggleColumnHtml = [ ];

            $(this).find('thead:not(.tableFloatingHeader) > tr.labels > th').each(function (index) {

                //column index start from 1
                var columnindex = index + 1;

                var togglenameAttr = $(this).attr('data-columntoggle');
                var toggleName = '';

                if (typeof togglenameAttr !== typeof undefined && togglenameAttr !== false) {
                    toggleName = togglenameAttr;
                }
                else {
                    toggleName = $(this).text();
                }

                if ($(this).text().length === 0) {
                    return;
                }

                toggleColumnHtml.push('<p class="my-1"><a class="d-flex  p-1" href="javascript:;" data-columnindex="' + columnindex + '">' + toggleName + '</a></p>');
            });

            var toggleContainer = '<div class="dropdown order-first my-auto"><button class="dropdown-toggle p-1" type="button" data-toggle="dropdown">' + settings.showBtnText + '</button><div id="' + settings.toggleContainerId + '"  class="' + settings.toggleContainerClass + '"><p class="my-1"><a class="d-flex p-1" href="javascript:;" data-columnindex="all">' + settings.showAllColsText + '</a></p><br>' + settings.toggleLabel + ' ' + toggleColumnHtml.join('') + '</div></div>';
            $(this).parent().find(settings.divClass).append(toggleContainer);


            $(this).parentsUntil(settings.divClass).find('#chkBox-tblColShow a').each(function () {
                $(this).on('click', function (e) {
                    var columnindex = $(this).attr('data-columnindex');

                    if (columnindex == 'all') {
                        toggleStatusStorage.load(table, columnindex);
                        // $(table).find('td:nth-child(' + columnindex + '), th:nth-child(' + columnindex + ')').toggle();
                        $(table).find('thead tr:not(.labels) th').show();
                    }
                    else {
                        $(table).find('td:nth-child(' + columnindex + '),tr.labels th:nth-child(' + columnindex + ')').toggle();

                        toggleStatusStorage.colspan(table, columnindex);

                        // $(table).get(0).scrollIntoView(false); //fix table background bug for hide columns
                        //store
                        toggleStatusStorage.save(table);
                    }

                    e.stopPropagation();
                    e.preventDefault();
                });
            });

            //load hide status from cache
            toggleStatusStorage.load(table);
        });

    }
}(jQuery) );
