;
( function ($) {

    /**
     * Django's filter_horizontals (and I assume filter_verticals) don't
     * serialize well using $.fn.serialize()
     */
    var old_val = $.fn.val;
    $.fn.val = function () {
        if (this.is('.selector select[multiple].filtered')) {
            return $.map(this.find('option'), function (option) {
                return option.value;
            });
        }
        else {
            return old_val.apply(this, arguments);
        }
    };

    /**
     * We want to ignore any inputs that:
     *
     *   1. have no name (and thus won't be submitted regardless
     *   2. are the left side of filter_horizontals (or the top of
     *      filter_verticals)
     *   3. have no value
     */
    function filterUndesirables (inputs) {
        return $.grep(inputs, function (input) {
            var $input = $(input),
                    val = $input.val(),
                    is_radio_or_checkbox = $input.is('[type=checkbox], [type=radio]'),
                    // django admin specific
                    is_left_hand_filter = $input.is('.selector select[multiple].filtered[name$="_old"]');

            return !!input.name &&
                    !is_left_hand_filter &&
                    ( $.isArray(val) ? val.length > 0 : !!val ) &&
                    ( !is_radio_or_checkbox || $input.is(':checked') );
        });
    }

    /**
     * This is basically the same as $.fn.serialize, but uses
     * filterUndesirables. It should not be used for actually submitting
     * data though, for the record.
     */
    function serializeForm (form) {
        if (window.CKEDITOR)
            // force all ckeditors to write back their values to their element
            for (var name in CKEDITOR.instances)
                if (CKEDITOR.instances.hasOwnProperty(name))
                    CKEDITOR.instances[name].updateElement();

        var vars = $.map(filterUndesirables(form.find(':input[name]')), function (elem) {
            return elem.name + '=' + $(elem).val();
        });

        return vars.join('&');
    }

    /**
     * Don't just leave me!
     *
     * Checks if the form is the same before leaving the page as it was when we
     * came in, if not, make sure they want to leave.
     */
    $.fn.dontJustLeaveMe = function (option) {
        var options = $.extend({}, $.fn.dontJustLeaveMe.defaultOptions, option);
        //  return this.each(function() {
        var $form = $(this),
                was_submitted = false,
                initialState = options.serializeForm($form);

        $form.on('submit', function () {
            was_submitted = true;
        });

        $("a#exitOfer,a#newOfer").click(function (e) {
            Lp.check_ofer.beforeUnload();

            if (!was_submitted && options.serializeForm($form) != initialState) {
                e.stopImmediatePropagation();

                if (!confirm(LANG__global.validate.confirm.dontJustLeaveMeExit)) {
                    return false
                }
            }
        });

        $(option).click(function (e) {
            // $("a#prinPreview, а#convertOfer, a#zenoobrazuvane, a#generate-tovaritelniza").click(function (e) {

            if (!$(this).is('[disabled]') && !was_submitted && options.serializeForm($form) != initialState) {

                alert(LANG__global.validate.alert.dontJustLeaveMe);
                e.preventDefault();
                e.stopImmediatePropagation();
            }

            if ($(this).attr('id') == 'prinPreview' && $('#leftAside #shablon-ofer') != undefined) {
                if ($('#leftAside #shablon-ofer').val() == '') {
                    alert(LANG__global.validate.alert.lipsvaShablon);
                    e.preventDefault();
                    e.stopImmediatePropagation();
                }
            }

        });

        var validNavigation = false;

        function unload (e) {

            // console.log(b)
            if (validNavigation !== true) {

                $('body').css('cursor', 'wait');

//                $.ajax({
//                    type: 'POST',
//                    async: false,
//                    url: '/A_Global/ajax_removeLockStage/' + url_oferName + '/' + url_oferID,
//                    success: function () {
//                        validNavigation = true;
//                        $('body').css('cursor', 'default');
//                    },
//                    error: function () {
//                        navigator.sendBeacon('/A_Global/ajax_removeLockStage/' + url_oferName + '/' + url_oferID);
//                    }
//                });
                // return ;
            }
        }

        $(window).on('beforeunload unload', function () {

            if (!was_submitted && options.serializeForm($form) != initialState) {
                //return( LANG__global.validate.confirm.dontJustLeaveMeExit);
            }
        });

        //});
    };

    $.fn.dontJustLeaveMe.defaultOptions = {
        serializeForm: serializeForm,
        //errorMessage: LANG__global.validate.confirm.dontJustLeaveMe
    };
} )(window.jQuery || window.django.jQuery);
