<?php

namespace CkFinder\image_modificate;

use App\Controllers\BaseController;
use App\Models\BaseModel;
use Config\Services;
use Config\Database;

class MyPlugin extends BaseController {

    protected $request;
    protected $db;

    public function __construct() {
        $this -> request = Services::request();
        $this -> db      = Database::connect('default');
    }

    public function index() {
        $command = $this -> request -> getVar('command');

        if (!$command) {
            return;
        }

        $currentDir = $this -> request -> getVar('currentDir') ?? '';

        // Дефинирай map на директория към [таблица, поле]
        $renameMap = [
            'categories' => [BaseModel::TBL_CATEGORY, 'image_cat'],
            '_models'    => [BaseModel::TBL_MODEL, 'image_model'],
            '_brand'     => [BaseModel::TBL_BRAND, 'image_brand'],
        ];
        $response  = [
            'status'       => 'success',
            'message'      => '',
            'affectedRows' => 0
        ];

        switch ($command) {
            case 'renameFile':
                $name    = $this -> request -> getVar('name');
                $newName = $this -> request -> getVar('newName');

                [$table, $field] = $renameMap[$currentDir] ?? [BaseModel::TBL_PRODUCT, 'image'];

                $affectedRows = $this -> execQuery($table, $field, $name, $newName);

                $response['affectedRows'] = $affectedRows;
                $response['message']      = $affectedRows > 0 ? 'Файлът беше преименуван успешно.' : 'Няма актуализирани записи.';
                break;

            case 'deleteFiles':
                $arr   = $this -> request -> getVar('arr_deletingFiles');
                $paths = [];

                if (empty($arr)) {
                    return ['status' => 'failed', 'message' => 'No files provided.'];
                }

                foreach ($arr as $val) {
                    $paths[] = ltrim($val['folder'], '/') . $val['name'];
                }

                [$table, $field] = $renameMap[$currentDir] ?? [BaseModel::TBL_PRODUCT, 'image'];

                $affectedRows = $this -> execQuery($table, $field, $paths, null, 'delete');

                $response['affectedRows'] = $affectedRows;
                $response['message']      = $affectedRows > 0 ? 'Files deleted successfully.' : 'No files deleted.';
                break;

            case 'moveFiles':
                $newFolderPath     = $this -> request -> getVar('new_FolderPatch');
                $oldFolderName     = $this -> request -> getVar('old_FolderName');
                $arrOldFolderPatch = $this -> request -> getVar('arr_old_FolderPatch');
                $oldFolderPaths    = [];

                if (empty($arrOldFolderPatch)) {
                    return;
                }

                foreach ($arrOldFolderPatch as $val) {
                    $oldFolderPaths[] = ltrim($val['folder'], '/') . $val['name'];
                }

                [$table, $field] = $renameMap[$currentDir] ?? [BaseModel::TBL_PRODUCT, 'image'];

                $affectedRows = $this -> execQuery($table, $field, $oldFolderPaths, null, 'move', $oldFolderName, $newFolderPath);

                $response['affectedRows'] = $affectedRows;
                $response['message']      = $affectedRows > 0 ? 'Files moved successfully.' : 'No files moved.';
                break;

            case 'renameFolder':
                $currentFolderName = $this -> request -> getVar('currentFolderName');
                $newFolderName     = $this -> request -> getVar('newFolderName');

                [$table, $field] = $renameMap[$currentDir] ?? [BaseModel::TBL_PRODUCT, 'image'];

                $affectedRows = $this -> execQuery($table, $field, null, null, 'renameFolder', $currentFolderName, $newFolderName);

                $response['affectedRows'] = $affectedRows;
                $response['message']      = $affectedRows > 0 ? 'Files renamed successfully.' : 'No files renamed.';
                break;

            case 'deleteFolder':
                $currentFolderName = $this -> request -> getVar('currentFolderName');

                [$table, $field] = $renameMap[$currentDir] ?? [BaseModel::TBL_PRODUCT, 'image'];

                $affectedRows = $this -> execQuery($table, $field, $currentDir, null, 'deleteFolder', $currentFolderName);

                $response['affectedRows'] = $affectedRows;
                $response['message']      = $affectedRows > 0 ? 'Files deleted successfully.' : 'No files deleted.';
                break;

            default:
                $response['status']  = 'failed';
                $response['message'] = 'Invalid command.';
                break;
        }

        return $this -> response -> setJSON($response);
    }

    protected function execQuery(string $table, string $column, $whereVal, $newValue, string $mode = 'update', string $from = '', string $to = ''): int {

        $builder = $this -> db -> table($table);

        switch ($mode) {
            case 'update':
                // Проста смяна на стойност: WHERE column = value
                $builder -> set($column, $newValue)
                        -> where($column, $whereVal)
                        -> update();
                break;

            case 'delete':
                $builder -> set($column, $newValue)
                        -> whereIn($column, $whereVal)
                        -> update();
                break;

            case 'move':
                $builder -> set($column, "REPLACE($column, '$from', '$to')", false)
                        -> whereIn($column, $whereVal)
                        -> update();
                break;

            case 'renameFolder':
                $builder -> set($column, "REPLACE($column, '$from', '$to')", false)
                        -> where("$column <>", '')
                        -> update();

                break;
            case 'deleteFolder':
                $builder -> set($column, null)
                        -> where("$column REGEXP '^$whereVal/$from'", null, false)
                        -> update();

                break;
        }

        return $this -> db -> affectedRows();
    }

}
