<?php

namespace CKSource\CKFinder\Plugin\AutoThumbRegenerator;

use CKSource\CKFinder\Plugin\PluginInterface;
use RecursiveIteratorIterator;
use RecursiveDirectoryIterator;

class AutoThumbRegenerator implements PluginInterface {

    protected $app;
    protected $ckfinder;
    protected $baseDir;
    protected $thumbPlugin;
    protected $resourceType;

    public function setContainer(\CKSource\CKFinder\CKFinder $app) {
        $this -> app = $app;

        $this -> setUp(); // 👈 автоматичен старт при зареждане
    }

    public function getDefaultConfig() {
        return [];
    }

    public function setUp() {
        // Намери пътя към кореновата папка на CodeIgniter 4
        $rootPath = $_SERVER['HOME'] ?? getenv('HOME');
        $env      = [];
        $envFile  = file_get_contents(getenv('DOCUMENT_ROOT') . '/.env');
        preg_match_all('/app\.(mediaRoot|mediaUrl)\s*=\s*(\S+)/', $envFile, $matches, PREG_SET_ORDER);

        foreach ($matches as $match) {
            $env[$match[1]] = trim($match[2], " \t\n\r\0\x0B\"'");
        }

        $this -> baseDirs = [
            'productImages' => $rootPath . $env['mediaRoot'] . 'productImages',
            'Портал'        => $rootPath . $env['mediaRoot'] . 'portal_images'
        ];

        $this -> thumbRepo = $this -> app['thumbnail_repository'];
        $this -> generateAllThumbs();
    }

    protected function generateAllThumbs() {
        foreach ($this -> baseDirs as $resourceTypeName => $baseDir) {
            $resourceDir = rtrim(str_replace('\\', '/', $baseDir), '/');
            $mediaRoot   = rtrim(str_replace('\\', '/', dirname($resourceDir)), '/');
            $cacheDir    = $mediaRoot . "/cache/thumbs/$resourceTypeName";

            $rii = new RecursiveIteratorIterator(
                    new RecursiveDirectoryIterator($baseDir, RecursiveDirectoryIterator::SKIP_DOTS)
            );

            foreach ($rii as $file) {
                if ($file -> isDir())
                    continue;

                $fullPath = str_replace('\\', '/', $file -> getPathname());

                // пропускаме cache/thumbs
                if (str_contains($fullPath, '/cache/thumbs/')) {
                    continue;
                }

                $ext = strtolower(pathinfo($fullPath, PATHINFO_EXTENSION));
                if (!in_array($ext, ['jpg', 'jpeg', 'png', 'webp'], true)) {
                    continue;
                }

                // Нормализираме baseDir да е със / и без trailing /
                $baseDirNorm = rtrim(str_replace('\\', '/', $baseDir), '/') . '/';

                // относителен път спрямо baseDir
                $relativePath = ltrim(str_replace($resourceDir . '/', '', $fullPath), '/');

                // safety – ако някъде се е промъкнал resourceTypeName
                if (str_starts_with($relativePath, $resourceTypeName . '/')) {
                    $relativePath = substr($relativePath, strlen($resourceTypeName) + 1);
                }

                // папка + файл
                $dir      = dirname($relativePath);
                $folder   = ($dir === '.' ? '/' : '/' . trim($dir, '/') . '/');
                $fileName = basename($relativePath);

                // къде трябва да е кеширания thumb файл
                $thumbPath = rtrim($cacheDir, '/') . $folder . $fileName;

                // Проверка дали thumbnail вече съществува
                if (!is_dir($thumbPath)) {
                    $resourceType = $this -> app['resource_type_factory'] -> getResourceType($resourceTypeName);
                    
                    // Генерирай само ако липсва
                    $this -> thumbRepo -> getThumbnail(
                            $resourceType,
                            $folder,
                            $fileName,
                            150,
                            150
                    );
                }
            }
        }
    }

    public function getEvents() {
        return [];
    }

}
