<?php

/*
 * CKFinder Configuration File
 *
 * For the official documentation visit https://ckeditor.com/docs/ckfinder/ckfinder3-php/
 */

/* ============================ PHP Error Reporting ==================================== */
// https://ckeditor.com/docs/ckfinder/ckfinder3-php/debugging.html
// Production
error_reporting(E_ALL & ~E_DEPRECATED & ~E_STRICT);
ini_set('display_errors', 0);

// Development
// error_reporting(E_ALL);
// ini_set('display_errors', 1);

/* ============================ General Settings ======================================= */
// https://ckeditor.com/docs/ckfinder/ckfinder3-php/configuration.html

$config = array();

/* ============================ Enable PHP Connector HERE ============================== */
// https://ckeditor.com/docs/ckfinder/ckfinder3-php/configuration.html#configuration_options_authentication

$config['authentication'] = function () {
    return true;
};

/* ============================ License Key ============================================ */
// https://ckeditor.com/docs/ckfinder/ckfinder3-php/configuration.html#configuration_options_licenseKey

$config['licenseName'] = 'val';
$config['licenseKey']  = '*8?A-*1**-M**N-*M**-*D**-Q*Z*-2**H';

/* ============================ CKFinder Internal Directory ============================ */
// https://ckeditor.com/docs/ckfinder/ckfinder3-php/configuration.html#configuration_options_privateDir

$config['privateDir'] = array(
    'backend' => 'default',
    'tags'    => '.ckfinder/tags',
    'logs'    => '.ckfinder/logs',
    'cache'   => 'cache',
    'thumbs'  => 'cache/thumbs',
);

/* == Images and Thumbnails ================================== */
// https://ckeditor.com/docs/ckfinder/ckfinder3-php/configuration.html#configuration_options_images
// Set different values for the "Files" resource type
// Default configuration values
$config['images'] = array(
    'maxWidth'  => 1024,
    'maxHeight' => 1024,
    'quality'   => 80,
    'sizes'     => array(
        'small'  => array('width' => 480, 'height' => 320, 'quality' => 80),
        'medium' => array('width' => 600, 'height' => 480, 'quality' => 80),
        'large'  => array('width' => 800, 'height' => 600, 'quality' => 80)
    )
);

$parsed_url = parse_url($_SERVER['HTTP_REFERER']);
parse_str($parsed_url['query'] ?? '', $params);

if (!empty($params['view']) && !empty($params['link'])) {
    switch ($params['link']) {
        case 'slideshow':
            $config['images']['maxWidth']  = 1900;
            $config['images']['maxHeight'] = 1024;
            break;

        case 'home_banerBlock1':
        case 'logo':
        case 'categories':
            $config['images']['maxWidth']  = 500;
            $config['images']['maxHeight'] = 500;
            break;
    }
}

$config['thumbnails'] = array(
    'enabled'      => true,
    'sizes'        => array(
        array('width' => '150', 'height' => '150', 'quality' => 80),
    // array('width' => '300', 'height' => '300', 'quality' => 80),
    // array('width' => '500', 'height' => '500', 'quality' => 80),
    ),
    'bmpSupported' => false,
);
/* === Backends ======================================== */
// https://ckeditor.com/docs/ckfinder/ckfinder3-php/configuration.html#configuration_options_backends

$path    = substr(getcwd(), 0, strpos(getcwd(), 'public_html'));
$env     = [];
$envFile = file_get_contents(((dirname(__DIR__, 3))) . '/.env');
preg_match_all('/app\.(mediaRoot|mediaUrl)\s*=\s*(\S+)/', $envFile, $matches, PREG_SET_ORDER);

// Store the matched environment variables
foreach ($matches as $match) {
    $env[$match[1]] = $match[2];
}

$config['backends'][] = array(
    'name'               => 'default',
    'adapter'            => 'local',
    'baseUrl'            => $env['mediaUrl'],
    'root'               => $path . $env['mediaRoot'], // Can be used to explicitly set the CKFinder user files directory.
    'chmodFiles'         => 0777,
    'chmodFolders'       => 0755,
    'filesystemEncoding' => 'UTF-8',
);

/* === Resource Types ===================================== */
// https://ckeditor.com/docs/ckfinder/ckfinder3-php/configuration.html#configuration_options_resourceTypes

$config['defaultResourceTypes'] = '';

//$config['resourceTypes'][] = array(
//    'name'              => 'Tutorials',
//    'directory'         => 'tutorials',
//    'maxSize'           => 0,
//    'allowedExtensions' => 'bmp,gif,jpeg,jpg,png',
//    'deniedExtensions'  => '',
//    'backend'           => 'default',
//    'lazyLoad'          => true
//);
// https://ckeditor.com/docs/ckfinder/ckfinder3-php/configuration.html#configuration_options_accessControl
$config['resourceTypes']   = [
    [
        'name'              => 'productImages',
        'directory'         => 'productImages',
        'maxSize'           => 0,
        'allowedExtensions' => 'gif,jpeg,jpg,png,webp',
        'deniedExtensions'  => '',
        'backend'           => 'default',
    ],
    [
        'name'              => 'Файлове',
        'directory'         => 'uploaded_docs',
        'maxSize'           => 0,
        'allowedExtensions' => '',
        'deniedExtensions'  => '',
        'backend'           => 'default',
    ],
    [
        'name'              => 'Портал',
        'directory'         => 'portal_images',
        'maxSize'           => 0,
        'allowedExtensions' => '',
        'deniedExtensions'  => '',
        'backend'           => 'default',
    ],
];
/* ============================ Access Control (Default) ============================== */
$config['accessControl'][] = array(
    'role'                => '*',
    'resourceType'        => '*',
    'folder'              => '/',
    'FOLDER_VIEW'         => false,
    'FOLDER_CREATE'       => true,
    'FOLDER_RENAME'       => true,
    'FOLDER_DELETE'       => true,
    'FILE_UPLOAD'         => false,
    'FILE_VIEW'           => true,
    'FILE_CREATE'         => true,
    'FILE_RENAME'         => true,
    'FILE_DELETE'         => true,
    'IMAGE_RESIZE'        => true,
    'IMAGE_RESIZE_CUSTOM' => true
);

parse_str($_SERVER['QUERY_STRING'] ?? '', $query);

$isFile   = ($query['id'] ?? null) == 'file';
$isCat    = ($query['id'] ?? null) == 'categories';
$isPortal = ($params['view'] ?? '') == 'portal';

/* === Dynamic AccessControl ============================ */
if ($isFile) {
    // Достъп за файлове
    $config['accessControl'][1] = [
        'role'         => '*',
        'folder'       => '/',
        'resourceType' => 'Файлове',
        'FOLDER_VIEW'  => true
    ];
} else {
    // По подразбиране
    $resourceType = 'productImages';
    $extra        = [];

    // За Portal или Categories → Портал с ограничения
    if ($isPortal || $isCat) {
        $resourceType = 'Портал';
        $extra        = [
            'FOLDER_CREATE'       => false,
            'FOLDER_RENAME'       => false,
            'FOLDER_DELETE'       => false,
            'IMAGE_RESIZE'        => false,
            'IMAGE_RESIZE_CUSTOM' => false,
        ];
    }

    $config['accessControl'][0] = array_merge(
            $config['accessControl'][0],
            [
                'resourceType' => $resourceType,
                'FOLDER_VIEW'  => true,
            ],
            $extra
    );
}


//$allowedFolder = '/_models';
if (!empty($query['id'])) {
    // Разрешаваме избраните папки
    $isTrue = in_array($query['id'], ['categories', '_models', '_brand'], true);

    $config['accessControl'][] = [
        'role'          => '*',
        'resourceType'  => '*', //за всички ресурси
        'folder'        => '/' . $query['id'],
        'FOLDER_VIEW'   => true,
        'FILE_UPLOAD'   => true,
        'FOLDER_CREATE' => $isTrue,
        'FOLDER_DELETE' => $isTrue,
        'FOLDER_RENAME' => $isTrue,
    ];

    // Вземаме реалния resourceType от правилото 0
    $resourceType = $config['accessControl'][0]['resourceType'];

    if ($resourceType == 'productImages') {
//        $excludeDir = $query['id'] ?? '';
//        $rootPath   = $config['backends'][0]['root'] . $resourceType;
//        $folderList = array_filter(scandir($rootPath), function ($dir) use ($rootPath, $excludeDir) {
//            return is_dir($rootPath . '/' . $dir) && !in_array($dir, ['.', '..', $excludeDir]);
//        });

        $config['accessControl'][] = [
            'role'         => '*',
            'resourceType' => $resourceType,
            'folder'       => '/*',
            'FOLDER_VIEW'  => false,
        ];
//        foreach ($folderList as $folderName) {
//            $config['accessControl'][] = [
//                'role'         => '*',
//                'resourceType' => $resourceType,
//                'folder'       => '/' . $folderName,
//                'FOLDER_VIEW'  => false,
//            ];
//        }
  
    } else {
        // Във всички други случаи – скриваме всички подпапки
        $config['accessControl'][] = [
            'role'         => '*',
            'resourceType' => '*',
            'folder'       => '/*',
            'FOLDER_VIEW'  => false,
        ];
    }
} else {

    $config['accessControl'][] = [
        'role'         => '*',
        'resourceType' => '*', //за всички ресурси
        'folder'       => '/*',
        'FILE_UPLOAD'  => true,
    ];

    foreach (['_brand', '_models'] as $folderName) {
        $config['accessControl'][] = [
            'role'         => '*',
            'resourceType' => '*',
            'folder'       => '/' . $folderName,
            'FOLDER_VIEW'  => false,
        ];
    }
}

/* ================================ Access Control ===================================== */
// https://ckeditor.com/docs/ckfinder/ckfinder3-php/configuration.html#configuration_options_roleSessionVar

$config['roleSessionVar'] = 'CKFinder_UserRole';

/* ================================ Other Settings ===================================== */
// https://ckeditor.com/docs/ckfinder/ckfinder3-php/configuration.html

$config['overwriteOnUpload']        = false;
$config['checkDoubleExtension']     = true;
$config['disallowUnsafeCharacters'] = true;
$config['secureImageUploads']       = true;
$config['checkSizeAfterScaling']    = true;
$config['htmlExtensions']           = array('html', 'htm', 'xml', 'js');
$config['hideFolders']              = array('.*', 'CVS', '__thumbs');
$config['hideFiles']                = array('.*');
$config['forceAscii']               = true;
$config['xSendfile']                = false;

// https://ckeditor.com/docs/ckfinder/ckfinder3-php/configuration.html#configuration_options_debug
$config['debug'] = true;

/* ==================================== Plugins ======================================== */
// https://ckeditor.com/docs/ckfinder/ckfinder3-php/configuration.html#configuration_options_plugins

$config['pluginsDirectory'] = __DIR__ . '/plugins';

$config['plugins'] = ['AutoThumbRegenerator'];

/* ================================ Cache settings ===================================== */
// https://ckeditor.com/docs/ckfinder/ckfinder3-php/configuration.html#configuration_options_cache

$config['cache'] = array(
    'imagePreview' => 24 * 3600,
    'thumbnails'   => 24 * 3600 * 365,
    'proxyCommand' => 0
);

/* ============================ Temp Directory settings ================================ */
// https://ckeditor.com/docs/ckfinder/ckfinder3-php/configuration.html#configuration_options_tempDirectory

$config['tempDirectory'] = sys_get_temp_dir();

/* ============================ Session Cause Performance Issues ======================= */
// https://ckeditor.com/docs/ckfinder/ckfinder3-php/configuration.html#configuration_options_sessionWriteClose

$config['sessionWriteClose'] = true;

/* ================================= CSRF protection =================================== */
// https://ckeditor.com/docs/ckfinder/ckfinder3-php/configuration.html#configuration_options_csrfProtection

$config['csrfProtection'] = false;

/* ===================================== Headers ======================================= */
// https://ckeditor.com/docs/ckfinder/ckfinder3-php/configuration.html#configuration_options_headers

$config['headers'] = array();

$config['plugin_imageresize']['smallThumb'] = '90x90';
$config['imageDriversPriority']             = ['Imagick', 'Gd'];
/* ============================== End of Configuration ================================= */

// Config must be returned - do not change it.
return $config;
