/* global loadPlugins */

( function ($, window, document, undefined) {

    var groups = groups || {};
    groups = {
        '__var': {
            table: 'tbl_users'
        },
        'init': function ( ) {
            $.v = this.__var;
            $.This = this;
            this.plugins( );
            this.setUpListeners( );
        },
        'plugins': function ( ) {
            Lp = loadPlugins;
            Ta = tableActions;

            Ta.table.filterByCol({'input': '.filter', 'table': '#tbl_groups'}); // филтър
        },
        'setUpListeners': function ( ) {

            //EVENTS
            $(document).on('submit', '#form-group', this.events.new);

            //BTN
            $(document)
                    .on('click', 'tbody td.action .edit', this.btn.edit)
                    .on('click', 'tbody td.action .cansel', this.btn.cansel)
                    .on('click', '.action .save', this.btn.save);
        },
        'events': {
            'new': function (e) {
                e.stopImmediatePropagation();
                e.preventDefault();
                const form = $(this);
                const formData = form.serializeJSON();
                const route = form.attr('action');

                $.ajax({
                    url: route,
                    type: 'POST',
                    data: formData,
                    dataType: 'json',
                    success: function (response) {
                        if (response.success === false) {
                            $('body').append(response.msg);
                            $('a').removeClass('css-animation-err');
                        }
                        else {
                            history.go(0);
                        }
                    }
                });
            },
        },

        'btn': {
            'edit': function ( ) {
                var $tr = $(this).closest('tr');
                var select = $tr.find('td.groups select');

                select.removeClass('hide');
                select.find(`option:contains("${$tr.find('td.groups span').text( ).trim( )}")`).prop('selected', true);
                $tr.find('input[type=hidden]').attr('type', 'text');
                $tr.find('span').hide( );
                $tr.find('.btnGroup1').addClass('hide');
                $tr.find('.btnGroup2').removeClass('hide');

                event.stopImmediatePropagation();
            },

            'cansel': function ( ) {
                var $tr = $(this).closest('tr');

                $tr.find('input[type=text]').attr('type', 'hidden');
                $tr.find('select').addClass('hide');
                $tr.find('span').show( );
                $tr.find('.btnGroup1').removeClass('hide');
                $tr.find('.btnGroup2').addClass('hide');

                event.stopImmediatePropagation();
            },

            'save': function (e) {
                e.stopImmediatePropagation();
                var $tr = $(this).closest('tr');
                var table = $('#tbl_users');

                $.ajax({
                    url: $(this).data('route'), // oт VIEW__footer
                    type: 'POST',
                    data: $tr.find('input,select').serializeJSON( ),
                    dataType: 'json',
                    success: function (response) {
                        if (response.success === false) {
                            $('body').append(response.msg);
                            $('a').removeClass('css-animation-err');
                        }
                        else {
                            history.go(0);
                        }
                    }
                });
            }
        }
    }

    groups.init( );

} )(jQuery, window, document);
