/* global loadPlugins */

( function ($, window, document, undefined) {

    var groupPermision = groupPermision || {};
    let v = groupPermision;
    let $self = groupPermision;

    groupPermision = {
        '__var': {},
        'init': function ( ) {
            v = this.__var;
            $self = this;

            this.plugins( );
            this.setUpListeners( );
        },
        'plugins': function ( ) {
            Lp = loadPlugins;
        },
        'setUpListeners': function ( ) {

            //EVENTS
            $(document)
                    .on('change', '#groupSelect', this.events.select_group)
                    .on('change', '#typeSelect', this.events.change_typeSelect)
                    .on('change', '#formSelect select', this.events.select_form)
                    .on('change', 'tbody input[type="checkbox"]', this.events.change_chk_permisions)
                    // .on('click', 'tbody td.button-item', this.events.change_chk_permisions)
                    .on('click', '[id^="selectAll"]', this.events.chk_selectAll);

            //BTN
            // $(document).on('click', 'tbody td.action .edit', this.btn.edit);

        },

        'events': {
            // избор на потребителска група
            'select_group': function (e) {
                let _this = $(this);
                const $typeSelect = $('#typeSelect');
                const url = new URL(window.location.href);

                url.searchParams.set('selectedGroupId', _this.val());
                $typeSelect.prop('disabled', !_this.val()).val('');
                $('#formSelect').addClass('hidden').find('select').val('');

                $(".main-content").load(url.toString() + ' .main-content>*', function (response, status, xhr) {});
            },

            // Избор на тип 
            'change_typeSelect': function (e) {
                const value = this.value;
                const sidebar = $('.sidebar');
                const mainContent = $('.main-content');


                $('#block-modules, #block-forms, #formSelect').addClass('hidden');

                // Показваме съдържанието само ако има избрано нещо
                sidebar.toggleClass('centered', value === '');
                mainContent.toggleClass('hidden', value === '');

                // Показване според избора
                switch (value) {
                    case 'modules':
                        $('#block-modules').removeClass('hidden');
                        $('#container').addClass('col');
                        break;
                    case 'forms':
                        $('#formSelect').removeClass('hidden').find('select').val('');
                        $('#container').removeClass('col');
                        break;
                }
            },

            // избор на форма
            'select_form': function (e) {
                let _this = $(this);
                var selectedForm = _this.val();
                let selectedText = _this.find('option:selected').text();
                let blockForm = $('#block-forms');

                blockForm.find('#headerTitle').text(selectedText);

                // 1. показване на блок форми
                blockForm.removeClass('hidden');
                // 2. показване на slider отметката според коя форма е отворена
                blockForm.find('tbody tr').addClass('hidden');

                // Показваме само реда за избраната форма
                if (selectedForm) {
                    blockForm.find('tr[data-form="' + selectedForm + '"]').removeClass('hidden');
                }
            },

            // Избор на отметки в колоната
            'change_chk_permisions': function (e) {
                e.stopImmediatePropagation();
                $self.private.sendForm(e);
                return false;
            },

            // Избор на всички отметки в колоната
            'chk_selectAll': function (e) {
                const $btn = $(this);
                const id = this.id;
                const action = id.replace('selectAll', '').toLowerCase();
                const isForm = id === 'selectAllInForm';
                const $checkboxes = ( isForm ? $btn.closest('table') : $(document) ).find('tbody tr:visible .module-' + action);

                const allChecked = $checkboxes.length === $checkboxes.filter(':checked').length;

                if (!confirm(`Това действие ще активира всички бутони за функцията - ${$btn.text().trim()}. Ще продължите ли?`)) {
                    return;
                }

                $checkboxes.prop('checked', !allChecked);
                $self.private.sendForm();
            }
        },

        'btn': {},

        // Частна функция 
        'private': {
            'sendForm': function (e) {

//                let checkbox;
//
//                console.log($(e.target));
//                if ($(e.target).is('td')) {
//                    // Ако е кликнато върху td, намери checkbox вътре
//                    checkbox = $(e.target).find('input[type="checkbox"]');
//                    console.log(2);
//                    checkbox.prop('checked', !checkbox.prop('checked'));
//
//                }
//                if ($(e.target).is('input')) {
//                    console.log(4);
//                    console.log($(e.target).attr('class'));
//                    checkbox = $(this);
//                    checkbox.prop('checked', !checkbox.prop('checked'));
//                }
//
//                else {
//                    console.log(3);
//                    checkbox = $(e.target).closest('td').find('input[type="checkbox"]');
//                    checkbox.prop('checked', !checkbox.prop('checked'));
//                }
//

                const form = $('#form-modules');
                const formData = form.serializeJSON();
                const route = form.attr('action');


                $.ajax({
                    url: route,
                    type: 'POST',
                    dataType: 'json',
                    data: formData,
                    success: function (response) {
                        console.log('Permissions updated:', response);
                    }
                });

            }
        }
    };

    groupPermision.init( );
} )(jQuery, window, document);
