/* global loadPlugins */

( function ($, window, document, undefined) {

    var nashaFirma = nashaFirma || {};
    let v = nashaFirma;

    nashaFirma = {
        '__var': {
            table: '#tbl_products',
            tab: 'spisak/NashiFirmi'
        },
        'init': function () {
            v = this.__var;

            this.plugins();
            this.setUpListeners();
        },
        'plugins': function () {
            Lp = loadPlugins;

            Lp.table_freezeHeader({'table': v.table,  'margin': 75}); // thead frezze
            Lp.columnTableToggle(v.table, v.tab);
            Lp.perPage('#perPage', v.tab);
        },
        'setUpListeners': function ( ) {
            //POPUP
            $(document).on('click', '#new_nashaFirma, tbody td.action .edit', this.modal.open_popup_nashaFirma);

            //EVENTS
            $(document).on('keyup', 'thead .filter', this.events.filter);

            //BTN
            $(document).on('click', 'table thead .sort', this.btn.colSort);
        },

        'modal': {
            'open_popup_nashaFirma': function () {
                Lp.ajax_modalFormOpen({'route': $(this).data('route'), 'ajaxType': 'GET'});
            }
        },

        'events': {
            //търсене по име и колона
            'filter': timeOut(function ( ) {
                var _this = $(this);
                var col = _this.data('sqlCol');
                var params = new URLSearchParams(window.location.search);


                if (_this.val( ).indexOf(' ') >= 0) {
                    _this.val(_this.val( ).trim( ));
                }

                params.set('page', 1);
                params.set('col', col);
                params.set('searchName', _this.val( ));
                history.replaceState({}, '', '?' + params.toString( ));

                if (_this.val( ).length == 0) {
                    params.delete('searchName');
                    params.delete('col');
                    history.replaceState({}, '', '?' + params.toString( ));
                    history.go(0);
                    return false;
                }

                history.go(0);
            }, 700)
        },

        'btn': {
            'colSort': function (e) {

                var rowIndex = $(this).closest('th').index();
                var col = $(this).closest('thead').find('tr:eq(1)').find('th:eq(' + rowIndex + ') input').data('sqlCol');
                var sort = $(this).data('sqlSort');

                var params = new URLSearchParams(window.location.search);
                params.set('sort_col', col);
                params.set('sort_order', sort);
                history.replaceState({}, '', '?' + params.toString());

                history.go(0);
            }

        },

    };

    nashaFirma.init( );

} )(jQuery, window, document);

