/* global LANGpop__izborProduct */
( function ($, window, document, undefined) {

    var popup_speedyTovar = popup_speedyTovar || {};
    let v = popup_speedyTovar;
    let root = popup_speedyTovar;

    popup_speedyTovar = {
        '__var': {
            //table: '#tbl_packList',
            $modal: $('#' + $('.modal').attr('id'))
        },
        'init': function () {
            v = this.__var;
            root = this;

            this.plugins();
            this.setUpListeners();
        },
        'plugins': function ( ) {
            // Lp = loadPlugins;
            // Lp.popupTitle( );
        },
        'setUpListeners': function ( ) {
            //EVENTS
            v.$modal
                    .on('change', '#sendFrom', this.event.select.change_sendFrom)
                    .on('change', '#sender', this.event.select.change_sender)
                    .on('change', '#ship_date', this.event.select.change_shipDate)
                    .on('change', '#service-select', this.event.select.change_service)
                    .on('change', '#pallet-type-select', this.event.select.change_palletType)
                    .on('change', '#sadarzanie', this.event.select.change_sadarzanie)
                    .on('change', '#chk_moneyTransfer', this.event.chk.change_chk_moneyTransfer)
                    .on('change', '#chk_isDocs', this.event.chk.change_chk_isDocs)
                    .on('keyup', '#w,#d', this.event.change_wd)
                    .on('keyup', '#npPrice', this.event.change_npPrice)
                    .on('keyup', '#declaredValue', this.event.change_declaredValue)
                    .on('input', '#totalWeight, #broiPaketi', this.event.change_totalWeight_broiPaketi);

            v.$modal.find('#ship_date').trigger('change');

            // BTN
            v.$modal
                    .on('click', '#add_sizePack', this.btn.add_sizePack)
                    .on('click', '.remove_paletRow', this.btn.remove_paletRow)
                    .on('click', '#save', this.btn.save);
        },

        'event': {
            // отметки
            'chk': {
                // Промяна на отметката документи
                'change_chk_isDocs': function (e) {
                    e.stopImmediatePropagation( );
                    let _this = $(this);
                    let isChecked = _this.is(':checked');
                    let sadarzanie = v.$modal.find('#sadarzanie');
                    let opakovka = v.$modal.find('#opakovka');
                    let declaredValue = v.$modal.find('#declaredValue');
                    let chk_isFragile = v.$modal.find('#chk_isFragile');

                    if (isChecked) {
                        sadarzanie.val('ДОКУМЕНТИ');
                        opakovka.val('ПЛИК');
                    }

                    chk_isFragile[isChecked || declaredValue.val() == '' ? 'prop' : 'removeAttr']('disabled', true);
                    declaredValue.prop('disabled', isChecked);
                },

                // Промяна на отметката паричен превод
                'change_chk_moneyTransfer': function (e) {
                    e.stopImmediatePropagation( );
                    let _this = $(this);
                    let chk_includePriceInNP = v.$modal.find('#chk_includePriceInNP');
                    let npPrice = v.$modal.find('#npPrice');

                    if (npPrice.val() == '') {
                        return false;
                    }

                    chk_includePriceInNP[ _this.is(':checked') ? 'prop' : 'removeAttr']('disabled', true);
                    chk_includePriceInNP.prop('checked', false);
                },
            },

            'select': {

                // ot къде ще се праща пратката врата или офис
                'change_sendFrom': function (e) {
                    e.stopImmediatePropagation( );

                    var isDoor = $(this).val() == 'fromDoor';
                    var isOffice = $(this).val() == '';

                    v.$modal.find('#officeLocatorRow, #block_zaqvkaCurier').toggleClass('hide', !isOffice);
                    v.$modal.find('#senderAdresRow').toggleClass('hide', !isDoor);
                },

                // Промяна на selext box подател
                'change_sender': function (e) {
                    e.stopImmediatePropagation( );
                    v.$modal.find('#sender_phone').val($(this).find('option:selected').data('info').phone);
                    v.$modal.find('#sender_name').val($(this).find('option:selected').data('info').name);
                    v.$modal.find('#sender_email').val($(this).find('option:selected').data('info').email);
                    v.$modal.find('#senderId').val($(this).find('option:selected').data('info').id);
                },

                // Промяна на selext box съдържание
                'change_sadarzanie': function (e) {
                    e.stopImmediatePropagation( );
                    let _this = $(this);
                    let chk_isDocs = v.$modal.find('#chk_isDocs');
                    let declaredValue = v.$modal.find('#declaredValue');
                    let isDocValue = _this.val() == 'ДОКУМЕНТИ';

                    chk_isDocs.prop('checked', isDocValue);
                    declaredValue.removeAttr('disabled', !isDocValue);
                },

                // Промяна на типа на палет 
                'change_palletType': function (e) {
                    e.stopImmediatePropagation( );
                    let _this = $(this);
                    let optionSelected = _this.find('option:selected').data('value');
                    let values = optionSelected.split(',');

                    v.$modal.find('#block_sizePack').find('#w').val(values[0]);
                    v.$modal.find('#block_sizePack').find('#d').val(values[1]);

                },

                // Промяна на услугата 
                'change_service': function (e) {
                    e.stopImmediatePropagation( );
                    let _this = $(this);

                    let isOfice = v.$modal.find('#isOfice');
                    let select_declaredValuePayer = v.$modal.find('#declaredValuePayer');
                    let chk_isDocs = v.$modal.find('#chk_isDocs');
                    let optionSelected = _this.find('option:selected').val();
                    let isPaletOption = [ 412, 413 ].includes(Number(optionSelected));

                    if (isPaletOption) {
                        if (Number(isOfice) === 1) {
                            alert('Услугата не е разрешена до офис.');
                            return false;
                        }

                    }
                    else {
                        v.$modal.find('#block_paletTable tbody').empty();
                    }

                    v.$modal.find('#block_sizePack,#block_paletTable')[isPaletOption ? 'removeClass' : 'addClass']('hide');

                    v.$modal.find('#broiPaketi,#totalWeight')[isPaletOption ? 'addClass' : 'removeClass']('pointer-events-none');

                    v.$modal.find('#option_before_payment').prop('disabled', isPaletOption);

                    chk_isDocs.prop('disabled', isPaletOption);
                    select_declaredValuePayer.prop('disabled', isPaletOption);
                },

                // Доставка нa дата
                'change_shipDate': function (e) {
                    e.stopImmediatePropagation( );

                    let shipDate = $(this).val();

                    if (!shipDate)
                        return;

                    let deliverySelect = v.$modal.find("#delivery_date").empty().append(`<option value="${shipDate}">${formatDate(shipDate)}</option>`);

                    getNextValidDates(shipDate).forEach(({ value, text }) =>
                        deliverySelect.append(`<option value="${value}">${text}</option>`)
                    );

                    function formatDate (dateStr) {
                        let [ yyyy, mm, dd ] = dateStr.split('-');
                        return `${dd}-${mm}-${yyyy}`; // Convert YYYY-MM-DD → DD-MM-YYYY
                    }

                    function getNextValidDates (startDate) {
                        let dates = [ ], date = new Date(startDate);

                        while (dates.length < 7) {
                            date.setDate(date.getDate() + 1); // Move to next day
                            if (date.getDay() !== 0) { // Exclude Sundays (0 = Sunday)
                                let isoDate = date.toISOString().split('T')[0];
                                dates.push({value: isoDate, text: formatDate(isoDate)});
                            }
                        }
                        return dates;
                    }
                },

            },

            // Промяна на обявена с-ст
            'change_declaredValue': function (e) {
                e.stopImmediatePropagation( );
                let _this = $(this);
                let chk_isFragile = v.$modal.find('#chk_isFragile');
                let select_declaredValuePayer = v.$modal.find('#declaredValuePayer');

                chk_isFragile[_this.val() == '' ? 'prop' : 'removeAttr']('disabled', true);
                select_declaredValuePayer[_this.val() == '' ? 'prop' : 'removeAttr']('disabled', true);
            },

            // Промяна на наложен платеж
            'change_npPrice': function (e) {
                e.stopImmediatePropagation( );
                let _this = $(this);
                let chk_includePriceInNP = v.$modal.find('#chk_includePriceInNP');
                let chk_allowPayWithCard = v.$modal.find('#chk_allowPayWithCard');
                let chk_moneyTransfer = v.$modal.find('#chk_moneyTransfer');
                let chk_isFragile = v.$modal.find('#chk_isFragile');
                let chk_isDocs = v.$modal.find('#chk_isDocs');
                let declaredValue = v.$modal.find('#declaredValue');
                let select_declaredValuePayer = v.$modal.find('#declaredValuePayer');

                declaredValue.val(_this.val( ));

                chk_includePriceInNP[_this.val() == '' || chk_moneyTransfer.is(':checked') ? 'prop' : 'removeAttr']('disabled', true);
                chk_moneyTransfer[_this.val() == '' ? 'prop' : 'removeAttr']('disabled', true);
                chk_allowPayWithCard[_this.val() == '' ? 'prop' : 'removeAttr']('disabled', true);
                chk_isFragile[declaredValue.val() == '' || chk_isDocs.is(':checked') ? 'prop' : 'removeAttr']('disabled', true);

                select_declaredValuePayer[declaredValue.val() == '' ? 'prop' : 'removeAttr']('disabled', true);
            },

            // Промяна на дължината или ширината на палет 
            'change_wd': function (e) {
                e.stopImmediatePropagation( );
                let _this = $(this);
                let id = _this.attr('id');  // Get the id of the input (either 'w' or 'd')
                // Вземаме стойностите от полетата #w и #d и ги преобразуваме в числа
                let wVal = Number($('#w').val());
                let dVal = Number($('#d').val());

                // Ако и двете стойности са валидни числа

                let $select = v.$modal.find('#pallet-type-select');
                let selectedOption = null;

                // Обхождаме всички опции от select box-а
                $select.find('option').each(function () {
                    // Предполага се, че стойността е във формат "ширина,дълбочина" (напр. "80,60")
                    let optionValue = $(this).data('value'); // ако използвате data-attribute, може да използвате $(this).data('value')

                    let parts = optionValue.split(',');

                    if (parts.length === 2) {
                        let optionW = parseInt(parts[0], 10);
                        let optionD = parseInt(parts[1], 10);

                        // Проверка: ако въведената стойност за w е по-малка или равна на optionW и 

                        // стойността за d е по-малка или равна на optionD, избираме тази опция
                        if (( wVal <= optionW && dVal <= optionD ) || ( wVal <= optionD && dVal <= optionW )) {
                            selectedOption = $(this).val();
                            return false;
                        }
                    }
                });

                // Ако е намерена подходяща опция, избираме я; в противен случай – изчистваме select box-а
                if (selectedOption !== null) {
                    $select.val(selectedOption).attr('selected', true);
                }
                else {
                    $select.val('');
                }

            },

            // Проверка на бр. пакети или общо тегло дали е празно или 0
            'change_totalWeight_broiPaketi': function (e) {
                e.stopImmediatePropagation( );
                let _this = $(this);

                if (_this.val() == '' || _this.val() == 0) {
                    _this.val(1);
                }
            },

        },

        'btn': {
            // премахване на ред с размери на палет
            'remove_paletRow': function (e) {
                e.stopImmediatePropagation();
                let _this = $(this);
                let paletTable = v.$modal.find('#block_paletTable tbody');
                let total = 0;

                _this.closest('tr').remove();

                paletTable.find('td.row_paletTeglo').each(function () {
                    let value = parseFloat($(this).text());

                    if (!isNaN(value)) {
                        total += value;
                    }
                });

                v.$modal.find('#broiPaketi').val(paletTable.find('tr').length).trigger('input');
                v.$modal.find('#totalWeight').val(total).trigger('input');
            },

            //  добавяне на размери на пратката
            'add_sizePack': function (e) {
                e.stopImmediatePropagation();
                let _this = $(this);
                let paletTable = v.$modal.find('#block_paletTable tbody');
                let palletType = v.$modal.find('#pallet-type-select');
                let palletTypeSelected = palletType.find('option:selected');
                let section = _this.closest('section');
                let teglo = Number(section.find('#ww').val());
                let width = Number(section.find('#w').val());
                let depth = Number(section.find('#d').val());
                let height = Number(section.find('#h').val());
                let dimensions = [ width, depth, height ].join('x');
                let tableRowLen = paletTable.find('tr').length + 1;
                let tableRow = '';
                let total = 0;
                let conditions = [ ];

                // Массив с условия за проверки
                conditions = [
                    {check: !palletTypeSelected.val(), message: 'Невалидни размери. Необходимо е размерите да са в диапазона от избирателното поле: Основа на пакети'},
                    {check: isNaN(height) || height == '', message: 'Полето височина е празно.'},
                    {check: height > 220, message: 'Максималната височина не трябва да надвишава 220 см.'},
                    {check: isNaN(teglo) || teglo == '', message: 'Полето тегло е празно.'},
                    {check: teglo > 1200, message: 'Максималното тегло не трябва да надвишава 1200 кг.'}
                ];

                // Изпълняваме всяка проверка
                for (let {check, message} of conditions) {
                    if (check) {
                        alert(message);
                        return false;
                    }
                }

                palletType.val('');
                section.find('input').val('');
                v.$modal.find('#broiPaketi').val(tableRowLen);

                tableRow = `<tr>
                                 <td>
                                     <input type="hidden" name="palet[][paletOsnova]" value="${palletTypeSelected.text()}">
                                    <input type="hidden" name="palet[][paletDimensions]" value="${dimensions}">
                                    <input type="hidden" name="palet[][paletTeglo]" value="${teglo}">
                                    
                                    
                                    <input type="hidden" name="content[parcels][][seqNo]" value="${tableRowLen}">
                                    <input type="hidden" name="content[parcels][][size][width]" value="${width}">
                                    <input type="hidden" name="content[parcels][][size][height]" value="${height}">
                                    <input type="hidden" name="content[parcels][][size][depth]" value="${depth}">
                                    <input type="hidden" name="content[parcels][][weight]" value="${teglo}">
                                </td>
                
                                <td>${palletTypeSelected.text()}</td>
                
                                <td> ${dimensions}</td>
                
                                <td class="row_paletTeglo">${teglo}</td>
                                <td><button class="remove_paletRow btn px-1 py-0 bg-danger">x</button></td>
                          </tr>`;

                paletTable.prepend(tableRow);

                paletTable.find('td.row_paletTeglo').each(function () {
                    let value = parseFloat($(this).text());

                    if (!isNaN(value)) {
                        total += value;
                    }
                });

                v.$modal.find('#totalWeight').val(total);
            },

            'save': function (e) {
                e.stopImmediatePropagation();
                var form = $(this).closest('.modal').find('form');
                var route = form.attr('action');

                if (validate.tovaritelniza_isValid(form) === true) {
                    return false;
                }
                else if (confirm('Сигурни ли сте че искате да генерирате товарителница?') == false) {
                    return false;
                }

                $.ajax({
                    url: route,
                    type: 'POST',
                    data: {'form': form.serializeJSON()},
                    dataType: 'json',
                    success: function (response) {

                        if (response.error) {
                            alert(response.error.message);
                            return false;
                        }

                        history.go(0);
                    }
                });
            }
        }
    };
    popup_speedyTovar.init();
} )(jQuery, window, document);
