/* global loadPlugins */

( function ($, window, document, undefined) {

    var popup_valuta = popup_valuta || {};
    let v = popup_valuta;

    popup_valuta = {
        '__var': {
            $modal: $('#' + $('.modal').attr('id')),
        },
        'init': function ( ) {
            v = this.__var;

            this.setUpListeners( );
        },

        'setUpListeners': function ( ) {

            //EVENTS
            v.$modal.on('keyup', 'tbody input[name=valuta_left],tbody input[name=valuta_right]', this.event.onlyOneValutaSymbol);

            //BTN
            v.$modal.on('click', 'tbody input.isDefault', this.btn.set_defaultValuta);

            v.$modal.on('click', 'tbody td.action .edit', this.btn.edit);
            v.$modal.on('click', '.action .save', this.btn.save);
            v.$modal.on('click', 'tbody td.action .delete', this.btn.delete);
            v.$modal.on('click', 'tbody td.action .cansel', this.btn.cansel);
        },

        'event': {
            // ако въведем символ за валута в някое поле за позиция
            // другото явр се изтрива като стойност
            'onlyOneValutaSymbol': function (e) {
                var _this = $(this);
                var name = _this.attr('name');
                var $tr = _this.closest('tr');

                name = name == 'valuta_left' ? 'valuta_right' : 'valuta_left';
                $tr.find('input[name=' + name + ']').val('');

                e.stopImmediatePropagation();
            }
        },

        'btn': {
            'set_defaultValuta': function (e) {
                var _this = $(this);
                var $tr = _this.closest('tr');

                $.ajax({
                    url: _this.data('route'),
                    type: 'POST',
                    data: {'valutaSymbol': $tr.find('input[name=valuta_symbol]').val(), 'isDefault': $(this).val()},
                    dataType: 'json',
                    success: function (response) {
                        history.go(0);
                    }
                });

                e.stopImmediatePropagation();
            },

            'edit': function (e) {
                var _this = $(this);
                var $tr = _this.closest('tr');

                $tr.find('input[type=hidden]:not(.id)').attr('type', 'text');
                $tr.find('span').hide( );
                $tr.find('.btnGroup1').addClass('hide');
                $tr.find('.btnGroup2').removeClass('hide');

                e.stopImmediatePropagation();
            },

            'cansel': function (e) {
                var _this = $(this);
                var $tr = _this.closest('tr');

                $tr.find('input[type=text]').attr('type', 'hidden');
                $tr.find('span').show( );
                $tr.find('.btnGroup1').removeClass('hide');
                $tr.find('.btnGroup2').addClass('hide');

                e.stopImmediatePropagation();
            },

            'save': function (e) {
                var _this = $(this);
                var table = _this.closest('table');
                var $tr = _this.closest('tr');

                $.ajax({
                    url: _this.data('route'),
                    type: 'POST',
                    data: {'form': $tr.find('input').serializeJSON( )},
                    dataType: 'json',
                    success: function (response) {
                        if (response != '') {
                            table.find('tbody').html(response);
                        }

                        table.find('thead input').val('');
                    }
                });

                e.stopImmediatePropagation();
            },

            'delete': function (e) {
                var _this = $(this);
                var $tr = _this.closest('tr');
                var name = _this.data('name');

                if (!confirm(LANGpop__valuta.confirm.delete + ' ' + name)) {
                    return false;
                }

                $.ajax({
                    url: _this.data('route'),
                    type: 'POST',
                    dataType: 'json',
                    success: function (response) {
                        $tr.remove();
                        alert(response);
                    }
                });

                e.stopImmediatePropagation();
            }
        }
    };
    popup_valuta.init( );
} )(jQuery, window, document);

