/* global categoryTree, mqrkaTree, form, Popup_product_fillCatSelect, loadPlugins, categoryAttr, CKEDITOR */
( function ($, window, document, undefined) {

    var popup_shablon = popup_shablon || {};
    let v = popup_shablon;


    popup_shablon = {
        '__var': {
            $modal: $('#' + $('.modal').attr('id')),
            $shablonOfer: $('#shablon-ofer')
        },
        'init': function () {
            v = this.__var;

            this.plugins();
            this.setUpListeners();
        },
        'plugins': function () {
            Lp = loadPlugins;
            Lp.popupTitle('hover');
        },
        'setUpListeners': function ( ) {

            //=====  EVENTS =====================================
            // ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
            ///избор на шаблон
            v.$modal.on('change', '#izborShablon', this.events.izborShablon);

            //=====  BUTTONS ====================================
            // ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
            v.$modal
                    .on('click', '#edit', this.btn.edit)
                    .on('click', '#save', this.btn.save)
                    .on('click', '#copy', this.btn.copy)
                    .on('click', '#delete', this.btn.delete);
        },
        'events': {
            // избиране на шаблон от selectbox
            'izborShablon': function (e) {
                e.stopImmediatePropagation();

                var route = $(this).data('route');
                var optionSelectedId = $(this).val( );

                if (optionSelectedId == '') {
                    CKEDITOR.instances.ck_header.setData('');
                    CKEDITOR.instances.ck_footer.setData('');
                    return false;
                }

                $.ajax({
                    url: route,
                    type: "GET",
                    data: {'optionSelectedId': optionSelectedId},
                    dataType: 'json',
                    success: function (data)
                    {
                        CKEDITOR.instances.ck_header.setData(data.shablon_header);
                        CKEDITOR.instances.ck_footer.setData(data.shablon_footer);
                    }
                });
            }
        },
        'btn': {
            'edit': function () {
                var route = $(this).data('route');
                var $modalFooter = $(this).closest('.modal-footer');
                var shablonId = $modalFooter.find('#izborShablon option:selected');
                var exists = false;

                if (shablonId.val( ) != '') {
                    do {

                        var shablonName = prompt(LANGpop__shablon.edit.prompt.shablonName, shablonId.text( )); // Въведете име на шаблонът

                        switch (shablonName) {
                            case '':
                                alert(LANGpop__shablon.edit.alert.shablonName_empty);//Не сте попълнили име на шаблон
                                break;
                            case null:
                                return false;
                                break;
                            default:
                                $modalFooter.find('#izborShablon option').each(function ( ) {
                                    if (this.text == shablonName) {
                                        exists = true;
                                        alert(LANGpop__shablon.edit.alert.shablonName_dub);//Въведеното име се дублира! Изберете друго име
                                        return false;
                                    }
                                    else {
                                        exists = false;
                                    }
                                });
                                break;
                        }
                    }
                    while (shablonName == "" || exists == true);

                    $.ajax({
                        url: route,
                        type: "POST",
                        data: {'shablonId': shablonId.val( ), 'shablonName': shablonName},
                        dataType: 'json',
                        success: function ()
                        {
                            alert(LANGpop__shablon.edit.alert.shablonName_success);//Шаблонът е преименуван
                            shablonId.text(shablonName);
                            v.$shablonOfer.find(`option[value=${shablonId.val( )}]`).text(shablonName);
                        }
                    });
                }
                else {
                    alert(LANGpop__shablon.edit.alert.shablon_izb);//Изберете шаблон
                }

                event.stopImmediatePropagation();
            },

            // бутон запис на шаблон
            'save': function () {
                var exists = false;
                var route = $(this).data('route');
                var $modalFooter = $(this).closest('.modal-footer');
                var shablonId = $modalFooter.find('#izborShablon option:selected');
                var select = $modalFooter.find('#izborShablon');
                var shablonName = '';
                var shablon_header = CKEDITOR.instances.ck_header.getData( );
                var shablon_footer = CKEDITOR.instances.ck_footer.getData( );


                if (shablon_header == "") {
                    alert(LANGpop__shablon.save.alert.emty);//Внимание! неможе да запишете празен шаблон
                    return false;
                }
                if (shablonId.val( ) == '') {
                    do {
                        shablonName = prompt(LANGpop__shablon.save.prompt.enterName, '');//Въведете име на шаблонът

                        switch (shablonName) {
                            case '':
                                alert(LANGpop__shablon.save.alert.shablonName_empty);//Не сте попълнили име на шаблон
                                break;
                            case null:
                                return false;
                                break;
                            default:
                                $modalFooter.find('#izborShablon option').each(function ( ) {
                                    if (this.text == shablonName) {
                                        exists = true;
                                        alert(LANGpop__shablon.save.alert.shablonName_dub);//Въведеното име се дублира! Изберете друго име
                                        return false;
                                    }
                                    else {
                                        exists = false;
                                    }
                                });
                                break;
                        }
                    }
                    while (shablonName == "" || exists == true);
                }
                else {
                    //Искате ли да обновите шаблон с име: .Искате ли да продължите?
                    if (!confirm(LANGpop__shablon.save.confirm.updateShablon + shablonId.text( ) + LANGpop__shablon.save.confirm.updateShablon_continue)) {
                        return false;
                    }
                }

                $.ajax({
                    url: route,
                    type: "POST",
                    data: {'shablon_header': shablon_header, 'shablon_footer': shablon_footer, 'shablonName': shablonName != '' ? shablonName : shablonId.text( ), 'shablonId': shablonId.val( )},
                    dataType: 'json',
                    success: function (data)
                    {
                        //CKEDITOR.instances.ck_header.setData('');
                        alert(LANGpop__shablon.save.alert.shablonOk);//'Шаблонът е записан

                        if (data.hasOwnProperty('lastId')) {
                            select.append('<option value="' + data.lastId + '">' + shablonName + '</option>');
                            select.find('option:contains(' + shablonName + ')').attr('selected', 'selected');
                        }

                    }
                });

                event.stopImmediatePropagation();
            },

            // бутон копирай шаблон
            // бутон копирай шаблон
            copy: function () {
                var exists = false;
                var route = $(this).data('route')
                var $modalFooter = $(this).closest('.modal-footer');
                var shablonId = $modalFooter.find('#izborShablon option:selected');
                var select = $modalFooter.find('#izborShablon');

                if (shablonId.val() == '') {

                    alert(LANGpop__shablon.copy.alert.izborShablon);//Моля изберете шаблон от падащото меню за да го копирате
                    return false;
                }

                //Сигурни ли сте, че искате да копирате шаблон:
                if (confirm(LANGpop__shablon.copy.confirm.copyShablon + shablonId.text( ) + "?") == true) {

                    do {
                        var shablonName = prompt(LANGpop__shablon.copy.prompt.shablonName, '');//Въведете име на шаблонът
                        switch (shablonName) {
                            case '':
                                alert(LANGpop__shablon.copy.alert.isEmptyName);//Не сте попълнили име на шаблон
                                break;
                            case null:
                                return false;
                                break;
                            default:
                                $modalFooter.find('#izborShablon option').each(function ( ) {
                                    if (this.text == shablonName) {
                                        exists = true;

                                        alert(LANGpop__shablon.copy.alert.dubName);//Въведеното име се дублира! Изберете друго име
                                        return false;
                                    }
                                    else {
                                        exists = false;
                                    }
                                });
                                break;
                        }
                    }
                    while (shablonName == "" || exists == true);

                    // премахване на спец символи
                    // shablonName = clearSpecial_char.remove_cpecial_chars_from_promt(shablonName);

                    $.ajax({
                        url: route,
                        type: "POST",
                        data: {'shablonName': shablonName, 'shablonId': shablonId.val( )},
                        dataType: 'json',
                        success: function (data)
                        {

                            select.append('<option value="' + data + '">' + shablonName + '</option>');
                            // set името на копираният шаблон в dropdown
                            //select.find('option:contains(' + shablonName + ')').attr('selected', 'selected');
                            alert(LANGpop__shablon.copy.alert.copyOk + shablonId.text( ) + LANGpop__shablon.copy.alert.copyOk2 + shablonName);//Шаблонът e копиран с име:
                        }
                    });
                }

                event.stopImmediatePropagation();
            },

            // бутон изтриване на шаблон
            // =========================
            delete: function () {

                var route = $(this).data('route');
                var $modalFooter = $(this).closest('.modal-footer');
                var shablonId = $modalFooter.find('#izborShablon option:selected');
                var select = $modalFooter.find('#izborShablon');

                if (shablonId.val() == '') {

                    alert(LANGpop__shablon.delete.alert.izbShablon);//Моля изберете шаблон от падащото меню за да го изтриете.
                    return false;
                }

                //Сигурни ли сте, че искате да изтриете шаблон
                if (confirm(LANGpop__shablon.delete.confirm.deleteShablon + shablonId.text( ) + "?") == true) {

                    $.ajax({
                        url: route,
                        type: "POST",
                        data: {'shablonId': shablonId.val( )},
                        dataType: 'json',
                        success: function (data)
                        {
                            CKEDITOR.instances.ck_header.setData('');
                            CKEDITOR.instances.ck_footer.setData('');
                            shablonId.remove();

                            alert(LANGpop__shablon.delete.alert.deleteOk);//Шаблонът е изтрит
                        }
                    });
                }

                event.stopImmediatePropagation();
            }
        }
    };
    popup_shablon.init();

} )(jQuery, window, document);
