/* global LANGpop__izborProduct, loadPlugins */
( function ($, window, document, undefined) {

    var popup_mqrka = popup_mqrka || {};
    let v = popup_mqrka;

    popup_mqrka = {
        '__var': {
            $modal: null,
            modalId: null,
            modalTable: null,
        },

        'init': function () {
            const self = this;
            v = this.__var;

            Lp = loadPlugins;

            $('.modal').on('show.bs.modal', function (event) {
                v.$modal = $(event.target);

                Lp.table_freezeHeader({'table': v.$modal.find('table'), 'left': 'auto', 'scroll': v.$modal.find('.overflow-auto'), 'margin': -16}); // thead frezze
                self.setUpListeners();
            });
        },
        'setUpListeners': function ( ) {
            //EVENTS
            v.$modal.on('change', '.mqrka_tip', this.event.change_mqrkaTip);


            //BTN
            v.$modal.on('click', 'table .save', this.btn.save)
                    .on('click', 'tbody .edit', this.btn.edit)
                    .on('click', 'tbody .delete', this.btn.delete)
                    .on('click', 'tbody .cansel', this.btn.cansel);


        },

        'event': {
            'change_mqrkaTip': function (e) {
                var tr = $(this).closest('tr');

                $.ajax({
                    url: $(this).data('route'),
                    type: 'POST',
                    data: {'tip': $(this).val()},
                    dataType: 'json',
                    success: function (response) {

                    }
                });
            }
        },

        'btn': {

            'save': function (e) {
                var _this = $(this);
                var table = _this.closest('table');
                var $tr = _this.closest('tr');
                var name = $tr.find('.name:visible');
                var unit = $tr.find('.unit:visible');

                if (!confirm(LANGpop__mqrka.confirm.save)) {
                    $tr.find('.cansel').trigger('click');
                    return false;
                }

                if (name.val() == '') {
                    alert(LANGpop__mqrka.alert.isEmptyName);//Липсва име на категория!
                    name.focus();
                    return false;
                }
                else if (unit.val() == '') {
                    alert(LANGpop__mqrka.alert.isEmptyUnit);//Липсва име на категория!
                    unit.focus();
                    return false;
                }

                $.ajax({
                    url: _this.data('route'),
                    type: 'POST',
                    data: {'form': $tr.find('input').serializeJSON( )},
                    dataType: 'json',
                    success: function (response) {

                        $("#html").load($("#html").data('route') + " #html>*");
                    }
                });

                e.stopImmediatePropagation();
            },

            'edit': function (e) {
                var _this = $(this);
                var tbody = _this.closest('tbody');
                var tr = _this.closest('tr');

                if (tbody.find('.btnGroup2').is(":visible")) {
                    alert(LANGpop__mqrka.alert.isEdit);//Имате недовършена редакция
                    e.stopImmediatePropagation();
                    return false;
                }

                tr.find('span').hide();
                tr.find('input[type=hidden]:not(.id)').attr('type', 'text');

                tr.find('.btnGroup1').addClass('hide');
                tr.find('.btnGroup2').removeClass('hide');

                e.stopImmediatePropagation();
            },

            'delete': function (e) {
                var _this = $(this);
                var tbody = _this.closest('tbody');
                var $tr = _this.closest('tr');
                var name = _this.data('name');

                if (tbody.find('.btnGroup2').is(":visible")) {
                    alert(LANGpop__mqrka.alert.isEdit);//Имате недовършена редакция
                    e.stopImmediatePropagation();
                    return false;
                }

                if (!confirm(LANGpop__mqrka.confirm.delete + ' ' + name)) {
                    return false;
                }

                $.ajax({
                    url: _this.data('route'),
                    type: 'POST',
                    dataType: 'json',
                    success: function (response) {
                        $tr.remove();
                        alert(response);
                    }
                });

                e.stopImmediatePropagation();
            },

            'cansel': function (e) {
                var _this = $(this);
                var $tr = _this.closest('tr');

                $tr.find('input[type=text]').attr('type', 'hidden');
                $tr.find('span').show( );
                $tr.find('.btnGroup1').removeClass('hide');
                $tr.find('.btnGroup2').addClass('hide');


                e.stopImmediatePropagation();
            }
        }
    };

    popup_mqrka.init();

} )(jQuery, window, document);
