/* global loadPlugins, curierLocator */

( function ($) {

    var popup_klient = popup_klient || {};
    let v = popup_klient;
    let $self = popup_klient;

    popup_klient = {
        '__var': {
            $modal: $('#' + $('.modal').attr('id')),
            form: $('.modal form')
        },
        'init': function ( ) {
            v = this.__var;
            $self = this;

            this.plugins( );
            this.validate( );
            this.setUpListeners( );
        },
        'plugins': function ( ) {
            Lp = loadPlugins;
            Cl = curierLocator;
        },
        'validate': function (e) {// промяна на задължит. select box

            v.$modal.on('keyup', '.validate', (e) => {
                e.stopImmediatePropagation( );
                const target = $(e.target);

                if (validate.popupKlient_isValid(v.form)) {
                    return false;
                }
            });

            v.$modal.on('change', '.validate,:radio', (e) => {
                var target = $(e.target);

                if (target.is(':radio') && target.is(':checked')) {
                    target.parent().removeClass('css-animation-err');
                }

                if (target.hasClass('css-animation-err') && target.is('select') && target.val()) {
                    target.removeClass('css-animation-err');
                }
            });
        },

        'setUpListeners': function ( ) {

            // EVENTS
            v.$modal
                    .on('keyup', '.autocompleteCity', Lp.debounce(this.event.autocomplete_city, 300))
                    .on('change', '.izborKurier', this.event.change_kurier)
                    .on('change', '.deliveryMetod', this.event.change_deliveryMetod);

            //BTN
            v.$modal
                    .on('click', 'a.nav-link', (e) => {
                        this.btn.resizeModal(e);
                    })
                    .on('click', '.izbor-klientObekt', this.btn.izbor_klientObekt) // когато избираме от поръчка
                    .on('click', '.grad', this.btn.open_autocomplete_city)
                    .on('click', '.clearCity', function () {
                        var section = $(this).parents('section');
                        section.find('.grad').attr('value', '').val('');
                        section.find('.postCode').attr('value', '').val('');
                    })
                    .on('click', '.econtLocator, #econtLocator', Cl.econtLocator)
                    .on('click', '.speedyLocator, #speedyLocator', Cl.speedyLocator)
                    .on('click', '.clone-block', this.btn.clone_block)
                    .on('click', '.remove-block', this.btn.remove_block)
                    .on('click', '#resetPassword', this.btn.password.resetPassword)
                    .on('click', '#newPasswordSave', this.btn.password.newPassword)
                    .on('click', '.modal-footer #save', this.btn.save);
        },

        'event': {
            // метод на доставка
            'change_deliveryMetod': function (e) {
                e.stopImmediatePropagation();
                var _this = $(this);
                var section = _this.parents('section');
                var blockAdresDostavka = section.find('#block-adresDostavka');
                var otherBlock = section.find('.toCity,.toOfice');

                blockAdresDostavka.toggleClass('hide', _this.val() !== 'curier');
                otherBlock.addClass('hide');
            },

            // autocomplete за градовете
            'autocomplete_city': function (e) {
                e.stopImmediatePropagation();
                var _this = $(this);
                var section = _this.parents('section');
                var autocomplete = section.find('.autocomplete');
                var inputWidth = _this.outerWidth();
                var route = autocomplete.data('route');
                var currentVal = _this.val().trim();
                let maxChar = 3;
                let remainingChars = maxChar - currentVal.length;
                let autocompleteHtml = '';

                // Clear autocomplete suggestions if input is empty
                if (!currentVal) {
                    autocomplete.find('ul').remove();
                    return false;
                }

                if (currentVal.length < maxChar) {
                    autocomplete.find('ul').remove(); // Ensure a fresh start
                    autocomplete.append(`<ul style="width: ${inputWidth}px;"><li>Въведете най-малко ${remainingChars} символа</li></ul>`);
                    return false;
                }

                $.ajax({
                    url: route,
                    type: 'POST',
                    global: false,
                    dataType: 'json',
                    data: {'method': 'get_cities', 'cityName': currentVal},
                    success: function (response) {
                        const data = typeof response === 'string' ? JSON.parse(response) : response;

                        if (!data.result || !data.result.cities || data.result.cities.length === 0) {
                            autocomplete.find('ul').remove(); // Clear previous content
                            autocomplete.append(`<ul style="width: ${inputWidth}px;"><li>Няма намерени населени места.</li></ul>`);
                            return;
                        }

                        autocompleteHtml = data.result.cities.map(city => {
                            let cityInfo = JSON.stringify({id: city.id, postCode: city.postCode, name: city.name});
                            return `<li data-info='${cityInfo}'>${city.name}</li>`;
                        }).join('');

                        autocomplete.find('ul').remove(); // Clear previous content
                        autocomplete.append(`<ul style="width: ${inputWidth}px;">${autocompleteHtml}</ul>`);
                    }
                });

                autocomplete.on('mousedown', 'li', function () {
                    const info = $(this).data('info');
                    section.find('.grad').val(info.name);
                    section.find('.postCode').val(info.postCode);
                    autocomplete.empty();
                });
            },

            // select box метод на доставка
            'change_kurier': function ( ) {
                let _this = $(this);
                let data = _this.find('option:selected').data('arg');
                let fieldset = _this.closest('fieldset');
                let value = _this.val().trim();

                let isEcontLocator = [ 'econt_office', 'econt_machina' ].includes(value);
                let isSpeedyLocator = [ 'speedy_office', 'speedy_machina' ].includes(value);
                let isOffice = data === 'office';
                let isDoor = data === 'door';

                fieldset.find(':input:not(select):not(button)').attr('placeholder', '').val('');

                if (value == '') {
                    fieldset.find('.toOfice, .toAdres, .toCity').addClass('hide');
                    return false;
                }

                // покзване/скриване на елементи от блока
                fieldset.find('.toOfice').toggleClass('hide', !isOffice);
                fieldset.find('.toAdres').toggleClass('hide', !isDoor);
                fieldset.find('.toCity').removeClass('hide');

                // показва/скрива бутона за офис локатор
                fieldset.find('.econtLocator').toggleClass('hide', !isEcontLocator);
                fieldset.find('.speedyLocator').toggleClass('hide', !isSpeedyLocator);

                // задават се валидации
                fieldset.find('.ulica,.ulicaNo').toggleClass('validate', !isOffice);
                fieldset.find('.izborOfice').toggleClass('validate', !isDoor);

                // деактивиране на полета
                fieldset.find('.toCity input, .toOfice input').toggleClass('css-pointer-events-none2', isOffice);
            }
        },

        'btn': {
            'open_autocomplete_city': function (e) {
                var _this = $(this);
                var section = _this.closest('section');
                var autocomplete = section.find('.autocomplete');
                var selectedCourier = section.find('.izborKurier option:selected').val().trim();
                var autocompleteHtml = '';

                // Check if a courier is selected
                if (!selectedCourier) {
                    _this.blur();
                    alert('Изберете куриер на доставка');
                    return false;
                }

                autocompleteHtml = `<input class="autocompleteCity" type="text" placeholder="въведете населено място" style="border: 5px solid #eac263;"><ul class="bg-transparent"></ul>`;
                autocomplete.html(autocompleteHtml);
                autocomplete.find('.autocompleteCity').focus();

                $(document).on('mousedown.autocomplete', function (e) {
                    if (!autocomplete.is(e.target) && autocomplete.has(e.target).length === 0) {
                        autocomplete.empty(); // Clear suggestions
                    }
                });
            },

            'password': {
                // нулиране на паролата на клиент в портала сайт
                'resetPassword': function (e) {
                    e.stopImmediatePropagation( );
                    let _this = $(this);
                    let route = _this.data('route');

                    if (!confirm('Сигурни ли сте, че искате да нулирате паролата?')) {
                        return false;
                    }

                    $.ajax({
                        url: route,
                        type: 'POST',
                        dataType: 'json',
                        success: function (response) {
                            if (response === true) {
                                alert('Паролата е нуллирана');
                                _this.closest('#tab-portal').find('.fa-lock').toggleClass('fa-lock fa-unlock');
                            }
                            else {
                                alert('Грешка: при нулиране на паролата');
                            }

                        }
                    });
                },
                // нова парола на клиент в портала сайт
                'newPassword': function (e) {
                    e.stopImmediatePropagation( );

                    let _this = $(this);
                    let route = _this.data('route');
                    let value = _this.parent().find('#newPassword').val();

                    if (!confirm('Сигурни ли сте, че искате да промените паролата?')) {
                        return false;
                    }

                    if (value == '') {
                        alert('Въведете парола!');
                        return false;
                    }

                    $.ajax({
                        url: route,
                        type: 'POST',
                        dataType: 'json',
                        data: {'password': value},
                        success: function (response) {
                            if (response === true) {
                                alert('Паролата e сменена.');
                                _this.closest('#tab-portal').find('.fa-unlock').toggleClass('fa-unlock fa-lock');
                            }
                            else {
                                alert('Грешка: при смяна на паролата');
                            }
                        }
                    });
                },
            },

            // попълване на данните в модул поръчка за избор на обект. 
            'izbor_klientObekt': function (e) {
                // в модул поръчка избираме съответния обект с данни
                e.stopImmediatePropagation( );
                var route = $(this).data('route');
                var leftAside = $('#leftAside');
                var deliveryObektBlock = leftAside.find('#deliveryObekt-block');
                var deliveryMetod = leftAside.find('#deliveryMetod');
                let imgElement = deliveryObektBlock.find('#curierLogo');
                let mapKurier = {
                    speedy_machina: 'до автомат на Speedy',
                    speedy_office: 'до офис с Speedy',
                    speedy_door: 'до адрес с Speedy',
                    econt_machina: 'до еконтомат с Еконт',
                    econt_office: 'до офис с Еконт',
                    econt_door: 'до адрес с Еконт'
                };

                if (route == '') {
                    alert('След като се добави нов обект е необходимо да се направи запис преди да бъде избран.');
                    return false;
                }

                $.ajax({
                    url: route,
                    type: 'POST',
                    dataType: 'json',
                    success: function (res) {

                        if (res.err) {
                            alert(res.err);
                            return false;
                        }

                        let data = JSON.stringify(res);
                        let izborKurier = res.izborKurier || '';
                        let isOfice = /office|machina/.test(izborKurier);
                        let isDoor = /door/.test(izborKurier);

                        leftAside.find('#deliveryObekt').val(data).attr('value', data);

                        if (res.deliveryMetod == 'curier') {
                            if (izborKurier.includes('econt')) {
                                imgElement.attr('src', '/assets/images/curier/EcontLogo.png');
                            }
                            else if (izborKurier.includes('speedy')) {
                                imgElement.attr('src', '/assets/images/curier/SpeedyLogo.png');
                            }

                            // Populate form fields based on the JSON response
                            $.each(res, function (key, val) {
                                let value = ( key === 'izborKurier' && mapKurier[val] ) ? mapKurier[val] : val;
                                if (key == 'deliveryMetod') {
                                    return;
                                }
                                deliveryObektBlock.find(`#${key}`).val(value);
                            });

                            deliveryObektBlock.find('#toOfice').toggleClass('hide', !isOfice);
                            deliveryObektBlock.find('#toAdres').toggleClass('hide', !isDoor);
                            deliveryObektBlock.find('#toCity input, #toOfice input').toggleClass('css-pointer-events-none2', isOfice);
                        }
                        else {
                            // ako метода на доставка в != от куриер
                            imgElement.attr('src', ''); // скрива лого куриер
                            deliveryObektBlock.find('#deliveryData').addClass('hide');// скрива блок данни за доставка

                            deliveryMetod.find('option').removeAttr('selected');
                            deliveryMetod.find(`option[data-value="${res.deliveryMetod}"]`).attr('selected', true).prop('selected', true);
                        }

                        $('.modal').modal('toggle');
                    }
                });
            },

            'resizeModal': function (e) {
                var modalDialog = $(e.target).closest('.modal-dialog');
                var maxWidth = [ 'link-obekt', 'link-banka' ].includes(e.target.id) ? '95%' : '40vw';

                // Set the maximum width of the modal dialog
                modalDialog.css('max-width', maxWidth);
            },

            'clone_block': function (e) {
                e.stopImmediatePropagation( );
                let tab = v.$modal.find('#tab-obekt');
                let section = tab.find('section');// $(this).closest('section');

                //let parent = block.parent();
                let len = tab.find('section:visible').length;
                let clone = section.first().clone(true);
                let isClonedHiden = clone.hasClass('hide');

                clone.find(":input").attr('name', function ( ) {
                    return this.name.replace(/^(\w+.*?)\[.*?\]/, '$1[' + ( len + 1 ) + ']');
                });

                clone.find(".izbor-klientObekt").attr('data-route', '');
                clone.find(":input:not(:radio)").val('');
                clone.find(":radio").prop('checked', isClonedHiden && len == 1 ? true : false);

                clone.removeClass('hide');
                clone.find('.deliveryMetod').val('curier');


                clone.find('#block-adresDostavka').toggleClass('hide', false);
                clone.find('.toOfice,.toAdres,.toCity').toggleClass('hide', true);
                clone.find('.toCity input, .toOfice input').toggleClass('css-pointer-events-none2', true);

                section.last().after(clone);
            },

            'remove_block': function (e) {
                e.stopImmediatePropagation( );
                var block = $(this).closest('section');
                var siblingCount = block.siblings('section').length + 1;

                if (siblingCount == 1) {
                    block.addClass('hide');
                    block.find(':input').val('');
                    block.find('.obektN').attr('value', 1);
                    $('.css-animation-err').removeClass('css-animation-err');
                    $('.alert').remove( );
                }
                else {
                    block.remove( );
                }
            },

            'save': function (e) { // form submit
                let obektN = v.$modal.find('.obektN');
                let routeRefresh = $(this).data('routeRefresh');

                if (validate.popupKlient_isValid(v.form)) {
                    return false;
                }

                if (obektN.is(':visible') && !obektN.is(':checked')) {
                    obektN.parent().addClass('css-animation-err');
                    alert('Изберете основен обект');
                    return false;
                }

                $(document).off('submit').on('submit', 'form', function (e) {
                    e.preventDefault();
                    const searchParams = new URLSearchParams(window.location.search);
                    var route = $(this).attr('action');
                    var form = $(this).serializeJSON();
                    var table = $('#tbl_products');
                    var url = window.location.href;

                    $.ajax({
                        url: route,
                        type: 'POST',
                        data: form,
                        dataType: 'json',
                        success: function (response) {

                            if (!response.success)
                                return;

                            $('body').append(response.messages);
                            $('a').removeClass('css-animation-err');
                            $('.modal #tab-obekt').load(routeRefresh + ' .modal #tab-obekt>*', {'isRefresh': 1});

                            // ако е списък лист в mainPage
                            if (searchParams.get('page')) {
                                if (!response.klientId) {
                                    table.load(`${window.location.href} #tbl_products>*`);
                                }
                                else {
                                    let rowSelector = `#tbl_products tr[data-id="${response.klientId}"]`;
                                    $(rowSelector).load(`${window.location.href} ${rowSelector} >*`);
                                }
                                return false;
                            }

                            // Винаги презареди #klient_block
                            $('#klient_block').load(`${url} #klient_block>*`);

                            // Презареди #deliveryData само ако сме в оферта
                            if (searchParams.get('orderTip')) {
                                $('#deliveryData').load(`${url} #deliveryData>*`);
                            }
                        }
                    });
                });
            }
        }
    };
    popup_klient.init( );
} )(jQuery);

