/* global LANGpop__izborProduct, $root */
( function ($, window, document, undefined) {

    var popup_colorRow = popup_colorRow || {};
    let v = popup_colorRow;

    popup_colorRow = {
        '__var': {
            table: $("#tbl_products"),
            $modal: $('#' + $('.modal').attr('id'))
        },
        'init': function () {
            v = this.__var;

            this.setUpListeners();
        },
        'setUpListeners': function ( ) {
            //EVENTS
            v.$modal.find('.color').on('click', this.btn.color);

            // бутони   
            v.$modal.on('click', '#add', this.btn.add);
        },

        'btn': {

            'color': function () {
                var tip = $(this).data('color');
                var $settings = v.$modal.find('#settings');
                var color_table = v.$modal.find('#color-table');
                var isMain = $settings.find('#colorRow-isMain');

                if (tip == 'white') {
                    $settings.find('#colorRow-name')
                            .attr('data-text-color', 'text-white')
                            .css('color', '#fff');

                    color_table.find('td.text')
                            .removeClass()
                            .addClass('text font-weight-bold text-white')
                            .addClass(isMain.is(':checked') ? 'h3' : '');
                }
                else {
                    $settings.find('#colorRow-name')
                            .attr('data-text-color', 'text-black')
                            .css('color', '#000');

                    color_table.find('td.text')
                            .removeClass()
                            .addClass('text font-weight-bold text-black')
                            .addClass(isMain.is(':checked') ? 'h3' : '');
                }

                event.stopImmediatePropagation();
            },

            'add': function () {

                var $settings = v.$modal.find('#settings');
                var text = $settings.find('#colorRow-name');
                var backgColor = $("#colorRow-bg").val( );
                var position = $settings.find('#colorRow-position').val( );
                var isMain = $settings.find('#colorRow-isMain');
                var color_table = v.$modal.find('#color-table');
                var colspan = v.table.find('tbody tr:not(.colorRows):first td:visible').length;

                if (v.table.find('tbody tr').length == 0) {
                    alert(LANGpop__colorRow.alert.productExist);//ДОбавете поне 1 продукт в таблицата
                    return false;
                }
                else if (text.val( ) == null || text.val( ) == '') {
                    alert(LANGpop__colorRow.alert.enterColorRowName);//Трябва да въведете текст за цветния ред
                    return false;
                }
                //Сигурни ли сте че искате да добавите нов цветен ред
                else if (confirm(LANGpop__colorRow.confirm.addColorRow) == false) {
                    return false;
                }

                color_table.find('td#hidden').find('[name="colorRows[colorRows][][pos]"]').attr('value', position == '' ? 0 : position);
                color_table.find('td#hidden [name="colorRows[colorRows][][text]"]').attr('value', text.val());
                color_table.find('td#hidden').find('[name="colorRows[colorRows][][backgColor]"]').attr('value', backgColor);
                color_table.find('td#hidden').find('[name="colorRows[colorRows][][isMain]"]').attr('value', isMain.is(":checked") ? 'Y' : '');
                color_table.find('td#hidden').find('[name="colorRows[colorRows][][textColor]"]').attr('value', text.data('textColor'));

                color_table.find('td.text')
                        .removeClass()
                        .addClass('text font-weight-bold')
                        .addClass(text.data('textColor'))
                        .addClass(isMain.is(':checked') ? 'h3' : '')
                        .attr('colspan', colspan - 2)
                        .css({'background': backgColor})
                        .text(text.val( ));

                color_table = color_table.html().replace(/<tbody>|<\/tbody>/g, '');

                // таблица на офертата
                v.table.find(`tbody tr:not(.colorRows):eq(${position})`).before(color_table);

                $('.modal').modal('toggle');

                $root.plugins();

                event.stopImmediatePropagation();
            }
        }
    };

    popup_colorRow.init();

} )(jQuery, window, document);
