/* global loadPlugins, LANGpop__izborProduct, $root, tableActions */
( function ($, window, document, undefined) {


    var popup_izborProduct = popup_izborProduct || {};
    let v = popup_izborProduct;
    let $self = popup_izborProduct;
    let helper;

    popup_izborProduct = {
        '__state': {
            selectAllResults: false
        },
        '__var': {
            $modal: $('#' + $('.modal').attr('id')),
            $table: $('#tbl_products tbody'),
            modalTable: '.modal' + ' #' + $('#' + $('.modal').attr('id')).find('.table').attr('id')
        },
        'init': function () {
            v = this.__var;
            $self = this;
            helper = this.helper;

            this.plugins();
            this.setUpListeners();
        },
        'plugins': function () {
            Lp = loadPlugins;
            Ta = tableActions;

            Lp.popupTitle();
            Lp.table_freezeHeader({'table': v.modalTable, 'left': 'auto', 'scroll': v.$modal.find('.overflow-auto'), 'margin': - 45}); // thead frezze
        },
        'setUpListeners': function ( ) {
            //EVENTS
            v.$modal
                    .on('keyup', 'thead input[type=search]', this.event.search)
                    .on('change', 'thead #inStock', this.event.inStock)
                    .on('change', '#hasGensoftPromo', this.event.hasGensoftPromo)
                    .on('change', '#selectAllResults', this.btn.selectAllResults)
                    .on('change', '#selectPageRows', this.btn.selectPageRows)
                    .on('change', '#perPage', this.event.changePerPage);

            //BTN
            v.$modal
                    .on('click', 'tbody .getGensoftInfo', Ta.getGensoftInfo)// изв на информация от Gensoft за конкретния продукт
                    .on('click', 'thead #selectAll', this.btn.selectAllRows)
                    .on('click', '.table tbody tr', this.btn.selectRows)
                    .on('click', '#pagination li', this.btn.paginationLink)
                    // нулиране на всички филтри
                    .on('click', '#clearFilters', this.btn.clearFilters)
                    .on('click', '#btnAdd', this.btn.addAndSave);
            // .on('click', '#btnAdd', this.btn.add);
        },

        'event': {
            'changePerPage': function () {
                let route = $(this).data('route');
                let requestData = helper.json_prepareFilterData(this);// helper

                $.ajax({
                    url: route,
                    type: 'POST',
                    dataType: 'json',
                    data: requestData,
                    success: function (response) {
                        v.$modal.find('tbody').html(response.table);
                        v.$modal.find('#refreshPagnitation').html(response.pagnitation);

                        if (v.$modal.find('#selectPageRows').is(':checked')) {
                            v.$modal.find('tbody tr').addClass('selected bg-warning');
                        }

                        if (v.$modal.find('#selectAllResults').is(':checked')) {
                            v.$modal.find('tbody tr').addClass('selected bg-warning');
                        }
                    }
                });
            },

            // филтър по промо цена от Gensoft
            'hasGensoftPromo': function () {
                let _this = $(this);
                let route = _this.data('route');
                let requestData = helper.json_prepareFilterData(this);// helper

                v.$modal.find('#selectPageRows').prop('checked', false);
                v.$modal.find('#selectAllResults').prop('checked', false);

                $.ajax({
                    url: route,
                    type: 'POST',
                    dataType: 'json',
                    data: requestData,
                    success: function (response) {
                        v.$modal.find('tbody').html(response.table);
                        v.$modal.find('#refreshPagnitation').html(response.pagnitation);
                        v.$modal.find('#countResults').html(response.totalProducts);
                    }
                });
            },

            // филтър по наличност
            'inStock': function () {
                let _this = $(this);
                let route = _this.data('route');
                let requestData = helper.json_prepareFilterData(this);// helper

                $.ajax({
                    url: route,
                    type: 'POST',
                    dataType: 'json',
                    data: requestData,
                    success: function (response) {
                        v.$modal.find('tbody').html(response.table);
                        v.$modal.find('#refreshPagnitation').html(response.pagnitation);
                        v.$modal.find('#countResults').html(response.totalProducts);
                    }
                });
            },

            // филтър по име и код
            'search': function (e) {
                e.stopImmediatePropagation( );
                var _this = $(this);
                var route = _this.data('route');
                let requestData = helper.json_prepareFilterData(this);// helper

                if (e.key !== "Enter" && e.key !== undefined && _this.val() !== '') {
                    return false;
                }

                $.ajax({
                    url: route,
                    type: 'POST',
                    dataType: 'json',
                    data: requestData,
                    success: function (response) {

                        v.$modal.find('tbody').html(response.table);
                        v.$modal.find('#refreshPagnitation').html(response.pagnitation);
                        v.$modal.find('#countResults').html(response.totalProducts);

                        Lp.popupTitle();
                    }
                });
            }
        },

        'btn': {

            'clearFilters': function (e) {
                e.stopImmediatePropagation( );
                const _this = $(this);
                var ctrl = _this.closest('.modal').data('tipOferta');
                var arg = _this.closest('.modal').data('arg');
                let route = _this.data('route');
                const $menu = v.$modal.find('#categoryFilter');
                const $sidebarFilter = v.$modal.find('#sidebarFilter');

                let requestData = {
                    'ctrl': ctrl,
                    'arg': arg
                };

                $.ajax({
                    url: route,
                    type: 'POST',
                    dataType: 'json',
                    data: requestData,
                    success: function (response) {
                        v.$modal.find('tbody').html(response.table);
                        v.$modal.find('#refreshPagnitation').html(response.pagnitation);
                        v.$modal.find('#countResults').html(response.totalProducts);

                        v.$modal.find('input[type=search],input[type=text]').val('');
                        v.$modal.find('#reset').trigger('click');
                        v.$modal.find(':checkbox').prop('checked', false);
                    }
                });
            },

            // селект на всички редове
            'selectAllRows': function () {
                v.$modal.find('tbody tr').toggleClass('selected bg-warning');
            },

            'selectRows': function (e) {
                var _this = $(this);
                var productId = _this.data('id');
                var isExist = v.$table.find(`tr[data-id=${productId}]`).attr('data-id');

                if ($(e.target).hasClass('actionButtons') || $(e.target).hasClass('fa')) {
                    return;
                }

                // ако избрания продукт вече го има в офертата
                if (productId !== undefined && productId == isExist) {
                    alert(LANGpop__izborProduct.alert.productExist);//Този продукт вече присъства в текущата оферта!
                }
                else if (productId !== undefined) {
                    $(this).toggleClass('selected bg-warning');
                }
            },

            // избиране на текуща стр
            'selectPageRows': function () {
                let isChecked = $(this).is(':checked');

                v.$modal.find('#selectAllResults').prop('checked', false);

                v.$modal.find('tbody tr').each(function () {
                    let $tr = $(this);
                    let productId = $tr.data('id');

                    // ако продуктът вече е добавен – пропускаме
                    if (v.$table.find(`tr[data-id=${productId}]`).length) {
                        return;
                    }

                    if (isChecked) {
                        $tr.addClass('selected bg-warning');
                    }
                    else {
                        $tr.removeClass('selected bg-warning');
                    }
                });
            },

            // маркиране на всички резултати от всички стр 
            'selectAllResults': function () {
                let checked = $(this).is(':checked');

                popup_izborProduct.__state.selectAllResults = checked;

                v.$modal.find('#selectPageRows').prop('checked', false);
                v.$modal.find('tbody tr').toggleClass('selected bg-warning', checked);
            },

            // добавяне на избраните продукти в таблицата на офертата
            'addAndSave': function (e) {
                e.stopImmediatePropagation( );
                let _this = $(this);
                let routeSave = _this.data('route-save');// за oferId == 0
                let routeAdd = _this.data('route-add');   // за oferId > 0
                let ctrl = _this.data('ctrl');
                let pagination = $('body').find('ul.pagination');

                // текуща активна страница
                let currentLink = pagination.find('li.page-item.active a[href*="page="]');
                let lastLink = pagination.find('li.page-item a[href*="page="]').last();
                let requestData = helper.json_prepareProductData(this);// helper
                let route;

                route = requestData.oferId ? routeSave : routeAdd;

                if (! requestData) {
                    return;
                }

                if (ctrl == 'zenova' && requestData.oferId && ! confirm('Добавяне и запис на избраните продукти?')) {
                    return;
                }

                console.groupCollapsed('ℹ️ JSON Масив');
                console.log(requestData);
                console.groupEnd();

                $.ajax({
                    url: route,
                    type: 'POST',
                    data: requestData,
                    dataType: 'json',
                    success: function (res) {
                        if (res.err) {
                            alert(res.err);
                            return;
                        }

                        if (! pagination.length || ( currentLink.text() === lastLink.text() )) {
                            v.$table.append(res.table);
                        }

                        // премахване на избраните продукти
                        v.$modal.find('tbody > tr.selected').remove();
                        // премахваме странирането в мод. ф. ако е избрано всички резултати
                        if (requestData.selectAllResults) {
                            v.$modal.find('.pagination').remove();
                        }

                        $root.plugins(); // презареждане на плъгините

                        if (ctrl == 'zenova') {
                            const $el = $('body').find('thead #allToSite,thead #deleteFromAllSites');
                            if ($el.length) {
                                const merged = new Set(
                                        ( ( $el.attr('data-product-ids') || '' ) + ',' + ( res.productIds || '' ) ).split(',').filter(Boolean));

                                $el.attr('data-product-ids', [ ...merged ].join(','));
                            }
                        }

                        alert(ctrl == 'zenova' && requestData.oferId
                                ? 'Продуктите са записани успешно'
                                : LANGpop__izborProduct.alert.succsessAddProdukt);
                    }
                });
            },

            // при кликване на страница в мод. ф.
            'paginationLink': function ( ) {
                var _this = $(this);
                var route = _this.data('route');
                var page = _this.data('page');
                var selectCurentPage = v.$modal.find('#selectPageRows');
                var selectAllPage = v.$modal.find('#selectAllResults');
                let requestData = helper.json_prepareFilterData(this);// helper

                if (page === 'next') {
                    page = _this.siblings('.active').data('page') + 1;
                }
                else if (page === 'prev') {
                    page = _this.siblings('.active').data('page') - 1;
                }

                $.ajax({
                    url: route,
                    type: 'POST',
                    dataType: 'json',
                    data: requestData,
                    success: function (response) {

                        v.$modal.find('tbody').html(response.table);
                        v.$modal.find('#refreshPagnitation').html(response.pagnitation);
                        // ако е била избрана опцията текуща стр.
                        if (selectCurentPage.is(':checked')) {
                            selectCurentPage.trigger('change');
                        }

                        // ако е била избрана опцията всички стр.
                        if (selectAllPage.is(':checked')) {
                            selectAllPage.trigger('change');
                        }
                    }
                });
            }
        },

        'helper': {
            // подготвянен на данните за json масива за ajax филтриране
            'json_prepareFilterData': function (el) {
                const  _this = $(el);
                const $modal = v.$modal;

                let ctrl = $modal.data('tipOferta');
                let arg = $modal.data('arg');
                let page = _this.data('page') || 1;
                let perPage = $modal.find('#perPage').val() || 10;

                let searchName = $modal.find('input[type=search]').val();
                let sqlCol = $modal.find('input[type=search]').data('sqlcol');
                let inStock = $modal.find('#inStock').is(':checked') ? 1 : '';
                let hasGensoftPromo = $modal.find('#hasGensoftPromo').is(':checked') ? 1 : '';

                let blockCat = $modal.find('#blockCategory');
                let blockGensGrp = $modal.find('#blockGensoftGrp');
                let json;

                json = {
                    'ctrl': ctrl,
                    'arg': arg,
                    'perPage': perPage,
                    'page': page,
                    'inStock': inStock,
                    'hasGensoftPromo': hasGensoftPromo,
                    'searchName': searchName,
                    'sqlCol': sqlCol
                };

                if (blockCat.is(':visible')) {
                    let selectedCatIds = {rootCat_ids: [ ], subCat_ids: [ ]};

                    blockCat.find('input:checked').each(function () {
                        const $el = $(this);
                        const id = + $el.val();

                        ( $el.data('root') == 1 )
                                ? selectedCatIds.rootCat_ids.push(id)
                                : selectedCatIds.subCat_ids.push(id);
                    });

                    json = {
                        ...json,
                        'selectedCatIds': selectedCatIds
                    };
                }
                else if (blockGensGrp.is(':visible')) {
                    let selectedGensoftGroups = blockGensGrp.find('input:checked').map((_, el) => el.value).get();
                    let dataFrom = blockGensGrp.find('#dateFrom').val();
                    let dataTo = blockGensGrp.find('#dateTo').val();
                    let skladName = blockGensGrp.find('#gensoftSklad option:selected').text();

                    json = {
                        ...json,
                        'gensoftGroups': selectedGensoftGroups,
                        'gensoftSkladName': skladName.trim(),
                        'gensoftDateFrom': dataFrom,
                        'gensoftDateTo': dataTo
                    };
                }

                return json;
            },

            // подготвянен на данните за json масива за ajax добавяне на избраните продукти
            'json_prepareProductData': function (el) {
                const  _this = $(el);
                const $modal = v.$modal;

                let oferId = Number($modal.data('arg'));
                let ctrl = _this.closest('.modal').data('tipOferta');
                let arg = _this.closest('.modal').data('arg');
                let perPage = $modal.find('#perPage').val() || 10;

                let searchName = $modal.find('input[type=search]').val();
                let sqlCol = $modal.find('input[type=search]').data('sqlcol');
                let inStock = $modal.find('#inStock').is(':checked') ? 1 : '';
                let hasGensoftPromo = $modal.find('#hasGensoftPromo').is(':checked') ? 1 : '';
                let selectedRows = $modal.find('tbody > tr.selected');
                let selectAllResults = $modal.find('#selectAllResults').is(':checked') ? 1 : '';
                let blockCat = $modal.find('#blockCategory');
                let blockGensGrp = $modal.find('#blockGensoftGrp');
                let selectedCatIds = {rootCat_ids: [ ], subCat_ids: [ ]};
                let productIds = [ ];
                let json;

                // извличане на ID-та
                productIds = selectedRows.map((_, tr) => $(tr).data('id')).get();

                if (! productIds.length) {
                    alert(LANGpop__izborProduct.alert.ifProdArrEmpty);
                    return false;
                }
                json = {
                    oferId,
                    productIds,
                    'selectAllResults': selectAllResults,
                    'searchParams': {
                        ctrl,
                        arg,
                        perPage,
                        inStock,
                        hasGensoftPromo,
                        'name': searchName,
                        sqlCol
                    }
                };


                if (blockCat.is(':visible')) {
                    blockCat.find('input:checked').each(function () {
                        const $el = $(this);
                        const id = + $el.val();

                        ( $el.data('root') == 1 )
                                ? selectedCatIds.rootCat_ids.push(id)
                                : selectedCatIds.subCat_ids.push(id);
                    });

                    json.searchParams = {
                        ...json.searchParams,
                        'selectedCatIds': selectedCatIds
                    };
                }
                else if (blockGensGrp.is(':visible')) {
                    let selectedGensoftGroups = blockGensGrp.find('input:checked').map((_, el) => el.value).get();
                    let dataFrom = blockGensGrp.find('#dateFrom').val();
                    let dataTo = blockGensGrp.find('#dateTo').val();
                    let skladName = blockGensGrp.find('#gensoftSklad option:selected').text();

                    json.searchParams = {
                        ...json.searchParams,
                        'gensoftGroups': selectedGensoftGroups,
                        'gensoftSkladName': skladName.trim(),
                        'gensoftDateFrom': dataFrom,
                        'gensoftDateTo': dataTo
                    };
                }

                return json;
            }
        }
    };
    popup_izborProduct.init();

} )(jQuery, window, document);
