/* global categoryTree, $root, mqrkaTree, form, Popup_product_fillCatSelect, loadPlugins, categoryAttr, dropdown, Dropdown */

( function ($, window, document, undefined) {

    var popup_edit_product_related = popup_edit_product_related || {};
    let v = popup_edit_product_related;

    popup_edit_product_related = {
        '__initializedEvents': false,
        '__var': {
            $modal: $('#' + $('.modal').attr('id')),
            $tabRelatedProducts: $('.modal').find('#tabRelatedProducts'),
            $listHXbox: $('.hx-box'),
            hx_box: '.hx-box'
        },
        'init': function ( ) {

            if (this.__initializedEvents) {
                return;
            }
            this.__initializedEvents = true;

            v = this.__var;
            self = this;

            this.plugins( );
            this.setUpListeners( );
        },
        'plugins': function ( ) {
            Lp = loadPlugins;

            Lp.popupTitle();
            Lp.move_slide({'el': v.$tabRelatedProducts.find('ul#relatedBlock'), 'handle': '.fa-arrows'});
        },

        'setUpListeners': function ( ) {
            const NS = 'dropdown';

            $(document).off('htmx:afterSwap').on('htmx:afterSwap', function (evt) {
                popup_edit_product_related.plugins( );
            });

            $(document).on(`mousedown.${NS}`, this.events.closeListbox);

            // EVENTS 
            v.$tabRelatedProducts.off(`.${NS}`)
                    .on(`click.${NS}`, '#chk_AllRelatedItems', this.events.chk_AllRelatedItems)
                    .on(`click.${NS}`, '#removeAllRelatedItems', this.events.removeSelectedItems.bind(this, true))
                    .on(`click.${NS}`, '#relatedBlock .removeItem', this.events.removeSelectedItems.bind(this, false))
                    .on(`click.${NS}`, '#relatedSearchResults li', this.events.selectItem);
        },

        'events': {
            'closeListbox': function (e) {
                e.stopImmediatePropagation( );
                const relatedSearch = v.$tabRelatedProducts.find('#relatedSearch');

                if (!$(e.target).closest(v.hx_box).length && !$(e.target).closest(relatedSearch).length) {
                    relatedSearch.val('');
                    v.$listHXbox.html('');
                }
            },

            'chk_AllRelatedItems': function (e) {
                e.stopImmediatePropagation( );
                const isChecked = $(this).is(':checked');

                // Намери всички чекбокси в #relatedBlock и ги маркирай/размаркирай
                $('#relatedBlock li input[type="checkbox"]').prop('checked', isChecked);
            },

            'removeSelectedItems': function (isBulk, e) {
                e.stopImmediatePropagation( );
                let li = $(e.currentTarget).closest('li');
                let $itemsToRemove;
                let name = '';

                // за премахване на всички маркирани
                if (isBulk) {
                    $itemsToRemove = v.$tabRelatedProducts.find('#relatedBlock li input[type="checkbox"]:checked').closest('li');

                    if ($itemsToRemove.length === 0) {
                        alert('Няма избрани продукти за премахване.');
                        return;
                    }

                    if (!confirm(`Премахване на ${$itemsToRemove.length} избрани продукт(а)?`)) {
                        return;
                    }
                }
                else {
                    $itemsToRemove = li;
                    name = li.find('.name').text().trim();

                    if (!confirm(`Сигурен ли си, че искаш да премахнеш продукта: \n\n${name}?`)) {
                        return;
                    }
                }
                $itemsToRemove.remove();
                $('#chk_AllRelatedItems').prop('checked', false);
            },

            'selectItem': function (e) {
                e.stopImmediatePropagation( );
                const $li = $(this);
                const productId = $li.data('id');
                const name = $li.find('.name').text().trim();

                // Проверка дали вече съществува
                const exists = v.$tabRelatedProducts.find('#relatedBlock li[data-id]').filter(function () {
                    return $(this).data('id') == productId;
                }).length > 0;

                if (exists) {
                    alert(`Този продукт ${name} вече е добавен`);
                    $li.addClass('text-muted').css('pointer-events', 'none');
                    return;
                }
                $li.find('.hide').removeClass('hide');

                // Премести елемента
                $li.prependTo('#relatedBlock');
            }
        },

        'btn': {

        }
    };
    popup_edit_product_related.init( );
} )(jQuery, window, document);
