( function ($, window, document, undefined) {

    let popup_categorySeo = {};
    let v, $el, helpers, ui;

    popup_categorySeo = {
        '__var': {
            $modal: $('.modal').on('show.bs.modal', function (event) {
                $('#' + event.target.id);
            }),
            fields: {
                seo_title: {min: 50, max: 60, meter: '#seo_title_meter'},
                seo_description: {min: 140, max: 160, meter: '#seo_description_meter'}
            }
        },

        'init': function () {
            v = this.__var;
            ui = this.ui;
            helpers = this.helpers;

            this.cacheDom();
            this.setUpListeners();
        },

        // CACHE DOM
        // ======================================================
        'cacheDom': function () {
            $el = {
                title: $('#seo_title'),
                desc: $('#seo_description'),
                keywords: $('#focus_keyword'),
                slug: $('#seo_slug'),
                canonical: $('#canonical_url'),
                noindex: $('#noindex'),

                scoreBox: $('#seoScoreCircle'),
                scoreVal: $('#seoScoreValue'),
                scoreLbl: $('#seoScoreLabel'),
                checklist: $('#seoChecklist')
            };
        },

        // LISTENERS
        // ======================================================
        'setUpListeners': function () {
            v.$modal
                    .on('shown.bs.modal', helpers.initSeo)
                    .on('input keyup', '#seo_title, #seo_description', ui.onTextInput)
                    .on('input', '#focus_keyword, #seo_slug, #canonical_url', ui.onFieldChange)
                    .on('change', '#noindex', this.ui.onFieldChange);
        },

        // UI
        // ======================================================
        'ui': {
            'onTextInput': function (e) {
                ui.updateMeter(e.target.id);
                helpers.updateAll();
            },

            'onFieldChange': function () {
                helpers.updateAll();
            },

            /* --- Update circular score indicator and checklist --- */
            'updateScore': function () {

                const val = helpers.getScore();
                const map = val < 40
                        ? [ '#dc3545', 'Слабо' ]
                        : val < 70
                        ? [ '#ffc107', 'Добре' ]
                        : [ '#28a745', 'Отлично' ];

                $el.scoreBox.css('background', map[0]);
                $el.scoreVal.text(val + '%');
                $el.scoreLbl.text(map[1]);
            },

            /* --- Update visual recommendation checklist --- */
            'updateChecklist': function () {
                const add = (t, c) =>
                    $el.checklist.append(`<div class="seo-check-item ${c}">${c === 'good' ? '✅' : c === 'warn' ? '⚠️' : '❌'} ${t}</div>`);

                $el.checklist.empty();

                const t = $el.title.val().length;
                const d = $el.desc.val().length;

                add(
                        t < 30 ? 'SEO заглавието е твърде кратко'
                        : t < 50 ? 'SEO заглавието може да е по-дълго'
                        : 'SEO заглавието е отлично',
                        t < 30 ? 'bad' : t < 50 ? 'warn' : 'good'
                        );

                add(
                        d < 100 ? 'SEO описанието е твърде кратко'
                        : d < 140 ? 'Добави още детайли в описанието'
                        : 'SEO описанието е оптимално',
                        d < 100 ? 'bad' : d < 140 ? 'warn' : 'good'
                        );

                add(
                        $el.keywords.val() ? 'Ключовите думи са попълнени' : 'Липсват ключови думи',
                        $el.keywords.val() ? 'good' : 'bad'
                        );

                add(
                        /^[a-z0-9-]+$/.test($el.slug.val())
                        ? 'Slug форматът е валиден'
                        : 'Slug трябва да е на латиница без интервали',
                        /^[a-z0-9-]+$/.test($el.slug.val()) ? 'good' : 'bad'
                        );

                add(
                        $el.noindex.is(':checked')
                        ? 'Активиран е noindex – страницата няма да се индексира'
                        : 'Категорията ще бъде индексирана',
                        $el.noindex.is(':checked') ? 'warn' : 'good'
                        );
            },

            /* --- Update visual meters for title and description length --- */
            'updateMeter': function (id) {
                const cfg = v.fields[id];
                if (! cfg)
                    return;

                const $input = $('#' + id);
                const len = $input.val().trim().length;
                const pct = Math.min(len / cfg.max * 100, 100);

                let color = len >= cfg.min && len <= cfg.max
                        ? '#28a745'
                        : len >= cfg.min * 0.6
                        ? '#ffc107'
                        : len > cfg.max
                        ? '#fd7e14'
                        : '#dc3545';

                $(cfg.meter).css({width: pct + '%', backgroundColor: color});
            }
        },

        // HELPERS 
        // ======================================================
        'helpers': {

            'initSeo': function () {
                ui.updateMeter('seo_title');
                ui.updateMeter('seo_description');
                helpers.updateAll();
            },

            'updateAll': function () {
                ui.updateScore();
                ui.updateChecklist();
            },

            /* --- Calculate SEO score based on multiple parameters --- */
            'getScore': function () {

                let score = 0;

                const t = $el.title.val().trim().length;
                const d = $el.desc.val().trim().length;

                if (t >= 50 && t <= 60)
                    score += 30;
                else if (t >= 35)
                    score += 20;
                else if (t >= 20)
                    score += 10;

                if (d >= 140 && d <= 160)
                    score += 30;
                else if (d >= 100)
                    score += 20;
                else if (d > 50)
                    score += 10;

                if ($el.keywords.val().split(',').filter(k => k.trim().length > 2).length >= 3)
                    score += 20;
                else if ($el.keywords.val().trim())
                    score += 10;

                if (/^[a-z0-9-]+$/.test($el.slug.val()))
                    score += 15;
                if ($el.canonical.val().startsWith('http'))
                    score += 5;
                if ($el.noindex.is(':checked'))
                    score -= 10;

                return Math.max(0, Math.min(score, 100));
            }
        }
    };

    popup_categorySeo.init();

} )(jQuery, window, document);
