/* global LANGpop__izborProduct, loadPlugins */
( function ($, window, document, undefined) {


    var popup_categoryAtt = popup_categoryAtt || {};
    let v = popup_categoryAtt;
    let self;

    popup_categoryAtt = {
        '__var': {
            $modal: $('.modal').on('show.bs.modal', function (event) {
                $('#' + event.target.id);
            })
        },
        'init': function () {
            v = this.__var;
            self = this;

            this.plugins( );
            this.setUpListeners();
        },
        'plugins': function ( ) {
            Lp = loadPlugins;

            Lp.selectpicker( );
            Lp.ul_move({'el': '#js-sortable', 'handle': '.fa-arrows'});
        },
        'setUpListeners': function ( ) {
            const NS = 'attr';

            //EVENTS
            v.$modal.off(`.${NS}`)
                    .on('change', '#js-rootCategory', this.event.change_rootCategory)
                    .on('change', 'select[data-level]', this.event.changeCatLevel)
            //.on('keyup', '#catAttr-filter', this.event.filter);

            //BTN
            v.$modal.off(`.${NS}`)
                    .on(`click.${NS}`, '.rowPosition', this.btn.rowPosition)
                    .on(`click.${NS}`, '.isVisibleCatAttr', this.btn.isVisibleCatAttr)
                    .on(`click.${NS}`, '#js-create_newAtributes', this.btn.create_newAtributes)
                    .on(`click.${NS}`, '.edit', this.btn.edit)
                    .on(`click.${NS}`, '.delete', this.btn.delete);

        },

        'event': {
            // промяна на главна категория
            'change_rootCategory': function (e) {
                e.stopImmediatePropagation();
                const _this = $(this);
                const route = _this.data('route');
                const selectedVal = _this.val();

                v.$modal.find('#js-block-childCategories').empty();
                v.$modal.find('#js-block-catAtributes').addClass('d-none').empty();

                if (!selectedVal) {
                    return false;
                }

                $.ajax({
                    url: route,
                    type: 'GET',
                    dataType: 'json',
                    data: {'catRootId': selectedVal},
                    success: function (response)
                    {
                        v.$modal.find('#js-block-childCategories').html(response);
                        self.plugins();
                    }
                });

            },

            // промяна подкатегория
            'changeCatLevel': function (e) {
                e.stopImmediatePropagation( );
                const _this = $(this);
                let route = _this.data('route');
                let currentLevel = parseInt(_this.data('level'));
                let optionSelected = _this.find('option:selected');
                let catRootId = v.$modal.find('#js-rootCategory').val();
                let childCategoriesArr = '';


                if (!optionSelected.val()) {
                    v.$modal.find('#js-block-catAtributes').addClass('d-none').empty();
                    return false;
                }

                // 🧹 Изчистване на следващите нива
                v.$modal.find('#js-block-childCategories').children('[data-level]').each(function () {
                    let thisLevel = parseInt($(this).data('level'));

                    $(this).find('select').removeClass('active');

                    if (thisLevel > currentLevel) {
                        $(this).remove();
                    }
                });

                // Събиране на избраните подкатегории до текущото ниво
                childCategoriesArr = v.$modal.find('select[data-level]')
                        .map((_, el) => {
                            let $el = $(el);
                            let val = $el.val();
                            let text = $el.find('option:selected').text().trim();

                            return val ? {'id': val, 'name': text.trim()} : null;
                        }).get().filter(Boolean); // премахва null елементи

                _this.addClass('active');

                $.ajax({
                    url: route,
                    type: 'POST',
                    dataType: 'json',
                    data: {
                        'catRootId': catRootId,
                        'childCategoriesArr': childCategoriesArr,
                        'singleChildCategoryId': optionSelected.val(),
                        'level': currentLevel + 1
                    },
                    success: function (response)
                    {
                        v.$modal.find('#js-block-childCategories').append(response.categories);
                        v.$modal.find('#js-block-catAtributes').removeClass('d-none').html(response.catAtributes);
                        self.init();
                    }
                });
            },

            'filter': function (e) {
                e.stopImmediatePropagation( );

                let ul = v.$modal.find('ul.treeview');
                let parentLi = ul.find('li');
                let filterValue = $(this).val().trim().toLowerCase();

                if (window.doomEditActive) {
                    return false;
                }

                if (filterValue === '') {
                    parentLi.show().children('ul.child').hide();
                    parentLi.find('.node-minus').toggleClass('node-minus node-plus');
                    ul.find('mark').contents().unwrap();
                }
                else {
                    parentLi.each(function () {
                        let _this = $(this);
                        let childList = _this.find('ul.child');

                        if (childList.length > 0) {
                            let hasMatch = _this.text().toLowerCase().includes(filterValue);

                            _this.toggle(hasMatch); // скрива останалите главни Li категории

                            if (hasMatch) {
                                // Mark the matched text within the parent element
                                let regex = new RegExp('(<label[^>]*>[^<]*?)(' + filterValue.replace(/[.*+?^${}()|[\]\\]/g, '\\$&') + ')([^<]*?<\/label>)', 'ig');

                                childList.show();

                                // Unwrap previous mark tags
                                _this.find('mark').contents().unwrap();

                                // Wrap matched text with mark tags
                                _this.html(function (_, html) {
                                    return html.replace(regex, '$1<mark>$2</mark>$3');
                                });

                                _this.find('.node-plus').toggleClass('node-plus node-minus');
                            }
                            else {
                                _this.find('mark').contents().unwrap();
                                childList.hide();
                            }
                        }
                    });
                }
                self.plugins();
            }
        },

        'btn': {
            // създаване на нови атрибут за избрана подкатегория
            'create_newAtributes': function (e) {
                e.stopImmediatePropagation();
                const _this = $(this);
                let route = _this.data('route');
                let group = _this.closest('[role="group"]');
                let inputValue = group.find('#js-inputValue').val();
                let selectedChildCategoryId = v.$modal.find('select[data-level].active').val();

                if (!inputValue) {
                    alert('Въведете име на новата характеристика.');
                    return false;
                }

                $.ajax({
                    url: route,
                    type: 'POST',
                    data: {'new': 1, 'childCatId': selectedChildCategoryId, 'newName': inputValue},
                    dataType: 'json',
                    success: function (response)
                    {
                        if (response.err) {
                            alert(response.err);
                            return false;
                        }

                        v.$modal.find('select[data-level].active').trigger('change');
                    }
                });
            },

            // dali da се показа атрибута ба категорията в сайта
            'isVisibleCatAttr': function (e) {
                e.stopImmediatePropagation();

                const _this = $(this);
                let route = _this.data('route');
                let isVisible = '';

                if (window.doomEditActive) {
                    return false;
                }

                isVisible = _this.hasClass('fa-eye') ? 0 : 1;

                $.ajax({
                    url: route,
                    type: "POST",
                    data: {'isVisible': isVisible},
                    success: function (data)
                    {
                        isVisible === 0 ? _this.toggleClass('fa-eye-slash fa-eye').toggleClass('text-info') : _this.toggleClass('fa-eye fa-eye-slash').toggleClass('text-info');
                    }
                });
            },

            'rowPosition': function (e) {
                var _this = $(this);
                var ul = _this.closest('ul');
                var row = _this.closest('li');
                var route = _this.data('route');
                var childrenLi = ul.find('li:not(.disabledLi)').length;
                var condition = true;
                var indexLi = '';
                let posArr = [ ];

                if (window.doomEditActive) {
                    return false;
                }

                do {
                    var Confirm_index = prompt(LANG__global.table.rowPosition + ( row.index() ) + ' \n' + LANG__global.table.enterRowPosition, '');

                    condition = true;
                    indexLi = 'li:not(.disabledLi)';

                    if (isNaN(Confirm_index) === true) {
                        alert(LANG__global.table.onlyNumberRowPosition);
                        condition = false;
                    }

                    else if (Confirm_index == '') {
                        condition = false;
                    }
                    else if (Confirm_index == 0) {
                        alert(LANG__global.table.isNulaRowPosition);
                        condition = false;
                    }
                    else if (Confirm_index === null) {
                        return false;
                    }

                    if (Confirm_index >= childrenLi) {
                        condition = true;
                        row.insertAfter(ul.find(indexLi + ':eq(' + ( childrenLi - 1 ) + ')'));
                    }
                    else {
                        condition = true;
                        row.insertBefore(ul.find(indexLi + ':eq(' + ( Confirm_index - 1 ) + ')'));

                    }
                }
                while (condition === false)

                if (condition) {
                    // промяна на позицията на цветния ред
                    ul.find('li:not(.disabledLi)').each(function (index, li) {
                        let subId = $(li).data('subId');
                        let id = $(li).data('id');

                        posArr.push({'category_characteristic_id': id, 'category_id': subId, 'category_char_position': index + 1});

                        $(li).find('.count').text(index + 1 + '.');
                    });

                    axios({
                        url: route,
                        method: 'post',
                        data: {'positionArr': posArr},
                        responseType: 'json'
                    }).then(function (response) {

                    });
                }

                e.stopImmediatePropagation();
            },

            'edit': function (e) {
                e.stopImmediatePropagation();

                const _this = $(this);

                let li = _this.closest('li');
                let el = li.find('.name:first');
                let route = _this.data('route');
                let btnGroup = li.find('.btnGroup:first');

                if (window.doomEditActive) {
                    return false;
                }

                Lp.loadDoomEdit({'el': el, 'route': route, 'action': 'edit', 'btnGroup': btnGroup});
            },

            'delete': function (e) {
                e.stopImmediatePropagation();

                const _this = $(this);

                var li = _this.closest('li');
                var route = _this.data('route');
                var name = li.find('.name:first').text().trim();
                var confirmDelete;

                if (window.doomEditActive) {
                    return false;
                }

                confirmDelete = confirm(`${LANGpop__category.confirm.delete} ${name}?`);// Сигурни ли сте че искате да изтриете

                if (confirmDelete) {
                    $.ajax({
                        url: route,
                        type: "POST",
                        success: function (response)
                        {
                            li.remove();
                            alert('Записът е изтрит');
                        }
                    });
                }
            }
        },

        'helper': {}
    };

    popup_categoryAtt.init();

} )(jQuery, window, document);
