/* global categoryTree, mqrkaTree, form, Popup_product_fillCatSelect, loadPlugins, categoryAttr, CKEDITOR */
( function ($, window, document) {

    var nastrojkiPortal = nastrojkiPortal || {};
    let v = nastrojkiPortal;
    let $self = nastrojkiPortal;

    nastrojkiPortal = {
        '__var': {},
        'init': function ( ) {
            //v = this.__var;
            $self = this;

            this.breadcrumb( );
            this.plugins( );
            this.setUpListeners( );
        },
        'breadcrumb': function ( ) {
            let activeLink = $('#accordionMenu a.active').text().trim();
            let activeMainLink = $('#portalLinks a.active2').text().trim();

            $('.breadcrumb #activeLink').text(activeLink);
            $('.breadcrumb #mainLink').text(activeMainLink);
        },
        'plugins': function ( ) {
            const searchParams = new URLSearchParams(window.location.search);
            let link = searchParams.get('link');

            Lp = loadPlugins;

            if (link == 'infoPages') {
                Lp.loadCKEditor('ck_area', ck_full);
            }

            Lp.inputMask('tel');
            Lp.move_slide({'el': '.sortable', 'handle': '.fa-arrows'});
        },
        'setUpListeners': function ( ) {

            //=====  EVENTS ====================================
            $(document)
                    // промяна на цената за доставка
                    .on('keyup focusout', '#deliveryPrice', this.events.change_deliveryPrice)
                    .on('paste', '.slideUrl', this.events.setSlideUrl);

            //=====  BUTTONS ====================================
            $(document)
                    .on('click', '#accordionMenu a', this.btn.reloadBreadcrumb)
                    .on('click', '.imgPreview', this.btn.slide.selectImage)
                    .on('click', '.newSlide', this.btn.slide.new)
                    .on('click', '.removeSlide', this.btn.slide.removeSlide)
                    .on('click', '#removeLogo', this.btn.removeLogo)
                    .on('click', '.js-saveForm', this.btn.savePortal);
            ;
        },
        'events': {
            // промяна на цената за доставка
            'change_deliveryPrice': function (e) {
                e.preventDefault( );
                let _this = $(this);

                if (_this.val() == '') {
                    _this.val(0);
                    return false;
                }
            },

            // при вмъкване на url към слайд се изтрива base url https://site.com
            'setSlideUrl': function (e) {
                e.preventDefault( );
                var pastedData = e.originalEvent.clipboardData.getData('text');
                try {
                    // Create a URL object to parse the pasted URL
                    var url = new URL(pastedData);
                    // Extract the path, query string, and fragment part
                    var trimmedUrl = url.pathname + url.search + url.hash;
                    $(this).val(trimmedUrl); // Set the input value to the part after the host
                } catch (error) {
                    // If the pasted data is not a valid URL, keep the original data
                    $(this).val(pastedData);
                }
            }
        },
        'btn': {
            'savePortal': function (e) {
                $(document).off('submit').on('submit', 'form', function (e) {
                    e.preventDefault();

                    var form = $(this);
                    var url = form.attr('action');
                    var formData = form.find(':input').serialize();
                    let activeLink = $('#accordionMenu a.active').attr('href');
                    console.log(formData);
                    $.ajax({
                        url: url,
                        method: 'POST',
                        dataType: 'json',
                        data: formData,
                        success: function (response) {

                            if (activeLink == '#tab-courier') {
                                $('#tab-courier').load(window.location.href + ' #tab-courier>*', function (response, status, xhr) {

                                });
                            }

                            alert('Настройките са запазени успешно!');
                        },
                    });
                });
            },

            // обновяване на бисквитките при кликване на връзка
            'reloadBreadcrumb': function (e) {
                $self.breadcrumb();
            },

            'slide': {
                // izbor na картинка за slideshow
                'selectImage': function (e) {
                    e.stopImmediatePropagation( );
                    var _this = $(this);
                    var tip = _this.closest('ul').data('tip') || _this.data('tip');

                    function getStartupPath (tip) {
                        var pathMap = {
                            'links': 'portal_images:/links/',
                            'logo': 'portal_images:/logo/',
                            'slideshow': 'portal_images:/slideshow/',
                            'baners': 'portal_images:/baners/',
                        };
                        return pathMap[tip] || 'defaultPath'; // Provide a default path if no match is found
                    }
                    var startupPath = getStartupPath(tip);
                    console.log(startupPath);
                    CKFinder.popup({
                        id: tip,
                        chooseFiles: true,
                        skin: 'jquery-mobile',
                        language: 'bg',
                        swatch: 'b',
                        width: 1024,
                        height: 800,
                        rememberLastFolder: false,
                        startupFolderExpanded: true,
                        // startFolder: 'portal_images', // Specify the custom folder here
                        startupPath: startupPath,
                        onInit: function (finder) {

                            finder.on('files:choose', function (evt) {
                                var file = evt.data.files.first( );
                                var avatar = _this;
                                var newPatch = file.getUrl( ).replace(GLOBVAR.portalImageDir, '');

                                avatar.find('img').attr('src', file.getUrl( ));
                                avatar.find('.avatar').attr('value', newPatch);
                                avatar.find('.camera').removeClass('fa-camera').addClass('fa-none');
                            });
                        }
                    });
                },

                'new': function (e) {
                    e.stopImmediatePropagation( );
                    var slideshowBlock = $('#slideshowBlock, #homeBanerBlock1');
                    var clonedElement = slideshowBlock.find('li:first').clone();
                    var maxIndex = Number($(this).closest('form').find('ul').children().length);

                    clonedElement
                            .find('img').attr('src', '').end()
                            .find('input').val('').end()
                            .find('i.camera').toggleClass(function () {
                        return $(this).hasClass('fa-none') ? 'fa-none fa-camera' : '';
                    });

                    clonedElement.find('input').each(function (index, input) {
                        var baseName = 'settings[text][' + maxIndex + ']';
                        $(input).attr('name', baseName + ( index === 0 ? '[img]' : '[url]' ));
                    });

                    // Append the cloned element to the container
                    slideshowBlock.find('li#newSlide').before(clonedElement);
                },

                'removeSlide': function (e) {
                    e.stopImmediatePropagation( );
                    var _this = $(this);
                    var li = _this.closest('li');
                    var ul = li.closest('ul');
                    var tip = {
                        'baner': 'банер',
                        'slideshow': 'слайд'
                    }[li.data('tip')] || '';

                    if (confirm(`Искате ли да премахнете наистина този ${tip}?`)) {
                        if (ul.children('li').length === 1) {
                            li.find('img').attr('src', '').end()
                                    .find('input').val('').end()
                                    .find('.camera').removeClass('fa-none').addClass('fa-camera');
                        }
                        else {
                            li.remove();
                        }
                    }
                },
            },

            'removeLogo': function (e) {
                e.stopImmediatePropagation( );
                var _this = $(this);
                var card = _this.closest('.card');

                if (confirm('Искатели да премахнете логото?')) {
                    card.find('.camera').addClass('fa-camera');
                    card.find('img[src]').attr('src', '');
                    card.find('input').val('');
                }
            }
        }
    };
    nastrojkiPortal.init( );
}(window.jQuery, window, document) );
