/* global loadPlugins */
( function ($, window, document, undefined) {

    var nastroikiRelatedProducts = nastroikiRelatedProducts || {};
    let v = nastroikiRelatedProducts;
    let $self = nastroikiRelatedProducts;
    let helpers;

    nastroikiRelatedProducts = {
        '__var': {},

        'init': function ( ) {
            v = this.__var;
            $self = this;
            helpers = this.helpers;

            this.setUpListeners();
        },
        'setUpListeners': function () {

            $(document)
                    .on('click', '#btnGenerateForProduct', this.btn.generateSingle)
                    .on('click', '#btnGenerateBatch', this.btn.generateBatch);
        },

        'btn': {

            /* SINGLE PRODUCT GENERATION
             ============================== */
            'generateSingle': function (e) {
                e.stopImmediatePropagation();

                const url = $(this).data('route');
                const data = {
                    rel_field: $('#rel_field').val(),
                    rel_substr_len: $('#rel_substr_len').val(),
                    rel_like_type: $('#rel_like_type').val(),
                    rel_limit: $('#rel_limit').val(),

                    rel_same_category: $('#rel_same_category').is(':checked') ? 1 : 0,
                    rel_same_subcategory: $('#rel_same_subcategory').is(':checked') ? 1 : 0,
                    rel_only_active: $('#rel_only_active').is(':checked') ? 1 : 0,

                    rel_min_timer: $('#rel_min_timer').val(),
                    rel_crawl_time: $('#rel_crawl_time').val(),

                    product_id: $('#rel_product_id').val()
                };

                console.log('RELATED GENERATOR URL:', url);
                console.log('RELATED GENERATOR DATA:', data);

                $.ajax({
                    url: url,
                    type: 'POST',
                    data: data,
                    dataType: 'json',

                    success: function (res) {
                        const box = $('#relStatusBox');
                        console.log('RELATED GENERATOR RESPONSE:', res);

                        $('#relatedPreviewBox').removeClass('d-none');
                        $('#relatedPreview').text(JSON.stringify(res, null, 2));

                        box.removeClass('d-none text-success text-danger');

                        if (res && res.ok) {
                            box.addClass('text-success').html(res.msg);
                        }
                        else {
                            box.addClass('text-danger').html('✗ ' + ( res.msg || 'Грешка при запазване' ));
                        }
                    }
                });
            },

            /* BATCH GENERATION
             ============================== */
            'generateBatch': function (e) {
                e.stopImmediatePropagation();
                let offset = parseInt($('#batch_offset').val()) || 0;
                let limit = parseInt($('#batch_limit').val()) || 50;

                $('#batchProgressBox').removeClass('d-none');
                
                helpers.runBatch(this, offset, limit);
            },
        },

        /** HELPERS
         ================================================== */
        'helpers': {
            'runBatch': function (el, offset, limit) {
                let route = $(el).data('route');

                $.ajax({
                    url: route,
                    type: 'POST',
                    dataType: 'json',
                    global: false,
                    data: {
                        offset: offset,
                        limit: limit
                    },
                    success: function (res) {
                        let percent = Math.min(100, Math.round(( offset / 20000 ) * 100));
                        console.log('BATCH:', res);

                        if (! res.ok || res.done) {
                            $('#batchProgressBar')
                                    .removeClass('progress-bar-animated')
                                    .addClass('bg-success')
                                    .css('width', '100%')
                                    .text('ГОТОВО');

                            return;
                        }

                        offset += res.processed;

                        $('#batchProgressOffset').text(offset);
                        $('#batchProgressProcessed').text(res.processed);
                        $('#batchProgressBar').css('width', percent + '%').text(percent + '%');
                        setTimeout(function () {
                            helpers.runBatch(el, offset, limit);
                        }, 300);
                    }
                });
            }
        }
    };

    nastroikiRelatedProducts.init( );
} )(jQuery, window, document);
