/* global Lp, loadPlugins, tableActions, leftAsideActions */
( function ($, window, document) {

    var zenova = zenova || {};
    let v = zenova;
    let $self = zenova;
    let helper;

    $('form').dontJustLeaveMe('a#prinPreview, a#zenoobrazuvane'); // plygin za напускане на стр ако има промяна

    zenova = {
        '__var': {
            table: '#tbl_products'
        },
        'init': function () {
            v = this.__var;
            $self = this;
            $root = this;
            helper = this.helper;

            this.plugins();
            this.setUpListeners();
        },
        'plugins': function () {
            Lp = loadPlugins;
            Ta = tableActions;
            Lsa = leftAsideActions;

            //Lp.lazyLoadTableRows({'isModal': false, 'modal': '', 'bodyHeight': 'html', 'tableId': '#tbl_products'});
            // Lp.lazyLoadTable();
            Lp.check_ofer.beforeUnload();
            Lp.sessionTimeout();
            Lp.select2Simple();
            Lp.zoomImg();
            Lp.popupTitle();
            Lp.table_freezeHeader({'table': v.table}); // thead frezze
            Ta.table.filter({'input': '#filter', 'table': v.table}); // филтър
            Ta.tableRow.move();
            Lsa.colorChoice(); // избор на цветни редове

            // restore search value from URL (?search=...)
            const params = new URLSearchParams(window.location.search);
            if (params.has('search')) {
                $('#filter').val(params.get('search'));
            }
        },
        'setUpListeners': function ( ) {

            // POPUP 
            $(document)
                    .on('click', 'tbody .moveProductToZenova', this.modal.open_popup_moveProductToZenova)
                    .on('click', 'tbody .edit_product,#new_product', this.modal.open_popup_editProduct)
                    .on('click', '#izbor-product', this.modal.open_popup_izborProduct)
                    .on('click', '#zenoobrazuvane, #zenoobrazuvanePrivate', this.modal.open_popup_zenoobrazuvane)
                    .on('click', '#popupToSite', this.modal.open_popup_toSite)
                    .on('click', '#add-colorRow', this.modal.open_popup_colorRow);

            // EVENT 
            $(document)
                    .on('click', '[disabled]', this.event.isAllowed) // DISABLED CLICK
                    //   --- table
                    .on('mouseover', 'tbody .rowPosition', Ta.tableRow.position.getTitle)
                    .on('input', '#filter', this.event.search)

            // BUTONS 
            $(document)
                    //   --- left aside
                    .on('click', '#leftAside .colorDisplay', Lsa.changeColor)

                    //   --- table
                    .on('click', 'thead #allToSite', this.btn.table.change_allSite)
                    .on('click', 'thead #deleteFromAllSites', this.btn.table.delete_fromAllSites)
                    .on('click', 'thead #selectAllProducts', this.btn.table.selectAllProducts)
                    .on('click', 'thead #deleteSelectedProducts', this.btn.table.deleteSelectedProducts)

                    .on('click', 'tbody .prodAttr', this.btn.table.productAttributesData)
                    .on('click', 'tbody #clone-product', this.btn.table.cloneProduct)
                    .on('click', 'tbody .getGensoftInfo', Ta.getGensoftInfo)// изв на информация от Gensoft за конкретния продукт

                    .on('click', 'tbody .toSite', this.btn.table.toSite)
                    .on('click', 'tbody .rowPosition', Ta.tableRow.position.setPosition)
                    .on('click', 'tbody tr.colorRows .edit_colorRow', Ta.colorRow.edit)
                    .on('click', 'tbody .delete_colorRow', Ta.colorRow.delete)
                    .on('click', 'tbody .delete_product', this.btn.table.delete_sinleProduct)
                    .on('change', 'tbody .product-check', this.btn.table.syncSelectAll)

                    //   --- header
                    .on('click', '#save-ofer', this.btn.header.save);
        },

        'modal': {
            'open_popup_moveProductToZenova': function () {
                Lp.ajax_modalFormOpen({'route': $(this).data('route'), 'ajaxType': 'GET'});
            },

            'open_popup_colorRow': function () {

                var colorValue = $('#left-aside').find('#colorValue').val();

                if ($(v.table).find('tbody tr').length == 0) {
                    alert(LANG__zenovaOferta.alert.emptyProducts);//ДОбавете поне 1 продукт в таблицата
                    return false;
                }

                Lp.ajax_modalFormOpen({'route': $(this).data('route'), 'ajaxType': 'POST', 'datastr': `colorValue=${colorValue}`});
            },

            'open_popup_toSite': function (e) {
                var _this = $(this);
                var productIds = [ ];
                var is_productInZenova = true;

                if (_this.is("[disabled]")) {
                    return false;
                }

                if ($(v.table).find('tbody tr').length == 0) {
                    alert('Добавете поне един продукт.');
                    return false;
                }

                $(v.table + " > tbody > tr:not(.colorRows)").filter(function () {
                    if ($(this).data('fromizborproduct')) {
                        is_productInZenova = false;
                    }

                    productIds.push($(this).data('id'));
                });

                // дали продуктите са в ценова листа 
                if (is_productInZenova === false) {
                    alert('Имате продукти, които са нови и преди това трябва да направите запис на ценовата листа.');
                    return false;
                }

                Lp.ajax_modalFormOpen({'route': $(this).data('route'), 'ajaxType': 'GET', 'datastr': "productIds=" + JSON.stringify(productIds)});
            },

            'open_popup_zenoobrazuvane': function () {
                var _this = $(this);
                var productId_arr = [ ];
                var isPrivate = 0;

                if (_this.is("[disabled]")) {
                    return false;
                }

                if (_this.attr('id') == 'zenoobrazuvanePrivate') {
                    isPrivate = 1;
                }

                $("#tbl_products > tbody > tr:not(.colorRows)").filter(function () {
                    productId_arr.push($(this).data('id'));
                });

                Lp.ajax_modalFormOpen({'route': $(this).data('route'), 'ajaxType': 'GET', 'datastr': {"productId_arr": JSON.stringify(productId_arr), 'isPrivate': isPrivate}});
            },

            'open_popup_izborProduct': function () {
                Lp.ajax_modalFormOpen({'route': $(this).data('route'), 'ajaxType': 'GET'});
            },

            'open_popup_editProduct': function () {
                if (Lp.isAddedNewProduct(v.table)) {
                    return false;
                }

                Lp.ajax_modalFormOpen({'route': $(this).data('route'), 'ajaxType': 'GET', 'ckeditor': true});
            }
        },
        'event': {
            'search': function () {
                let val = $(this).val().trim();

                let url = new URL(window.location.href);

                if (val !== '') {
                    url.searchParams.set('search', val);
                    url.searchParams.set('page', 1);
                }
                else {
                    url.searchParams.delete('search');
                    url.searchParams.set('page', 1);
                }

                // debounce – да не стреля на всяка буква
                clearTimeout(window.__zenovaSearchTimer);
                window.__zenovaSearchTimer = setTimeout(function () {
                    window.location.href = url.toString();
                }, 400);
            },

            // ако бутон е забранен се извежда съобщение когато се кликне на него
            'isAllowed': function () {
                var _this = $(this);
                var action = _this.data('action');

                if (action == 'zenoobr') {
                    alert('Преди да направите индивидуално ценообразуване е необходимо да направите първо нормално ценообразуване');
                }
                else {
                    alert(this.outerText + ' ' + LANG__zenovaOferta.zenova.buttonDisabled);//функцията ще бъде активна след запис
                }

                _this.removeAttr('href');
                return false;
            }
        },
        'btn': {
            'leftAside': {},

            'table': {
                'delete_sinleProduct': function (e) {
                    e.stopImmediatePropagation();
                    var tr = $(this).closest('tr');
                    var id = tr.data('id');
                    var route = $(this).data('delete-route');
                    var zenovaId = $(this).data('ofer-id');
                    var productName = tr.find('td.productName').text( ).trim( );
                    var confirmMsg = LANG__global.confirm.delete_tbl_row + productName;

                    if (! id || ! route) {
                        return;
                    }

                    if (! confirm(confirmMsg)) {
                        return;
                    }

                    $.ajax({
                        url: route,
                        type: 'POST',
                        data: {'productIds': id, 'zenovaId': zenovaId},
                        dataType: 'json',
                        success: function (response) {
                            if (response && response.err) {
                                alert(response.err);
                            }

                            history.go(0);

                        }
                    });
                },

                'selectAllProducts': function () {
                    let checked = $(this).is(':checked');

                    $(v.table).find('tbody tr:visible .product-check').prop('checked', checked);
                },

                'syncSelectAll': function () {
                    let totalVisible = $(v.table).find('tbody tr:visible .product-check').length;
                    let checkedVisible = $(v.table).find('tbody tr:visible .product-check:checked').length;

                    $('#selectAllProducts').prop('checked', totalVisible === checkedVisible);
                },

                'deleteSelectedProducts': function (e) {
                    e.stopImmediatePropagation();
                    let ids = [ ];
                    let zenovaId = '';

                    $(v.table).find('tbody .product-check:checked').each(function () {
                        ids.push($(this).val());
                        zenovaId = $(this).attr('data-ofer-id');
                    });

                    if (! ids.length) {
                        alert('Няма избрани продукти');
                        return;
                    }

                    $.confirm({
                        title: 'Потвърждение',
                        content: 'Сигурни ли сте, че искате да премахнете от само тази листа избраните продукти?',
                        type: 'red',
                        buttons: {
                            confirm: {
                                text: 'Да, изтрий',
                                btnClass: 'btn-red',
                                action: function () {
                                    $.post($('#deleteSelectedProducts').data('route'),
                                    {'productIds': ids, 'zenovaId': zenovaId},
                                            function () {
                                                history.go(0);
                                            }
                                    );
                                }
                            },
                            cancel: {text: 'Отказ'}
                        }
                    });
                },

                // х-ки на продут
                'productAttributesData': function ( ) {
                    let _this = $(this);
                    let route = _this.data('route');

                    if (_this.hasClass('tooltipstered')) {
                        return false;
                    }

                    $.ajax({
                        url: route,
                        type: 'GET',
                        dataType: 'json',
                        success: function (response) {
                            var myObj = '';

                            if (Array.isArray(response)) {
                                myObj = response.map(item => `<label title="${item.value}">${item.value}:</label> ${item.product_characteristic_text}`).join('<br>');
                            }
                            else {
                                myObj = response;
                            }

                            _this.attr({
                                title: '<label><u> Характеристики </u></label> <br><br>' + myObj,
                                'data-toggle': 'tooltip'
                            });

                            Lp.popupTitle();
                            _this.trigger('click');
                        }
                    });
                },

                // клониране на продут
                'cloneProduct': function ( ) {
                    let _this = $(this);
                    let route = _this.data('route');
                    let productName = _this.data('productName');
                    let newProductName = prompt('Въведете ново име на продукт', productName);

                    if (! newProductName) {
                        return false;
                    }

                    if (newProductName.trim() == '') {
                        alert('Името е празно!');
                        return false;
                    }

                    if (! confirm(`Сигурни ли сте, че искате да клонирате продукт: ${productName}?`)) {
                        return false;
                    }

                    $.ajax({
                        url: route,
                        type: 'POST',
                        data: {'newProductName': newProductName},
                        dataType: 'json',
                        success: function (response) {
                            if (response.dub === true) {
                                alert(response.data);
                                return false;
                            }

                            if (response.lastId === true) {
                                // Искате ли да добавите новосъздадения продукт към офертата
                                if (confirm('Искате да добавите клонираният продукт към текущата оферта?') == true) {
                                    $(v.table).find('tbody').append(response.data);
                                }
                            }
                        }
                    });
                },

                // премахване на всички продукти присвоени към сайтове за конкретната ценова листа
                'delete_fromAllSites': function () {
                    let is_toSite = 0; // false
                    let msg = 'Сигурни ли сте, че искате да отмаркирате всички продукти участващи в сайтовете!';
                    helper.toggleProductsToSite(this, is_toSite, msg);
                },

                // всички на продукт към всички сайтове за конкретната ценова листа
                'change_allSite': function () {
                    let is_toSite = 1; // true 
                    let msg = 'Сигурни ли сте, че искате да маркирате всички продукти участващи в сайтовете!';
                    helper.toggleProductsToSite(this, is_toSite, msg);
                },

                // маркиране на продукт към всички сайтове за конкретната ценова листа
                'toSite': function (e) {
                    const _this = $(this);
                    let tr = _this.closest('tr');
                    let productName = tr.find('td.productName').data('name');
                    let route = $(this).data('route');
                    let hasKKC = $(this).data('has-kkc');

                    let hasRootcat = $(this).data('has-rootcat');
                    let hasMqrka = $(this).data('has-mqrka');
                    let is_toSite = _this.is(':checked') ? 1 : 0; // 0-false 1-true
                    let actionText = is_toSite ? 'добавите в' : 'премахнете от';

                    // Филтрира null стойностите от priceData , само ако има ценообразуванр може да се добави към сайтове
//                    let filteredPriceData = _this.data('price').filter(function (price) {
//                        return price !== null;
//                    });

                    if (tr.data('fromizborproduct')) {
                        alert('Тъй като продукта е нов в ценовата листа е необходимо преди да се добави към сайт, да се направи запис.');
                        return false;
                    }
                    else if (productName == '') {
                        alert('Липсва име на продукта!');
                        return false;
                    }
                    else if (! hasRootcat) {
                        alert('Липсва категория на продукта!');
                        return false;
                    }
                    else if (! hasMqrka) {
                        alert('Липсва мерна единица за наличност на продукта!');
                        return false;
                    }

                    else if (! hasKKC) {
                        alert('Ценообразуване не е пълно за този продукт. Липсва цена ККЦ!');
                        return false;
                    }

                    if (! confirm(`Сигурни ли сте, че искате да ${actionText} всички сайтове продукта \n\n ${productName}`)) {
                        return false;
                    }

                    $.ajax({
                        url: route,
                        type: 'POST',
                        data: {'is_toSite': is_toSite},
                        dataType: 'json',
                        success: function (response) {
                            if (response.err) {
                                _this.prop('checked', false);
                                alert(response.err);
                            }
                            else if (response.success) {
                                alert(response.success);
                            }
                        }
                    });
                },
            },

            'header': {
                'save': function () {
                    //var deletedProductArrId = $(this).attr('data-delete-product').split(',');
                    var deletedProductArrId = ( $(this).attr('data-delete-product') || '' ).split(',').filter(id => id);

                    if (! confirm(LANG__zenovaOferta.zenova.save)) {
                        return false;
                    }

                    if ($(v.table).find('tbody tr').length == 0) {
                        alert(LANG__zenovaOferta.alert.emptyProducts);
                        return false;
                    }

                    $(document).off('submit').on('submit', 'form', function (e) {
                        e.preventDefault();

                        if (validate_empty.validate(e, null, null, $('#leftAside')) == true) {
                            return false;
                        }

                        var form = $(this);
                        var pageOrder = [ ];
                        var urlParams = new URLSearchParams(window.location.search);
                        var currentPage = parseInt(urlParams.get('page') || 1, 10);
                        var perPage = parseInt(urlParams.get('perPage') || 20, 10);
                        var payload = form.serializeJSON({checkboxUncheckedValue: 'false'});

                        $(v.table).find('tbody tr:not(.colorRows)').each(function () {
                            var id = $(this).data('id');
                            if (id) {
                                pageOrder.push(id);
                            }
                        });

                        payload.currentPageOrder = pageOrder.join(',');
                        payload.currentPage = currentPage;
                        payload.perPage = perPage;

                        $.ajax({
                            url: form.attr('data-route'),
                            type: 'POST',
                            data: {
                                'form': JSON.stringify(payload),
                                'deletedProductArrId': deletedProductArrId
                            },
                            dataType: 'json',
                            success: function (response) {
                                if (response.err) {
                                    alert(response.err);
                                }
                                //ако е нова оферта се пренасрочва
                                else if (response.hasOwnProperty('url')) {
                                    window.location.href = response.url;
                                }
                            }
                        });

                        e.stopImmediatePropagation();
                    });
                }
            }
        },

        'helper': {
            // добавяне на продукти към сайтове за конкретната ценова листа
            'toggleProductsToSite': function (el, is_toSite, msg) {
                let _this = $(el);
                let route = _this.data('route');
                let productIds = _this.attr('data-product-ids');

                if (! confirm(msg))
                    return;

                $.ajax({
                    url: route,
                    type: 'POST',
                    data: {'productIds': productIds, 'is_toSite': is_toSite},
                    dataType: 'json',
                    success: function (response) {
                        if (response.err) {
                            alert(response.err);
                            return;
                        }

                        if (response.success) {
                            let isChecked = is_toSite ? 1 : 0;

                            $(v.table).find('tbody input.toSite').prop('checked', isChecked);
                            alert(response.success);
                        }
                    }
                });
            },
        }
    };

    zenova.init();

}(window.jQuery, window, document) );
