/* global loadPlugins, SETTINGS_NUM_FIXED, tableActions, leftAsideActions  */
( function ($, window, document) {

    var special = special || {};
    let v = special;
    let $self = special;

    $('form').dontJustLeaveMe('a#prinPreview'); // plygin za напускане на стр и  ако има промяна 

    special = {
        '__var': {
            table: '#tbl_products'
        },
        'init': function () {
            v = this.__var;
            $self = this;
            $root = this;

            this.plugins();
            this.setUpListeners();
        },
        'plugins': function () {
            Lp = loadPlugins;
            Ta = tableActions;
            Lsa = leftAsideActions;

            //Lp.selectpicker()
            //Lp.select2Simple();
            //Lp.lazyLoadTable();
            Lp.zoomImg();
            Lp.popupTitle();
            Lp.table_freezeHeader({'table': v.table, 'margin': 100}); // thead frezze
            Lp.tableRow_filter({'input': '#filter', 'table': v.table});

            Ta.getTotal_inFooter({'table': v.table, 'autoTigger': true});
            Ta.tableRow.move();

            Lsa.colorChoice(); // избор на цветни редове
        },
        'setUpListeners': function ( ) {
            // DISABLED CLICK
            $(document).on('click', '[disabled]', function (e) {
                e.stopImmediatePropagation();

                var _this = $(this);

                alert(_this.text().trim() + ' ' + LANG__special.buttonDisabled); //функцията ще бъде активна след запис

                return false;
            });

            // POPUP 
            $(document)
                    .on('click', 'tbody .edit_product, #new_product', this.modal.open_popup_editProduct)
                    .on('click', '#izbor-zenova', this.modal.open_popup_izborZenova)
                    .on('click', '#izbor-product', this.modal.open_popup_izborProduct)
                    .on('click', '#add-colorRow', this.modal.open_popup_colorRow);

            //EVENTS
            $(document)
                    // --- left aside
                    .on('changed.bs.select', '#leftAside #valuta_izbor', Lsa.changeValuta)

                    // --- in table
                    .on('mouseover', 'tbody .rowPosition', Ta.tableRow.position.getTitle)
                    .on('keyup', 'td.qty .qty, td.zenaProdava .zenaProdava ', function () {
                        Ta.getTotal_inFooter({'table': v.table});
                    })
                    .on('blur', 'td.zenaProdava .zenaProdava ', function () {
                        var numDec = this.value;

                        if (numDec != '') {
                            this.value = Lp.toFixed(this.value);
                            $(this).trigger('keyup');
                        }
                    });


            //BTN
            $(document)
                    // --- left aside
                    .on('click', '#leftAside .colorDisplay', Lsa.changeColor)

                    // --- in table
                    .on('click', '.badge_index', this.btn.table.badge_index_toAllProduct)
                    .on('click', '#clone-product', this.btn.table.cloneProduct)
                    .on('click', '#priceLevel button, #priceLevelAll button', Ta.tableRow.get_priceLevel) //избор на ц. ниво от tooltip
                    .on('click', 'tbody .getGensoftInfo', Ta.getGensoftInfo)// изв на информация от Gensoft за конкретния продукт
                    .on('click', 'tbody .rowPosition', Ta.tableRow.position.setPosition)
                    .on('click', 'tbody tr.colorRows .edit_colorRow', Ta.colorRow.edit)
                    .on('click', 'tbody .delete_colorRow', Ta.colorRow.delete)
                    .on('click', 'tbody .delete_product', Ta.tableRow.delete)

                    // --- header
                    .on('click', '#genOfertUrlLink', this.btn.header.genOfertUrlLink)
                    .on('click', '#cloneOfer', this.btn.header.cloneOfer)
                    .on('click', '#save-ofer', this.btn.header.save);

        },

        'modal': {

            'open_popup_colorRow': function () {
                var colorValue = $('#left-aside').find('#colorValue').val();

                if ($(v.table).find('tbody tr').length == 0) {
                    alert(LANG__special.alert.emptyProducts);//ДОбавете поне 1 продукт в таблицата
                    return false;
                }

                Lp.ajax_modalFormOpen({'route': $(this).data('route'), 'ajaxType': 'POST', 'datastr': `colorValue=${colorValue}`});
            },

            'open_popup_izborZenova': function () {
                Lp.ajax_modalFormOpen({'route': $(this).data('route'), 'ajaxType': 'GET'});
            },

            'open_popup_izborProduct': function () {
                Lp.ajax_modalFormOpen({'route': $(this).data('route'), 'ajaxType': 'GET'});
            },

            'open_popup_editProduct': function () {
                if (Lp.isAddedNewProduct(v.table)) {
                    return false;
                }
                
                Lp.ajax_modalFormOpen({'route': $(this).data('route'), 'ajaxType': 'GET', 'ckeditor': true});
            }
        },

        'event': {},

        'btn': {
            'leftAside': {},

            'table': {
                // присвояване на стикер за всички продукти
                'badge_index_toAllProduct': function (e) {
                    e.stopImmediatePropagation();
                    const _this = $(this)
                    const route = _this.data('route');
                    let index = _this.data('index');
                    let productIds = _this.data('productids');
                    let mapIndex = {
                        1: 'нови',
                        2: 'очаквани',
                    };

                    if (! confirm(`Тази операция ще промени стикера на ${mapIndex[index]} за всички продукти в тaзи оферта! Продължавате ли?`)) {
                        return false;
                    }

                    $.ajax({
                        url: route,
                        type: 'POST',
                        data: {'productIds': productIds, 'index': index},
                        dataType: 'json',
                        success: function (response) {
                            alert('Всички продукти са обновени с избраният стикер');
                            history.go();
                        }
                    });
                },

                // клониране на продут
                'cloneProduct': function ( ) {
                    let _this = $(this);

                    let route = _this.data('route');
                    let productName = _this.data('productName');

                    if (! confirm(`Сигурни ли сте, че искате да клонирате продукт: ${productName}?`)) {
                        return false;
                    }

                    let newProductName = prompt('Въведете ново име на продукт', productName);

                    if (newProductName == '') {
                        alert('Името е празно!');
                        return false;
                    }

                    if (! newProductName) {
                        return false;
                    }

                    $.ajax({
                        url: route,
                        type: 'POST',
                        data: {'newProductName': newProductName},
                        dataType: 'json',
                        success: function (response) {
                            if (response.dub === true) {
                                alert(response.data);
                                return false;
                            }

                            if (response.lastId === true) {
                                // Искате ли да добавите новосъздадения продукт към офертата
                                if (confirm('Искате да добавите клонираният продукт към текущата оферта?') == true) {
                                    $(v.table).find('tbody').append(response.data);
                                }
                            }
                        }
                    });
                },
            },

            'header': {
                //  бутон генериране на URL линк за дирла оферта по ид 
                'genOfertUrlLink': function (e) {
                    let oferId = $(document).find('#hiddenOferId').val();

                    $('#leftAside').find('#urlLink').val('shop?dilarUrl=' + oferId);
                    alert('Създаден е URL линк');
                },

                'cloneOfer': function (e) {
                    var _this = $(this);
                    var route = _this.data('route');
                    var oferName = _this.data('name');

                    oferName = prompt('Ако желаете може да промените името', oferName + '_1');

                    if (oferName == '') {
                        alert('Трябва да въведете име за клонираната оферта.');
                        return false;
                    }

                    if (! confirm('Сигурни ли сте, че искате да клонирате тази оферта?')) {
                        return false;
                    }

                    $.ajax({
                        url: route,
                        type: 'POST',
                        data: {'oferName': oferName},
                        dataType: 'json',
                        success: function (response) {
                            if (response.err) {
                                alert(response.err);
                                return false;
                            }
                            else {
                                alert('Клонирането е изпълнено.');
                            }
                        }
                    });

                    e.stopImmediatePropagation();
                },

                'save': function (e) {

                    if (! confirm(LANG__special.confirm.save)) {
                        return false;
                    }

                    if ($(v.table).find('tbody tr').length == 0) {
                        alert(LANG__special.alert.emptyProducts);
                        return false;
                    }

                    if (validate_empty.validate(e, null, null, $('#leftAside')) == true) {
                        return false;
                    }

                    $(document).off('submit').on('submit', 'form', function (e) {
                        e.preventDefault();

                        var form = $(this);

                        $.ajax({
                            url: form.attr('data-route'),
                            type: 'POST',
                            data: {'form': JSON.stringify(form.serializeJSON())},
                            dataType: 'json',
                            success: function (response) {
                                if (response.err) {
                                    alert(response.err);
                                }
                                //ако е нова оферта се пренасрочва
                                else if (response.hasOwnProperty('url')) {
                                    window.location.href = response.url;
                                }
                            }
                        });

                        e.stopImmediatePropagation();
                    });
                }
            }
        }
    };

    special.init();

}(window.jQuery, window, document) );
