/* global Lp, loadPlugins */
( function ($, window, document) {

    var providerMainPage = providerMainPage || {};
    let v = providerMainPage;

    providerMainPage = {
        'init': function () {
            this.plugins();
            this.setUpListeners();
        },
        'plugins': function () {
            Lp = loadPlugins;
        },
        'setUpListeners': function ( ) {

            // EVENTS  
            $('#filterGrProvider').on('input propertychange paste change', this.event.filterGrProvider);
            $('#filterProvider').on('input propertychange paste change', this.event.filterProvider);
            $('.autocomplete_provider').on('keyup', Lp.debounce(this.event.autocomplete_provider, 500));

            //BTN
            $('ul#groupProvider')
                    .on('click', '.node-plus', this.btn.expand)
                    .on('click', '.node-minus', this.btn.collapse)
                    .on('click', '.add_inGroup', this.btn.add_inGroup)
                    .on('click', '.edit_group', this.btn.edit_group);

            $('#createProvider').on('click', this.btn.create_provider);
            $('#createProviderGroup').on('click', this.btn.create_providerGroup);


            //EVENTS
            // $.v1.$modal.find('.color').on('click', this.btn.color);
        },

        'event': {
            'autocomplete_provider': function (e) {
                var This = $(this);
                var keycode = ( e.keyCode ? e.keyCode : e.which );
                var arr;


                if (keycode == 40 || keycode == 38 || keycode == 13 || keycode == 37 || keycode == 39 || keycode == 18 || keycode == 16) {
                    return false;
                }

                // ако input полето е празно
                if ($(this).val().length == 0) {
                    $('.autocomplete').html('');
                    return false;
                }

                $.ajax({
                    url: $(this).attr('data-route'),
                    type: "GET",
                    data: {'searchName': $(this).val()},
                    dataType: 'json',
                    beforeSend: function (xhr) {
                        $(this).addClass('Spiner_loading');
                    },
                    success: function (response)
                    {
                        arr = [ ];

                        $('.Spiner_loading').removeClass('Spiner_loading');

                        $.each(response, function (index, value) {
                            var myObj = `{"provider_id":"${value['provider_id']}","provider_name":"${value['provider_name']}"}`;

                            arr += "<li data-info='" + myObj + "' >" + value['provider_name'] + '</li>';
                        });

                        This.nextAll('.autocomplete').html('<div class="triangle"></div><ul></ul>');
                        $('.autocomplete').find('.triangle').css({'top': This.position().top + 'px'});
                        if (arr.length != 0) {
                            $('.autocomplete ul').html(arr);
                        }
                        else {
                            $('.autocomplete ul').html('<li>Не са открити резултати</li>');
                        }

                        // когато изберем клиент от списъка autocomplete
                        $('.autocomplete ul').on('mousedown', 'li', function () {
                            var providerId = $(this).data('info').provider_id;

                            $(e.target).val($(this).text());
                            $(e.target).attr('data-id', providerId).data('id', providerId);

                            $('.autocomplete').html('');
                        });
                    }
                });

                $(e.target).blur(function () {
                    $('.autocomplete').html('');// премахване на autocomplete списъка
                });
            },

            'filterProvider': function (e) {

                var labels = $('ul#provider label');
                var valThis = $(this).val().trim().toLowerCase();

                if (valThis === '') {
                    labels.parents().show();
                }
                else {
                    labels.each(function () {
                        var label = $(this);
                        var text = label.text().toLowerCase();

                        if (text.includes(valThis) === true) {
                            label.closest('li').show();
                        }
                        else {
                            label.closest('li').hide();
                        }
                    });
                }
                e.stopImmediatePropagation( );
            },

            'filterGrProvider': function (e) {

                var labels = $('ul#groupProvider label');
                var valThis = $(this).val().trim().toLowerCase();

                if (valThis === '') {
                    labels.parent().show();
                    labels.parents('ul.child').hide();
                }
                else {
                    labels.each(function () {
                        var label = $(this);
                        var text = label.text().toLowerCase();

                        if (text.includes(valThis) === true) {
                            label.parents().show();
                        }
                        else {
                            label.parent().hide();
                        }
                    });
                }
                e.stopImmediatePropagation( );
            }
        },

        'btn': {
            'create_providerGroup': function (e) {
                var providerGroupName = $(document).find('#providerGroupName');

                if (providerGroupName.val() == '') {
                    alert('Въведете име на групата');
                    return false;
                }
            },

            'create_provider': function (e) {
                var providerName = $(document).find('#providerName');

                if (providerName.val() == '') {
                    alert('Въведете име на доставчик');
                    return false;
                }
            },

            // разгъване на категория
            'expand': function (e) {
                var li = $(this).closest('li');

                $(this).toggleClass('node-plus node-minus');
                li.find('ul.child').toggle( );
                li.siblings( ).find('ul.child').hide( );
                li.siblings( ).find('.node-minus').toggleClass('node-minus node-plus');

                e.stopImmediatePropagation( );
            },
            // сгъване на категория
            'collapse': function (e) {
                var _this = $(this);

                _this.closest('li').find('ul').hide( );
                _this.toggleClass('node-minus node-plus');

                e.stopImmediatePropagation( );
            },

            // редакция на група 
            'edit_group': function (e) {
                let li = $(this).closest('li');
                let el = li.find('.groupName');

                let route = $(this).data('route');
                let btnGroup = li.find('.btnGroup');

                btnGroup.hide();

                Lp.loadDoomEdit({'el': el, 'route': route, 'action': 'edit', 'btnGroup': btnGroup});
            },

            // добавяне на доставчик в група 
            'add_inGroup': function (e) {
                var _this = $(this);

                var ul = _this.closest('ul');
                var li = _this.closest('li');

                var route = _this.data('route');
                var providerGroupId = li.data('groupid');
                var providerNameInput = li.find('.autocomplete_provider');
                var providerId = li.find('.autocomplete_provider').data('id');

                var iconIsFull = li.closest('.group');

                if (providerNameInput.val( ) == '') {
                    alert('Въведете ново име'); //Липсва име на категория!
                    providerNameInput.focus( );
                    return false;
                }

                $.ajax({
                    url: route,
                    type: 'POST',
                    data: {
                        'providerId': providerId,
                        'providerGroupId': providerGroupId,
                        'providerName': providerNameInput.val( ).trim( )
                    },
                    dataType: 'json',
                    success: (response) => {
                        providerNameInput.val('');

                        if (response.isNew) {
                            ul.append(response.li);

                            if (ul.children('li:not(:first)').length === 1) {
                                iconIsFull.find('i.isFull').toggleClass('fa-battery-empty fa-battery-full');
                            }
                        }
                        else {
                            li.find('label').text(providerNameInput.val( ));
                        }
                    }
                });

                e.stopImmediatePropagation( );
            }
        }
    };
    providerMainPage.init();

}(window.jQuery, window, document) );
