/* global Lp, loadPlugins */
( function ($, window, document) {

    var provider = provider || {};
    let v = provider;

    provider = {
        'init': function () {
            this.setUpListeners();
        },

        'setUpListeners': function ( ) {
            $(document).find('header.fixed-top').hide();
            $(document).find('.content-wrapper .content-header').css({'top': 0});
            $(document).find('.content-wrapper .content').css({'padding-top': 0});

            $('.add_kontakt').on('click', this.btn.add_kontakt);
            $('.remove').on('click', function () {
                $(this).parent('div').remove();
            });

            // HEADER 
            // --- btn
            $(document).on('click', '#save-ofer', this.btn.header.save);
        },

        'event': {

            // ако бутон е забранен се извежда съобщение когато се кликне на него
            'isAllowed': function () {
                var _this = $(this);
                alert(this.outerText + ' ' + LANG__zenovaOferta.zenova.buttonDisabled);//функцията ще бъде активна след запис

                _this.removeAttr('href');
            }
        },
        'btn': {

            // добавяне на данни за доставчика в box кутията
            'add_kontakt': function () {
                var clone = '';
                var len = $(this).parent().parent().children('div').length;

                clone = $(this).parent().clone(true);
                clone = clone.find("input:text").val('').removeClass('required').end();
                clone = clone.find('.star').hide().end();
                clone = clone.find('.remove').removeClass('hide').end();

                clone.find("input:text").attr('name', function (i, k) {
                    return this.name.replace(/^(\w+)\[(\w+).*?\]\[.*?\]/, '$1[$2][' + len + ']');
                });

                // clone.find("input:text").attr('name').replace(/[\[\{](\d+)[\]\}]/g, "88")
                $(this).parent().after(clone);
            },

            'header': {
                'save': function () {

                    if (!confirm('Сигурни ли сте че искате да запишете промените')) {
                        return false;
                    }

                    $(document).off('submit').on('submit', 'form', function (e) {
                        e.preventDefault();

                        if (validate_empty.isEmpty('inTabMenu',$('form')) == true) {
                            return false;
                        }

                        var form = $(this);

                        $.ajax({
                            url: form.attr('data-route'),
                            type: 'POST',
                            data: form.serializeJSON(),
                            dataType: 'json',
                            success: function (response) {
                                //ако е нова оферта се пренасрочва
                                if (response.hasOwnProperty('url')) {
                                    window.location.href = response.url;
                                }
                            }
                        });

                        event.stopImmediatePropagation();
                    });
                }
            }
        }
    };

    provider.init();

}(window.jQuery, window, document) );
