/* global LANGpop__izborProduct, loadPlugins, tableActions */
( function ($, window, document, undefined) {

    var events = events || {};
    let v = events;

    $('tbody :input:first:visible').focus();

    events = {
        '__var': {
            table: '#tbl_products',
            form: $('form')
        },
        'init': function ( ) {
            v = this.__var;

            this.plugins( );
            this.validate( );
            this.setUpListeners( );
        },
        'plugins': function ( ) {
            Lp = loadPlugins;
            Ta = tableActions;
            Ta.table.filter({'input': '#filter', 'table': v.table}); // филтър
            Lp.datepicker( );
        },
        'validate': function () {// промяна на задължит. select box
            $(document).on('keyup', '[required]', (e) => {
                if (v.form.find('[required]:visible').length > 0 && $(e.target).hasClass('css-animation-err') && validate.isEmpty(e.target)) {
                    e.stopImmediatePropagation( );
                    return false;
                }
            });
        },

        'setUpListeners': function ( ) {

            // EVENTS  
            $(document)
                    .on('change', '#filterSelect', this.event.changeFilterSelect)
                    .on('keyup', ' tbody [data-autocomplete]', Lp.debounce(this.event.autocomplete, 500));

            //BTN
            $(document)
                    .on('click', '.chooseFile', this.btn.chooseFile)
                    .on('click', '.deleteRow', this.btn.deleteRow)
                    .on('click', '.addRow', this.btn.addRow)
                    .on('click', '#saveRaznos', this.btn.save);
        },
        'event': {
            'autocomplete': function (e) {

                var This = $(this);
                var keycode = ( e.keyCode ? e.keyCode : e.which );
                var arr;
                var parent = $(this).parent();

                if (keycode == 40 || keycode == 38 || keycode == 13 || keycode == 37 || keycode == 39 || keycode == 18 || keycode == 16) {
                    return false;
                }

                // ако input полето е празно
                if ($(this).val().length == 0) {
                    $('.autocomplete').html('');
                    return false;
                }

                $.ajax({
                    url: $(this).attr('data-route'),
                    type: "POST",
                    data: {'text': $(this).val()},
                    dataType: 'json',
                    success: function (response)
                    {
                        arr = [ ];

//                        $.each(response, function (index, value) {
//                            var myObj = `{"provider_id":"${value['provider_id']}","provider_name":"${value['provider_name']}"}`;
//
//                            arr += "<li data-info='" + myObj + "' >" + value['provider_name'] + '</li>';
//                        });

                        $.each(response, function (index, value) {
                            //let gensoftIimg = '';
                            let myObj = JSON.stringify({
                                'gensoft_firm_id': value['gensoft_firm_id'],
                                'klient_id': value['klient_id'],
                                'mol': value['klient_mol'],
                                'klient_grad': value['klient_grad'],
                                'postCode': value['klient_postCode'],
                                'tel': value['klient_tel'],
                                'adres': value['klient_adres'],
                                'klient_country': value['klient_country']
                            });

                            if ($.isNumeric(value['gensoft_firm_id'])) {
                                //gensoftIimg = `<img class='w-13 mr-1' src='${gensoftLogo.find('img').attr('src')}'>`;
                            }

                            arr.push(`<li data-info='${myObj}'>${value['klient_name']}</li>`);
                        });

                        This.nextAll('.autocomplete').html('<div class="triangle"></div><ul></ul>');
                        $('.autocomplete').find('.triangle').css({'top': This.position().top + 'px'});
                        if (arr.length != 0) {
                            $('.autocomplete ul').html(arr);
                        }
                        else {
                            $('.autocomplete ul').html('<li>не са открити резултати</li>');
                        }

                        // когато изберем клиент от списъка autocomplete
                        $('.autocomplete ul').on('mousedown', 'li', function () {
                            $(e.target).val($(this).text());
                            parent.find('span.name').text($(this).text());
                            $('.autocomplete').html('');
                        });
                    }
                });

                $(e.target).blur(function () {
                    $('.autocomplete').html('');// премахване на autocomplete списъка
                });
            },

            'changeFilterSelect': function (e) {
                let table = $(this).closest('table');
                let selectedValue = $(this).val( );
                Lp.tableRow_filterBySelect(table, selectedValue); // филтър
            }
        },
        'btn': {
            'chooseFile': function (e) {
                var _this = $(this);
                var fileInput = _this.parent().find('input[type=file]');

                fileInput.click();

                fileInput.off('change').on('change', function (e) {
                    var fileLenght = fileInput[0].files.length;
                    var selectedFile = $(this).prop('files')[0];
                    var tr = _this.closest('tr');

                    if (fileLenght > 0) {
                        tr.find('.fileName').val(selectedFile.name);
                    }
                });
            },

            'addRow': function (e) {
                let tbody = $(this).closest('table').find('tbody');
                let tr = tbody.find('tr');
                let rowCount = tr.siblings( ).addBack( ).length;
                let clone = tr.eq(0).clone( );

                clone.find('input,textarea,select').attr('name', function (i, k) {
                    return this.name.replace(/^\[.*?\]\[(\w+).*?\]/, '[' + rowCount + '][$1]');
                }).val('');

                clone.find('.downloadFile').hide();

                tbody.prepend(clone);

                $('tbody :input:first:visible').focus();
            },
            'deleteRow': function (e) {
                let tr = $(this).closest('tr');
                let rowCount = tr.siblings( ).addBack( ).length;

                if (!confirm(`Искате ли да премахнете ${tr.find('.name').val( )}`)) {
                    return false;
                }

                if (rowCount == 1) {
                    tr.find('input,textarea,select').val('');
                }
                else {
                    tr.remove( );
                }

            },
            'save': function (e) {
                var form = $('#form-raznos');
                var filesInput = form.find('input[type=file]');
                var route = form.data('route');
                var fd = new FormData();

                if (!confirm('Сигурни ли сте че искате да запишете промените')) {
                    return false;
                }

                if (validate.isEmpty(form) === true) {
                    return false;
                }

                $(filesInput).each(function (index, fileInput) {
                    if (fileInput.files.length > 0) {
                        fd.append("files[]", fileInput.files[0]);
                    }
                });


                fd.append('json', JSON.stringify(form.find(':input').filter(function () {
                    return $.trim(this.value).length > 0;
                }).serializeJSON()));

                $.ajax({
                    url: route,
                    type: 'POST',
                    data: fd,
                    dataType: 'json',
                    contentType: false,
                    processData: false,
                    success: function (response) {

                        if (response.msg.success) {
                            $('#deleteRaznos').removeAttr('disabled');
                            filesInput.val('');
                            $('body').prepend(response.msg.messages);
                            form.find('table tbody').html(response.view);
                        }
                    }
                });
                event.stopImmediatePropagation( );
            }
        }
    };

    events.init( );
} )(jQuery, window, document);
