/* global loadPlugins, SETTINGS_NUM_FIXED, leftAsideActions, tableActions  */
( function ($, window, document) {

    var bizKlient = bizKlient || {};
    let v = bizKlient;
    let $self = bizKlient;

    $('form').dontJustLeaveMe('a#prinPreview'); // plygin za напускане на стр и  ако има промяна 
    //в офертата за предпечат ценообр и нова оферта

    bizKlient = {
        '__var': {
            table: '#tbl_products'
        },
        'init': function () {
            v = this.__var;
            $self = this;
            $root = this;

            this.plugins();
            this.setUpListeners();
        },
        'plugins': function () {
            Lp = loadPlugins;
            Ta = tableActions;
            Lsa = leftAsideActions;

            //Lp.lazyLoadTable();
            Lp.zoomImg();
            Lp.popupTitle();
            Lp.table_freezeHeader({'table': v.table, 'margin': 122}); // thead frezze
            Lp.tableRow_filter({'input': '#filter', 'table': v.table}); // филтър

            Ta.getTotal_inFooter({'table': v.table, 'autoTigger': true});
            Ta.tableRow.move();
        },
        'setUpListeners': function ( ) {

            // DISABLED CLICK
            $(document).on('click', '[disabled]', this.event.isAllowed);

            // POPUP 
            $(document)
                    .on('click', '#izbor-zenova', this.modal.open_popup_izborZenova)
                    .on('click', 'tbody .edit_product, #new_product', this.modal.open_popup_editProduct)
                    .on('click', '#izbor-product', this.modal.open_popup_izborProduct);


            //EVENTS
            $(document)
                    // --- left aside
                    .on('keyup', '#leftAside #patenRazhod input', this.event.leftAside.changeRazhod)
                    .on('change', '#leftAside input.isDDS', this.event.leftAside.dds)
                    .on('changed.bs.select', '#leftAside #valuta_izbor', Lsa.changeValuta)

                    // --- in table
                    .on('mouseover', 'tbody .rowPosition', Ta.tableRow.position.getTitle)
                    .on('keyup', 'td.qty .qty, td.zenaProdava .zenaProdava ', function () {
                        Ta.getTotal_inFooter({'table': v.table});
                    })
                    .on('blur', 'td.zenaProdava .zenaProdava ', function () {
                        var numDec = this.value;

                        if (numDec != '') {
                            this.value = Lp.toFixed(this.value);
                            $(this).trigger('keyup');
                        }
                    });

            //BTN
            $(document)
                    // --- left aside
                    .on('changed.bs.select', '#leftAside .colorDisplay', Lsa.changeColor)

                    // --- in table
                    .on('click', '#clone-product', this.btn.table.cloneProduct)
                    .on('click', '#priceLevel button, #priceLevelAll button', Ta.tableRow.get_priceLevel) //избор на ц. ниво от tooltip
                    .on('click', 'tbody .getGensoftInfo', Ta.getGensoftInfo)// изв на информация от Gensoft за конкретния продукт
                    .on('click', 'tbody .rowPosition', Ta.tableRow.position.setPosition)
                    .on('click', 'tbody .delete_product', Ta.tableRow.delete)

                    // --- header
                    .on('click', '#cloneOfer', this.btn.header.cloneOfer)
                    .on('click', '#save-ofer', this.btn.header.save);
        },

        'modal': {
            'open_popup_izborZenova': function () {
                Lp.ajax_modalFormOpen({'route': $(this).data('route'), 'ajaxType': 'GET'});
            },

            'open_popup_izborProduct': function () {
                Lp.ajax_modalFormOpen({'route': $(this).data('route'), 'ajaxType': 'GET'});
            },

            'open_popup_editProduct': function () {
                if (Lp.isAddedNewProduct(v.table)) {
                    return false;
                }

                Lp.ajax_modalFormOpen({'route': $(this).data('route'), 'ajaxType': 'GET', 'ckeditor': true});
            }
        },

        'event': {

            // ако бутон е забранен се извежда съобщение когато се кликне на него
            'isAllowed': function () {
                var _this = $(this);

                alert(this.outerText + ' ' + LANG__special.buttonDisabled);//функцията ще бъде активна след запис

                _this.removeAttr('href');
            },

            'leftAside': {
                // разходи
                'changeRazhod': function (e) {
                    // Select the table element using jQuery
                    const table = $(v.table);
                    const CELL__razhod = table.find('tfoot tr#razhod th.suma');
                    const CELL__pechalba = table.find('tfoot tr#pechalba th.suma');
                    const CELL__pechalbaPercent = table.find('tfoot tr#pechalba th.percent');
                    const CELL__totalPrihod = parseFloat(table.find('tfoot tr#prihod th.suma').text());
                    const valuta_symbol = $('#leftAside').find('#valuta_izbor option:selected').data('symbol') || '';


                    let totalRazhod = 0;

                    $(this).closest('#patenRazhod').find('input').each(function () {
                        totalRazhod += Number(this.value);
                    });

                    if (totalRazhod !== 0) {
                        const profit = CELL__totalPrihod - totalRazhod;
                        const profitPercent = Lp.toFixed(( profit / CELL__totalPrihod ) * 100);

                        CELL__razhod.text(totalRazhod + ' ' + valuta_symbol);
                        CELL__pechalba.text(Lp.toFixed(profit) + ' ' + valuta_symbol);
                        CELL__pechalbaPercent.text(profitPercent + ' %');
                    }
                    else {
                        CELL__razhod.text('');
                        CELL__pechalba.text('');
                        CELL__pechalbaPercent.text('');
                    }
                },

                // радио бутони за ддс
                'dds': function () {

                    // ако изберем радио бутона с ДДС
                    if ($(this).val( ) == '1') {
                        $(v.table).find('tfoot tr').removeClass('hide');
                    }
                    else {
                        $(v.table).find('tfoot tr:not(#total_bez_dds,#prihod,#pechalba,#razhod)').addClass('hide');
                    }
                },
            }
        },

        'btn': {
            'leftAside': {},

            'table': {
                // клониране на продут
                'cloneProduct': function ( ) {
                    let _this = $(this);

                    let route = _this.data('route');
                    let productName = _this.data('productName');

                    if (! confirm(`Сигурни ли сте, че искате да клонирате продукта: ${productName}?`)) {
                        return false;
                    }

                    let newProductName = prompt('Въведете ново име на продукт', productName);

                    if (newProductName == '') {
                        alert('Името е празно!');
                        return false;
                    }

                    if (! newProductName) {
                        return false;
                    }

                    $.ajax({
                        url: route,
                        type: 'POST',
                        data: {'newProductName': newProductName},
                        dataType: 'json',
                        success: function (response) {
                            if (response.dub === true) {
                                alert(response.data);
                                return false;
                            }

                            if (response.lastId === true) {
                                // Искате ли да добавите новосъздадения продукт към офертата
                                if (confirm('Искате да добавите клонираният продукт към текущата оферта?') == true) {
                                    $(v.table).find('tbody').append(response.data);
                                }
                            }
                        }
                    });
                },
            },

            'header': {

                'cloneOfer': function (e) {
                    e.stopImmediatePropagation();

                    var _this = $(this);
                    var route = _this.data('route');
                    var oferName = _this.data('name');

                    oferName = prompt('Ако желаете може да промените името', oferName + '_1');

                    if (oferName == '') {
                        alert('Трябва да въведете име за клонираната оферта.');
                        return false;
                    }

                    if (! confirm('Сигурни ли сте, че искате да клонирате тази оферта?')) {
                        return false;
                    }

                    $.ajax({
                        url: route,
                        type: 'POST',
                        dataType: 'json',
                        data: {'oferName': oferName},
                        success: function (response) {
                            if (response.err) {
                                alert(response.err);
                                return false;
                            }
                            else {
                                alert('Клонирането е изпълнено.');
                            }
                        }
                    });
                },

                'save': function (e) {

                    if (! confirm(LANG__special.confirm.save)) {
                        return false;
                    }

                    if ($(v.table).find('tbody tr').length == 0) {
                        alert(LANG__special.alert.emptyProducts);
                        return false;
                    }

                    if (validate_empty.validate(e, null, null, $('#leftAside')) == true) {
                        return false;
                    }

                    $(document).off('submit').on('submit', 'form', function (e) {
                        e.preventDefault();

                        var form = $(this);

                        $.ajax({
                            url: form.attr('data-route'),
                            type: 'POST',
                            data: {'form': JSON.stringify(form.serializeJSON())},
                            dataType: 'json',
                            success: function (response) {
                                if (response.err) {
                                    alert(response.err);
                                }
                                //ако е нова оферта се пренасрочва
                                else if (response.hasOwnProperty('url')) {
                                    window.location.href = response.url;
                                }
                            }
                        });

                        e.stopImmediatePropagation();
                    });
                }
            }
        }
    };

    bizKlient.init();

}(window.jQuery, window, document) );
