/* global loadPlugins */

( function ($, window, document, undefined) {

    var mainPage_fileAction = mainPage_fileAction || {};

    mainPage_fileAction = {

        'init': function () {
            this.setUpListeners();
        },

        'setUpListeners': function ( ) {
            //EVENTS

            //BTN
            $(document)
                    .on('click', '#chooseFile', this.btn.chooseFile)
                    .on('click', '#uploadFile', this.btn.uploadFile)
                    .on('click', '.uploadNewFile', this.btn.uploadNewFile)
                    .on('click', '.editFile', this.btn.editFile)
                    .on('click', '.saveFile', this.btn.saveFile)
                    .on('click', '.canselEdit', this.btn.canselEdit)
                    .on('click', '#canselFile', this.btn.canselFile);
        },

        'btn': {
            // избиране на файл за качване като пферта или цен листа 
            'chooseFile': function () {

                var _this = $(this);
                var fileInput = _this.parent().find('input[type=file]');
                var uploadFileName = _this.parent().find('#uploadFileName');
                var uploadFile = _this.parent().find('#uploadFile');
                var canselFile = _this.parent().find('#canselFile');

                fileInput.click();

                fileInput.off('change').on('change', function (e) {
                    var selectedFile = e.target.files[0];

                    if (selectedFile) {
                        uploadFileName.attr('placeholder', selectedFile.name).toggleClass('hide');

                        _this
                                .add(uploadFile)
                                .add(canselFile)
                                .toggleClass('hide');
                    }
                });
            },

            'uploadNewFile': function () {
                var _this = $(this);
                var route = $(this).data('route');
                var fileInput = _this.parent().find('input[type=file]');
                var uploadFileName = _this.closest('tr').find('td.offersName input');

                fileInput.click();

                fileInput.off('change').on('change', function (e) {
                    var fileLenght = fileInput[0].files.length;
                    var fd = new FormData();

                    //ако името е празно
                    if (uploadFileName.val() == '') {
                        alert('Внимание: Трябва да въведете име');
                        return false;
                    }
                    //ако не е избран файл
                    else if (fileLenght === 0) {
                        alert('Внимание: не е избран файл!');
                        return false;
                    }

                    fd.append('uploadName', uploadFileName.val().trim());
                    fd.append('file', fileInput[0].files[0]);

                    $.ajax({
                        url: route,
                        type: "POST",
                        contentType: false,
                        processData: false,
                        enctype: "multipart/form-data",
                        dataType: 'html',
                        data: fd,
                        cache: false,
                        success: function (data)
                        {
                            if (data.err) {
                                alert(data.err);
                            }
                            else {
                                alert('Файлът е качен');
                                location.reload();

                            }
                        }
                    });
                });
            },

            // качване на файл като оферта или цен. листа
            'uploadFile': function () {
                var _this = $(this);
                var fileInput = _this.parent().find('input[type=file]');
                var uploadFileName = _this.parent().find('#uploadFileName');
                var fileLenght = fileInput[0].files.length;
                var fd = new FormData();

                //ако името е празно
                if (uploadFileName.val() == '') {
                    alert('Внимание: Трябва да въведете име');
                    return false;
                }
                //ако не е избран файл
                else if (fileLenght === 0) {
                    alert('Внимание: не е избран файл!');
                    return false;
                }

                fd.append('uploadName', uploadFileName.val().trim());
                fd.append('file', fileInput[0].files[0]);

                $.ajax({
                    url: $(this).data('route'),
                    type: "POST",
                    contentType: false,
                    processData: false,
                    enctype: "multipart/form-data",
                    dataType: 'html',
                    data: fd,
                    cache: false,
                    success: function (response)
                    {
                        let data = JSON.parse(response);
                        
                        if (data.err) {
                            alert(data.err);
                            return false;
                        }

                        alert('Файлът е качен');
                        location.reload();
                    }
                });
            },

            // отказ от качването на файл
            'canselFile': function () {
                var _this = $(this);
                var fileInput = _this.parent().find('input[type=file]');
                var uploadFileName = _this.parent().find('#uploadFileName');
                var chooseFile = _this.parent().find('#chooseFile');
                var uploadFile = _this.parent().find('#uploadFile');
                var saveFile = _this.parent().find('#saveFile');
                var canselFile = _this.parent().find('#canselFile');

                chooseFile
                        .add(uploadFileName)
                        .add(uploadFile)
                        .add(saveFile)
                        .add(canselFile)
                        .toggleClass('hide');

                uploadFileName.val('');
                fileInput.val('');
            },

            // режим редакция на файл в таблицата
            'editFile': function () {
                var $tr = $(this).closest('tr');
                var $td = $(this).closest('td');


                $tr.find('td.offersName input[type=hidden]').attr('type', 'text');
                $tr.find('td.offersName span').toggleClass('hide');
                $td.find('.btnGroup1, .btnGroup2').toggleClass('hide');

            },

            // отказ от редакция на файл в таблицата
            'canselEdit': function () {
                var $tr = $(this).closest('tr');
                var $td = $(this).closest('td');

                $tr.find('td.offersName input[type=text]').attr('type', 'hidden');
                $tr.find('td.offersName span').toggleClass('hide');
                $td.find('.btnGroup1, .btnGroup2').toggleClass('hide');
            },

            // запис на файла след редакция в таблицата
            'saveFile': function () {
                var $tr = $(this).closest('tr');
                var $td = $(this).closest('td');
                var newName = $tr.find('td.offersName input[type=text]').val();
                var oldName = $tr.find('td.offersName span').text().trim();

                $.ajax({
                    url: $(this).data('route'),
                    type: 'POST',
                    data: {'newName': newName, 'oldName': oldName},
                    dataType: 'json',
                    success: function (data) {
                        if (data.err) {
                            alert(data.err);
                        }
                        else {
                            // $tr.find('td.offersName span').text(data.name);
                            // $td.find('.canselEdit').trigger('click');

                            alert(data.msg);
                            location.reload();
                        }

                    }
                });
            }
        }
    };

    mainPage_fileAction.init( );

} )(jQuery, window, document);

