( function ($, window, document, undefined) {

    function createTreeCore () {
        let v;
        let self;
        let $scope = null;
        let __block = null;
        let helpers = null;

        const core = {

            init (config) {
                v = config;
                this.v = config;
                self = this;
                helpers = this.helpers;
                $scope = $('body');
                __block = $scope.find(v.block);

                $('body').on('shown.bs.modal', () => {
                    const id = $('.modal').attr('id');

                    if (id) {
                        $scope = $('#' + id);
                        __block = $scope.find(v.block);
                        helpers.collapseAll();
                    }

                    this.bindEvents();
                });
            },

            /*  EVENTS BINDING
             * =============================== */
            'bindEvents': function () {
                $scope
                        .on('change', this.__block, function (e) {
                            e.stopImmediatePropagation();
                        })
                        .on('change', v.checkbox, this.ui.toggleCheckbox)
                        .on('change', v.selectSklad, this.ui.selectSklad)
                        .on('keyup', v.search, this.ui.search)

                        .on('click', v.btnToggleGensGrp + ', ' + v.btnCloseGensGrp,
                                this.btn.showGrp)

                        .on('click', v.node, this.btn.toggleNode)
                        .on('click', v.btnReset, this.btn.reset)
                        .on('click', v.btnGetSelected, this.btn.getSelected);
            },

            /*  UI 
             * =============================== */
            'ui': {
                'selectSklad': function (e) {
                    e.stopImmediatePropagation();

                    const $select = $(e.currentTarget);
                    const route = $select.data('route');
                    const skladId = $select.val();

                    $.ajax({
                        url: route,
                        type: 'POST',
                        dataType: 'json',
                        data: {skladId},
                        success: (response) => {
                            $scope.find(v.block + ' ' + v.renderTree).html(response);

                            helpers.collapseAll();
                            $scope.find('ul, .overflow-auto').scrollTop(0);
                        }
                    });
                },

                'toggleCheckbox': function (e) {
                    e.stopImmediatePropagation();
                    const checked = e.currentTarget.checked;

                    $(e.currentTarget).closest('li').find('input[type="checkbox"]').prop('checked', checked);
                    $scope.find('#htmlTable :input:not(#perPage)').not(':checkbox,:radio').val('');
                    $scope.find('#htmlTable :checkbox').prop('checked', false)
                    $scope.find('#htmlTable tr').removeClass('selected bg-warning');
                },

                'search': function (e) {
                    e.stopImmediatePropagation();
                    const query = e.currentTarget.value.toLowerCase().trim();
                    const $visible = $scope.find(v.blockFilter).filter(':visible');
                    const $items = $visible.find('li');

                    if (! query) {
                        helpers.collapseAll();
                        $items.show().removeClass('open');
                        return;
                    }

                    $items.hide();

                    $items.find(v.node).each((_, el) => {
                        const $li = $(el).closest('li');

                        if (! el.textContent.toLowerCase().includes(query))
                            return;

                        $li.show()
                                .addClass('open')
                                .parents('li')
                                .show()
                                .addClass('open')
                                .children('ul')
                                .show();
                    });
                }
            },

            /*  BUTTON HANDLERS
             * =============================== */
            'btn': {

                'showGrp': function (e) {
                    e.stopImmediatePropagation();
                    const $visible = $scope.find(v.blockFilter).filter(':visible');

                    $visible.find(':input').not(':checkbox,:radio').val('');
                    $visible.find(':checkbox').prop('checked', false);

                    $scope.find(v.block).toggleClass('hide');
                    $scope.find('#blockGensoftGrp #renderTree').empty();
                    $scope.find(v.blockFilter).toggleClass('is-hidden');

                    helpers.collapseAll();
                },

                'toggleNode': function (e) {
                    e.stopImmediatePropagation();
                    const $visible = $scope.find(v.blockFilter).filter(':visible');

                    if ($(e.target).is(v.checkbox))
                        return;

                    const $li = $(e.currentTarget).closest('li');
                    const $ul = $li.children('ul');
                    // const $ul = $li.children('ul');

                    if (! $li.closest($visible).length)
                        return;

                    if (! $ul.length)
                        return;

                    // затваряме всички други отворени в ТОЗИ visible блок
                    $visible
                            .find('li.open')
                            .not($li.parents())
                            .not($li)
                            .removeClass('open')
                            .children('ul')
                            .slideUp(150);

                    // toggle текущия
                    $li.toggleClass('open');
                    $ul.stop(true, true).slideToggle(150);
                },

                'getSelected': function (e, options = {} ) {
                    const isReset = options.isReset === true;
                    let $btn = e ? $(e.currentTarget) : $scope.find(v.btnGetSelected);
                    let route = $btn.data('route');
                    let perPage = $scope.find('#perPage').val() || 10;
                    let searchName = $scope.find('table thead input[type=search]');
                    let inStock = $scope.find('table thead #inStock');
                    let hasGensoftPromo = $scope.find('table thead #hasGensoftPromo');
                    let selectCurentPage = $scope.find('#selectPageRows');
                    let selectAllPage = $scope.find('#selectAllResults');

                    let payload = {
                        'ctrl': $scope.data('tipOferta'),
                        'arg': $scope.data('arg'),
                        'page': 1,
                        'perPage': perPage,
                        'inStock': inStock.is(':checked') ? 1 : '',
                        'hasGensoftPromo': hasGensoftPromo.is(':checked') ? 1 : '',
                        'sqlCol': searchName.val() !== '' ? searchName.data('sqlcol') : '',
                        'searchName': searchName.val()
                    };

                    if (e && typeof e.stopImmediatePropagation === 'function') {
                        e.stopImmediatePropagation();
                    }

                    if (! isReset) {
                        if (v.mode === 'gensoftGrp') {
                            const groups = $scope.find('input:checked').not(v.exGrp).map((_, el) => el.value).get();

                            if (__block.is(':visible') && ! groups.length) {
                                alert('Изберете Gensoft група.');
                                return;
                            }

                            payload = {
                                ...payload,
                                'gensoftGroups': groups,
                                'gensoftSkladName': $scope.find(v.selectSklad + ' option:selected').text().trim(),
                                'gensoftDateFrom': $scope.find(v.dateFrom).val(),
                                'gensoftDateTo': $scope.find(v.dateTo).val()
                            };
                        }
                        else {
                            const out = {rootCat_ids: [ ], subCat_ids: [ ]};

                            $scope.find('input:checked').each((_, el) => {
                                const id = + el.value;
                                el.dataset.root == 1
                                        ? out.rootCat_ids.push(id)
                                        : out.subCat_ids.push(id);
                            });

                            if (__block.is(':visible') &&
                                    ! out.rootCat_ids.length &&
                                    ! out.subCat_ids.length) {
                                alert('Изберете Категория.');
                                return;
                            }

                            payload.selectedCatIds = out;
                        }
                    }

                    $.ajax({
                        url: route,
                        type: 'POST',
                        dataType: 'json',
                        data: payload,
                        success: (res) => {

                            $scope.find('tbody').html(res.table);
                            $scope.find('#refreshPagnitation').html(res.pagnitation);
                            $scope.find('#countResults').html(res.totalProducts);
                            $scope.find('.overflow-auto').scrollTop(0);

                            // ако е била избрана опцията текуща стр.
                            if (selectCurentPage.is(':checked')) {
                                selectCurentPage.trigger('change');
                            }

                            // ако е била избрана опцията всички стр.
                            if (selectAllPage.is(':checked')) {
                                selectAllPage.trigger('change');
                            }

                            Lp.popupTitle();
                        }
                    });
                },

                'reset': function (e) {
                    e.stopImmediatePropagation();
                    helpers.resetUI();
                    self.btn.getSelected.call(this, null, {isReset: true});
                }
            },

            /* HELPERS
             * =============================== */
            'helpers': {
                'collapseAll': function () {
                    $scope.find(v.blockFilter + ':visible ul:not(.root)').hide();
                    $scope.find('li.open').removeClass('open');
                },

                'resetUI': function () {
                    const $visible = $scope.find(v.blockFilter).filter(':visible');
                    const search = $visible.find('input[type="text"]');

                    $scope.find(v.checkbox).prop('checked', false);
                    search.val('').trigger('keyup');
                    helpers.collapseAll();
                }
            },
        };

        return core;
    }

    /*  BASE CONFIG
     * =============================== */
    const baseCfg = {
        btnReset: '#reset',
        btnToggleGensGrp: '#toggleFilter_gensfotGrp',
        btnCloseGensGrp: '#closeBlockGensoftGrp',
        blockFilter: '.js-blockFilter',
        node: '.js-node',
        checkbox: '.js-blockFilter input[type="checkbox"]'
    };

    /*  CATEGORY TREE
     * =============================== */
    createTreeCore().init({
        ...baseCfg,
        block: '#blockCategory',
        search: '#treeSearchCat',
        renderTree: '#renderTreeCat',
        btnGetSelected: '#getSelectedCat'
    });

    /*  GENSOFT GROUP TREE
     * =============================== */
    createTreeCore().init({
        ...baseCfg,
        mode: 'gensoftGrp',
        block: '#blockGensoftGrp',
        search: '#treeSearch',
        renderTree: '#renderTree',
        btnGetSelected: '#getSelected',
        exGrp: '.chk-gens-root', // пропуска главните групи
        selectSklad: '#gensoftSklad',
        dateFrom: '#dateFrom',
        dateTo: '#dateTo'
    });

} )(jQuery, window, document);
