// /assets/js/sidebar-menu.js
( function ($, window, document, undefined) {
    var sidebarMenuLeft = sidebarMenuLeft || {};
    let self = sidebarMenuLeft;
 
    let v = sidebarMenuLeft.__vars = {
        lastFocus: false,
        root: $('#sidebar-root'),
        sidebar: $('#sidebar-left'),
        overlay: $('#sidebar-overlay'),
        btnClose: $('#sidebar-close'),
    };

    sidebarMenuLeft = {
        'init': function ( ) {
            self = this;

            this.setUpListeners( );

            if (!v.root || !v.sidebar || !v.overlay)
                return;
        },

        'setUpListeners': function ( ) {
            $(document)
                    .on('click', '#js-side-menu', this.event.open)
                    .on('keydown click', this.event.close);
        },

        'event': {
            'open': function (e) {
                e.stopImmediatePropagation( );

                v.root.addClass('open');
                v.root.find('.sidebar-content')[0].scrollTo({ top: 0, behavior: 'smooth' });
                
                $('body').addClass('sidebar-open');
            },
            'close': function (e) {
                e.stopImmediatePropagation( );

                // ESC → затваряне
                if (e.type === 'keydown' && v.root.hasClass('open') && ( e.key === 'Escape' || e.keyCode === 27 )) {
                    self.closeSidebar();
                }

                // TAB → trap focus вътре
                if (e.type === 'keydown' && v.root.hasClass('open') && ( e.key === 'Tab' || e.keyCode === 9 )) {
                    self.trapFocus(e);
                }

                // Клик върху бутона close
                if (e.type === 'click' && v.root.hasClass('open') && $(e.target).closest('#sidebar-close').length) {
                    self.closeSidebar();
                }

                // Клик върху overlay
                if (e.type === 'click' && v.root.hasClass('open') && $(e.target).closest(v.sidebar).length === 0) {
                    self.closeSidebar();
                }
            }
        },

        'closeSidebar': function () {
            v.root.removeClass('open');
            $('body').removeClass('sidebar-open');
        },

        'trapFocus': function (e) {
            // ако sidebar не е отворен, няма смисъл да трапваме фокуса
            if (!v.root.hasClass('open'))
                return;

            // всички фокусируеми елементи вътре
            var focusables = v.sidebar.find('a, button, input, select, textarea, [tabindex]:not([tabindex="-1"])').filter(':visible:not([disabled])');
            var first = focusables[0];
            var last = focusables[focusables.length - 1];

            if (!focusables.length)
                return;

            if (e.shiftKey && document.activeElement === first) {
                e.preventDefault();
                last.focus();
            }
            else if (!e.shiftKey && document.activeElement === last) {
                e.preventDefault();
                first.focus();
            }
        }
    }

    sidebarMenuLeft.init( );
} )(jQuery, window, document);
