( function ($, window, document) {

    var homePage_navEditor = homePage_navEditor || {};
    let self = homePage_navEditor;
    let v = homePage_navEditor.__vars = {
        editMode: false,
        sortableInstances: [ ],
        activeSection: null,
        initialConfig: null
    };

    homePage_navEditor = {
        init () {
            self = this;

            this.initDragAndDrop();
            this.setUpListeners();
        },

        initDragAndDrop () {
            $('.nav-container').each(function () {
                const sortable = new Sortable(this, {
                    animation: 100,
                    handle: '.icon-box',
                    draggable: '.app-tile-wrap',
                    ghostClass: 'drag-ghost',
                    chosenClass: 'drag-chosen',
                    dragClass: 'dragging',
                    disabled: true
                });
                v.sortableInstances.push(sortable);
            });
        },

        setUpListeners () {
            $(document).on('htmx:afterSwap', function (event) {
                if (event.target.id === 'renderHtml') {
                    self.initDragAndDrop();
                }
            });

            $(document)
                    .on('click', '[data-add-tile]', this.modal.open_addNewLink)
                    .on('click', '#popup-save', this.modal.save_addNewLink)
                    .on('change', '.restore-checkbox', this.events.showHiddenItems)
                    .on('click', '#nav-reset', this.btn.resetToDefault)
                    .on('click', '.remove', this.btn.removeItem)
                    .on('click', '#nav-edit-toggle', this.btn.editMode)
                    .on('click', '#nav-save', this.btn.save)
                    .on('click', '.toggle-visibility', this.btn.toggleVisibility);
        },

        modal: {
            open_addNewLink (e) {
                v.activeSection = $(e.currentTarget).closest('.apps-section');
                self.helpers.refreshHiddenList(v.activeSection);
                $('#linkModal').modal('show');
            },

            save_addNewLink () {
                const title = $('#link-title').val().trim();
                const href = $('#link-url').val().trim();
                const icon = $('#link-icon').val().trim() || 'fa fa-square';

                if (!title || !href) {
                    alert('Моля попълнете име и URL.');
                    return;
                }

                const newBox = `
                    <div class="col-6 col-sm-4 col-md-3 col-lg-2 col-xl-1 mb-4 px-2 text-center app-tile-wrap" data-title="${title}" data-icon="${icon}" data-visible="1">
                        <a class="app-tile" href="${href}">
                            <div class="icon-box">
                                <i class="icon-fa fa-2x mb-2 ${icon}"></i>
                                <div class="controls text-white" style="display:${v.editMode ? 'flex' : 'none'};">
                                    <i class="fa fa-eye toggle-visibility"></i>
                                    <i class="fa fa-trash remove"></i>
                                </div>
                            </div>
                        </a>
                        <div class="nav-item-label">${title}</div>
                    </div>`;

                v.activeSection.find('[data-add-tile]').closest('.add-item-tile').before(newBox);
                $('#linkModal').modal('hide');
                $('#link-title, #link-url, #link-icon').val('');
            }
        },

        events: {
            // показване на скритете елемнети
            showHiddenItems (e) {
                const id = $(e.currentTarget).val();
                if (!v.activeSection)
                    return;

                const $tile = v.activeSection.find(`.app-tile-wrap[data-title="${id}"]`);
                $tile.attr('data-visible', '1')
                        .removeClass('hidden-item d-none')
                        .find('.toggle-visibility')
                        .removeClass('fa-eye')
                        .addClass('fa-eye-slash');

                $(e.currentTarget).closest('.list-group-item').remove();

                if ($('#hidden-list .restore-checkbox').length === 0) {
                    $('#restore-container').hide();
                }
            }
        },

        btn: {
            save (e) {
                e.stopImmediatePropagation();
                const route = $(this).data('route');
                const state = self.helpers.collectConfig();

                $.ajax({
                    url: route,
                    type: 'POST',
                    data: JSON.stringify(state),
                    dataType: 'json',
                    success: () => location.reload()
                });
            },

            resetToDefault () {
                const route = $(this).data('route');
                if (!confirm('Нулиране към фабричната навигация?'))
                    return;

                $.ajax({
                    url: route,
                    type: 'DELETE',
                    dataType: 'json',
                    success: () => location.reload()
                });
            },

            toggleVisibility (e) {
                e.preventDefault();
                e.stopImmediatePropagation();

                const $tile = $(e.currentTarget).closest('.app-tile-wrap');
                const visible = $tile.attr('data-visible') === '1';

                $tile.attr('data-visible', visible ? '0' : '1')
                        .toggleClass('hidden-item', visible);

                $(e.currentTarget).toggleClass('fa-eye fa-eye-slash');
            },

            removeItem (e) {
                e.stopPropagation();
                $(e.currentTarget).closest('.app-tile-wrap').fadeOut(200, function () {
                    $(this).remove();
                });
            },

            editMode () {
                const route = $(this).data('route');
                v.editMode = !v.editMode;

                if (v.editMode) {
                    v.initialConfig = self.helpers.collectConfig();
                }

                $('#nav-edit-toggle')
                        .toggleClass('btn-success', v.editMode)
                        .text(v.editMode ? 'Изход от редакция' : 'Редакция');

                $('#nav-save,#nav-reset').toggle(v.editMode);
                $('.controls, .add-item-tile').toggle(v.editMode);
                v.sortableInstances.forEach(i => i.options.disabled = !v.editMode);

                if (!v.editMode) {
                    Lp.htmxReloadPage(route, {'target': '#renderHtml'});
                }
            }
        },

        helpers: {
            refreshHiddenList (section) {
                const $restoreContainer = $('#restore-container');
                const $list = $('#hidden-list').empty();

                if (!section || !section.length) {
                    $restoreContainer.hide();
                    return;
                }

                const $hiddenItems = section.find('.app-tile-wrap[data-visible="0"]');
                if ($hiddenItems.length === 0) {
                    $restoreContainer.hide();
                    return;
                }

                $hiddenItems.each(function () {
                    const title = $(this).data('title');
                    // const id = $(this).data('item-id') || title;

                    const $item = $(`
                        <label class="list-group-item d-flex align-items-center">
                            <i class="fa fa-eye"></i>&nbsp;
                            <input type="checkbox" class="mr-2 restore-checkbox hide" value="${title}">
                            ${title}
                        </label>`);
                    $list.append($item);
                });

                $restoreContainer.show();
            },

            collectConfig () {
                const config = {};
                $('.apps-section').each(function (index) {
                    const key = $(this).data('key');
                    const title = $(this).find('.apps-section-title').text().trim();
                    const container = $(this).find('.nav-container');

                    config[key] = {
                        key,
                        title,
                        position: index + 1,
                        visible: true,
                        items: [ ]
                    };

                    container.find('.app-tile-wrap').not('[data-add-tile]').each(function (i) {
                        const $el = $(this);
                        const a = $el.find('a');
                        const id = a.attr('id');
                        const href = a.attr('href');
                        const target = a.attr('target');
                        const route = a.attr('data-route');

                        const item = {
                            label: $el.data('title'),
                            icon: $el.data('icon'),
                            visible: parseInt($el.attr('data-visible')),
                            position: i + 1,
                            attrs: {}
                        };


                        if (id)
                            item.attrs.id = id;
                        if (href)
                            item.attrs.href = href;
                        if (target)
                            item.attrs.target = target;
                        if (route)
                            item.attrs['data-route'] = route;


                        config[key].items.push(item);

                    });
                });
                return config;
            }
        }
    };

    homePage_navEditor.init();

} )(jQuery, window, document);
