// === ⚡ Order Notification WebSocket ===
( function ($, window, document, undefined) {
    var nodejs = nodejs || {};
    let self = nodejs;


    let v = nodejs.__vars = {
        reconnectDelay: 3000, //3s,
        reconnectTimer: null,
        wsURL: 'wss://nodejs.rnr75.com?host=' + location.hostname,
    };

    nodejs = {
        'init': function () {
            self = this;

            const searchParams = new URLSearchParams(window.location.search);

            if (searchParams.get('tab') !== 'order') {
                this.connectWS();
            }
        },

        'connectWS': function () {
            try {
                ws = new WebSocket(v.wsURL);
            } catch (e) {
                console.error("❌ WebSocket проблем:", e);

                self.scheduleReconnect();
                return;
            }

            ws.onopen = () => {
                console.log("🟢 Свързан с WebSocket сървъра");
                clearTimeout(v.reconnectTimer);
            };

            let receivedOnce = false;

            ws.onmessage = (event) => {
                let data;

                try {
                    data = JSON.parse(event.data);

                } catch (e) {
                    console.warn("⚠️ Невалиден JSON:", event.data);
                    return;
                }

                // 🔔 Обработка на типове съобщения
                if (data.type === "orderCount") {
                    if (!receivedOnce) {
                        receivedOnce = true;
                        console.info(`процес 1: брояч на поръчките в реално време ${data.count}`);
                    }
       
                    self.updateOrderBadge(data.count);
                }
                else if (data.type === "alert") {
                    console.info(`🔔 Alert: ${data.text}`);
                }
            };

            ws.onclose = () => {
                console.warn(`🔴 Връзката е прекъсната. Нов опит след ${v.reconnectDelay / 1000} сек.`);
                self.scheduleReconnect();
            };

            ws.onerror = (err) => {
                console.error("⚠️ WebSocket грешка:", err);
                ws.close();
            };
        },
        
        'scheduleReconnect': function () {
            if (v.reconnectTimer)
                return;
            v.reconnectTimer = setTimeout(() => {
                v.reconnectTimer = null;

                console.log("♻️ Опит за повторно свързване...");

                self.connectWS();
            }, v.reconnectDelay);
        },

        'updateOrderBadge': function (count) {
            const badge = $(".countOrderNotification");
            if (count > 0) {
                badge.addClass("bg-danger").text(count);
            }
            else {
                badge.removeClass("bg-danger").text('');
            }
        }

    }

    nodejs.init( );
} )(jQuery, window, document);

