
/* global LANG__global */

//=====================================
// Валидация за число и брой
// ==============================
var validate_isNumber = {
    setUpListeners: function ( ) {
        $(document).off('keypress paste');

        $(document).on('keypress paste', 'input[data-isNumeric]', function (e)
        {
            validate_isNumber.isNumber(e);
        });
        $(document).on('keypress paste', 'input[data-isBroj]', function (e)
        {
            validate_isNumber.isBroj(e);
        });
    },
    isNumber: function (e) {
        // проверка дали е число
        // 8-backspace 37-left arrow 39-right arrow 46-delete 32-space 190-to4ka

        var key = e.keyCode ? e.keyCode : e.which;

        if (e.type === 'keypress' && key !== undefined) {
            // 8-backspace, 37-left arrow, 39-right arrow, 46-delete, 32-space, 190-dot
            if (isNaN(String.fromCharCode(key)) && key != 8 && key != 37 && key != 39 && key != 46 || key == 32) {
                alert(LANG__global.validate.alert.isNum);
                e.preventDefault();
                return false;
            }
        }

        if (e.type === 'paste') {
            let pasteData = ( e.originalEvent || e ).clipboardData.getData('text');
            if (!/^\d+(\.\d+)?$/.test(pasteData)) {
                e.preventDefault();
                alert(LANG__global.validate.alert.isNum);
            }
        }
    },
    isBroj: function (e) {
        // проверка дали е число
        // 8-backspace 37-left arrow 39-right arrow 46-delete 32-space 190-to4ka
        var key = e.keyCode ? e.keyCode : e.which;

        if (e.type === 'keypress' && key !== undefined) {
            if (isNaN(String.fromCharCode(key)) && key != 8 && key != 37 && key != 39 || key == 32)
            {
                alert(LANG__global.validate.alert.isBroj);
                e.preventDefault( );
                return false;
            }
        }

        if (e.type === 'paste') {
            let pasteData = ( e.originalEvent || e ).clipboardData.getData('text');
            if (!/^\d+$/.test(pasteData)) {
                e.preventDefault();
                alert(LANG__global.validate.alert.isBroj);
            }
        }
    }
};
validate_isNumber.setUpListeners( );
// валидация на таблиците в mainPage/edit_form и mainPage/create_form за празни полета
// ========================================================================== 
var validate_empty = {

    validationEngine: function (form) {

        if (!$(form).validationEngine('validate', {
            validationEventTrigger: "blur",
            promptPosition: "inline",
            focusFirstField: true,
            showOneMessage: false,
            showPrompts: true,
            scroll: false,
            autoPositionUpdate: true

        })) {
            return false;
        }
    },
    validate_calcDostavka: function (el) {
        let txt = LANG__global.validate.errText; //Попълнете задължитените полета;
        const emptyElements = el.filter(function ( ) {
            return this.value === '';
        });
        if (emptyElements.length > 0) {
            emptyElements.addClass('css-animation-err');

            const errorMessages = emptyElements.map(function ( ) {
                const label = $(this).parent( ).find('label:first').text( ).trim( ) || $(this).parents(':eq(1)').find('label:first').text( ).trim( );
                return `<div>${label}</div>`;
            }).get( ).join('');

            const error = `<div class="alert alert-danger alert-dismissible fade show" role="alert">
    <fieldset class="p-2 pt-3"><strong class="fa fa-exclamation-triangle"></strong> ${txt}${errorMessages}</fieldset>
    <button type="button" class="close p-1" data-dismiss="alert" aria-label="Close">
      <span>&times;</span>
    </button>
  </div>`;
            $('body').append(error);
        }
        else {
            $(el).removeClass('css-animation-err');
            $('.alert').remove( );
        }

        $(el).on('keyup', function ( ) {
            validate_empty.validate_calcDostavka(el);
        });
        return emptyElements.length > 0;
    },
    validate: function (event, arg, table, el) {

        let txt = LANG__global.validate.errText; //Попълнете задължитените полета;
        let errText2 = txt + LANG__global.validate.errText2; // маркирани с звезда (*)';
        let usedHeaders = new Set();
        var found = false;

        $('.alert').remove( );

        el.off('input change', '.validate:visible').on('input change', '.validate:visible', function (e) {

            const target = $(e.target);
            const visibleValidates = el.find('.validate:visible');
            const hasCssAnimationErr = visibleValidates.hasClass('css-animation-err');

            if (target.hasClass('css-animation-err') && target.val().trim() !== '') {
                target.removeClass('bg-danger text-white css-animation-err');
            }

            // Ако вече няма елементи с грешки, махаме предупреждението
            if (!el.find('.css-animation-err').length) {
                $('.alert').remove();
            }

            // 🟡 Стартираме валидацията наново
            validate_empty.validate(null, null, null, el);
        });

        el.find('.validate:visible').each(function ( ) {
            var _this = $(this);
            var $td = _this.closest('td');
            var colIndex = $td.index(); // номер на колоната (0-базиран)
            var $table = $td.closest('table');
            var $th = $table.find('thead tr:eq(1)').children().eq(colIndex);
            var headerText = $th.text().trim();

            var $l = _this.parent( ).find('label:first'); //$('label[for=' + this.id + ']');

            if ($l.length == 0) {
                $l = _this.parents(':eq(1)').find('label:first');
            }

            // Текст за съобщение: първо от <label>, ако няма — от header


            if (_this.is(':radio')) {
                // Проверяваме дали поне един радиобутон е маркиран
                if ($('input[name="' + _this.attr('name') + '"]:checked').length === 0) {
                    found = true;
                    errText2 += `<div>Необходимо да бъде маркиран ${$l.data('name')}</div>`;
                    return false;
                }
            }
            else {

                if (this.value == '') {
                    found = true;
                    _this.addClass('text-white css-animation-err');

                    errText2 += '<div>' + $l.text( ).trim( ) + '</div>';
                    if (!usedHeaders.has(colIndex)) {
                        errText2 += '<div>' + headerText + '</div>';
                        usedHeaders.add(colIndex);
                    }
                }
                else {
                    _this.removeClass('bg-danger text-white css-animation-err');
                }
            }
        });

        validate.private(found, errText2);
        return found;
    },
};


var validate = {
    // ползва се в модул задачи
    isEmpty: function (el = null ) {
        let  txt = LANG__global.validate.errText; //Попълнете задължитените полета;
        let  errText = txt;
        let  found = false;
        let  requiredInputs = el.required ? el : el.find('[required]');

        $('.alert').remove( );

        if (requiredInputs.length === undefined) {
            requiredInputs = [ el ];
        }

        if (requiredInputs.length > 0) {
            $.each(requiredInputs, function (arr) {
                let  _this = $(this);
                let tabPanelId = _this.parents('[role="tabpanel"]').attr('id');

                if (_this.val().trim() === '') {

                    found = true;
                    _this.addClass('bg-danger text-white css-animation-err').attr('placeholder', 'задължително поле');

                    if (tabPanelId !== undefined) {
                        $('nav a[href="#' + tabPanelId + '"]').addClass('css-animation-err');
                    }
                }
                else {
                    _this.removeClass('bg-danger text-white css-animation-err').removeAttr('placeholder');
                }
            });
        }

        validate.private(found, errText);
        return found;
    },

    popupKlient_isValid: function (el = null ) {
        let  txt = LANG__global.validate.errText; //Попълнете задължитените полета;
        let  errText = txt;
        let  found = false;
        let  requiredInputs = el.find('.validate');

        $('.alert').remove( );
        $('.css-animation-err').removeClass('css-animation-err');

        if (requiredInputs.length > 0) {
            $.each(requiredInputs, function () {
                let  _this = $(this);
                let tabPanelId = _this.parents('[role="tabpanel"]').attr('id');
                let isTabObekt = tabPanelId === 'tab-obekt';
                let isSectionHidden = _this.closest('section').hasClass('hide');
                let isAddressBlockHidden = _this.closest('#block-adresDostavka').hasClass('hide');

                if (( isTabObekt && isSectionHidden ) || ( isTabObekt && isAddressBlockHidden )) {

                    return;
                }

                if (_this.val().trim() === '') {
                    found = true;

                    _this.addClass('bg-danger text-white css-animation-err').attr('placeholder', 'задължително поле');

                    $('nav a[href="#' + tabPanelId + '"]').addClass('css-animation-err');
                }
                else {

                    _this.removeClass('bg-danger text-white css-animation-err').removeAttr('placeholder');
                }
            });
        }

        validate.private(found, errText);
        return found;
    },

    tovaritelniza_isValid: function (el = null ) {
        let txt = LANG__global.validate.errText; //Попълнете задължитените полета;
        let errText2 = txt + LANG__global.validate.errText2; // маркирани с звезда (*)';
        var found = false;

        $('.alert').remove( );

        el.find('.validate:visible').each(function ( ) {
            var _this = $(this);
            var $l = _this.data('name'); //$('label[for=' + this.id + ']');

            if (this.value == '') {
                found = true;
                _this.addClass('css-animation-err');
                errText2 += '<div>' + $l + '</div>';
            }
            else {
                _this.removeClass('bg-danger css-animation-err');
            }
        });

        if (found === true) {
            found = true;
            var error = `<div class="alert alert-danger alert-dismissible fade show" role="alert">
    <fieldset class="p-2 pt-3"><strong class="fa fa-exclamation-triangle"></strong> ${errText2}</fieldset>
      <button type="button" class="close p-1" data-dismiss="alert" aria-label="Close">
            <span>&times;</span>
        </button>
</div>`;
            $('body').append(error);
        }
        else {
            $('.alert').remove();
        }
        return found;
    },

    // обща функция
    private: function (found = false, errText = '' ) {

        if (found) {
            var error = `<div class="alert alert-danger alert-dismissible fade show" role="alert">
                            <fieldset class="p-2 pt-3"><strong class="fa fa-exclamation-triangle"></strong> ${errText}</fieldset>
                              <button type="button" class="close text-light p-1" data-dismiss="alert">
                                    <span>&times;</span>
                                </button>
                        </div>`;

            $('body').append(error);
        }
        else {
            $('.alert').remove();
            $('.css-animation-err').removeClass('css-animation-err');
    }
    }

};
