
/* global Ta */

var tableActions = tableActions || {};


tableActions = {
    'Ta': this,

    // изв на информация от Gensoft за конкретния продукт
    'getGensoftInfo': function (e) {
        e.stopImmediatePropagation( );

        var _this = $(this);
        var route = _this.data('route');
        var productName = _this.data('name');

        if (_this.hasClass('tooltipstered')) {
            return false;
        }

        $.ajax({
            url: route,
            type: 'POST',
            dataType: 'json',
            data: {'productName': productName},
            success: function (response) {
                var json = response;
                var myObj = 'Gensoft складове:<br>';
                var kolich_total = 0;

                $.each(json, function (index, value) {
                    let classDanger = value['KOLICH_LOCKED'] != '' ? 'text-danger' : '';
                    let classPrimary = value['KOLICH'] > 0 ? 'text-primary' : '';
                    let safeKol = `<span class="${classDanger}">запаз: ${value['KOLICH_LOCKED']} ${value['RAZFAS1']}</span>`;

                    // обща наличност в всички складове
                    if ($.isNumeric(value['KOLICH_TOTAL'])) {
                        kolich_total += value['KOLICH_TOTAL'];
                    }

                    myObj += `${value['SKLAD'].trim()} <span class="${classPrimary}">кол.: ${value['KOLICH']} ${value['RAZFAS1']}</span> ${safeKol}<br>`;
                });

                myObj += `<br>Обща наличност: ${kolich_total}`;
                _this.attr('data-toggle', 'tooltip').attr('title', myObj).data('title', myObj);

                Lp.popupTitle();

                _this.trigger('click');
            },
        });
    },

    // тотал в футъра на таблоицата
    'getTotal_inFooter': function (arg) {
        // arg -> autoTigger, addZenova, newValuta, editProduct, addProduct ,deleteProduct
        var leftAside = $('#leftAside');
        var total = 0,
                sum = 0,
                totalQty = 0,
                prihodSuma = 0,
                totalNadz = 0,
                totalPrihod = '',
                totalRazhod = 0,
                prozentPechalba = '',
                valuta_symbol = '',
                valuta_izbor = leftAside.find('#valuta_izbor option:selected');

        var radios = leftAside.find('input.isDDS:checked');
        var ddsPercent = typeof SETTINGS_DDS !== "undefined" ? SETTINGS_DDS / 100 : 0;

        if ($(arg.table).find('tbody tr').length === 0) {
            return false; // No table rows found
        }

        console.log('Ta.getTotal_inFooter autoTrigger - ' + arg.autoTrigger);

        valuta_symbol = valuta_izbor.data('symbol') || '';

        $(arg.table).find('tbody tr[data-id]').each(function () {
            var $tr = $(this);
            var zena_dostavna = $tr.find('td.zenaDostavna');
            var zena_dBase = zena_dostavna.data('basePrice');
            var zena_prodava = $tr.find('td.zenaProdava .zenaProdava');
            var qty = $tr.find('td.qty .qty').val();
            var newValuta = arg.newValuta || 1;
            var nadz = '';

            // ако променим валута
            //ako има валута различна от default
            if (valuta_izbor.data('default') == '' && arg.newValuta == undefined) {
                zena_dostavna.text(Lp.toFixed(zena_dBase * valuta_izbor.data('val')) + ' ' + valuta_symbol);
            }

            if (arg.newValuta) {
                zena_dostavna.text(Lp.toFixed(parseFloat(zena_dostavna.text()) * newValuta) + ' ' + valuta_symbol);
                zena_prodava.val(Lp.toFixed(Number(zena_prodava.val()) * newValuta));
            }

            sum = Number(zena_prodava.val()) * Number(qty);
            total += sum;
            totalQty += Number(qty);
            prihodSuma += parseFloat(zena_dostavna.text()) * Number(qty);


            // изчисляване на надценка
            if (zena_prodava.val() != '') {
                nadz = ( parseFloat(zena_prodava.val()) - parseFloat(zena_dostavna.text()) ) / parseFloat(zena_dostavna.text()) * 100;

                $tr.find('td.nadz').html(Lp.toFixed(nadz) + ' %<br>');
                $tr.find('td.nadz').toggleClass('text-danger', parseFloat(nadz) < 0 || parseFloat(nadz) === 'Infinity');
                $tr.find('td.total').text(Lp.toFixed(sum) + ' ' + valuta_symbol);// тотал
            }
            else {
                $tr.find('td.nadz').text('');
                $tr.find('td.total').text('');// тотал = ''
            }
        });

        // тотал без ддс
        $(arg.table).find('tfoot tr#total_bez_dds th.suma').text(Lp.toFixed(total) + ' ' + valuta_symbol);

        if (radios) {
            if (radios.val( ) == 1) {
                $(arg.table).find('tfoot tr#dds, tfoot tr#total_s_dds').removeClass('hide');
            }

            //ддс
            $(arg.table).find('tfoot tr#dds th.suma').text(Lp.toFixed(total * ddsPercent) + ' ' + valuta_symbol);

            // тотал с ддс
            $(arg.table).find('tfoot tr#total_s_dds th.suma').text(Lp.toFixed(( total * ddsPercent ) + total) + ' ' + valuta_symbol);
        }
        else {
            $(arg.table).find('tfoot tr#dds th.suma').text('');
            $(arg.table).find('tfoot tr#total_s_dds th.suma').text('');
        }

        // разход
        leftAside.find('#patenRazhod input').each(function () {
            totalRazhod += Number(this.value);
        });

        $(arg.table).find('tfoot tr#razhod th.suma').text(totalRazhod !== 0 ? totalRazhod + ' ' + valuta_symbol : '');

        // приход
        totalNadz = ( total - prihodSuma ) / total * 100;
        totalPrihod = total - prihodSuma;

        $(arg.table).find('tfoot tr#prihod th.nadz').text(Lp.toFixed(totalNadz) + ' %');
        $(arg.table).find('tfoot tr#prihod th.suma').text(Lp.toFixed(totalPrihod) + ' ' + valuta_symbol);

        // печалbа
        prozentPechalba = Lp.toFixed(( totalPrihod - totalRazhod ) / totalPrihod * 100);

        $(arg.table).find('tfoot tr#pechalba th.percent').text(! isNaN(totalRazhod) ? prozentPechalba + ' %' : '');
        $(arg.table).find('tfoot tr#pechalba th.suma').text(totalRazhod !== 0 ? Lp.toFixed(totalPrihod - totalRazhod) + ' ' + valuta_symbol : '');
    },

    'table': {
        // филтър в thead таблицата
        'filter': function (options = {} ) {
            const {modal = '', input, table} = options;

            $(`${modal} ${input}`).multifilter({
                'target': $(table)
            });
        },

        'filterByCol': function (options = {} ) {
            const {modal = '', input = '', table = ''} = options;

            const $table = $(`${modal} ${table}`);
            const $rows = $table.find('tbody tr');

            $table.find(input).on('input', function () {
                const $this = $(this);
                const id = $this.attr('id'); // напр. filter-username
                const key = id.replace('filter-', ''); // username
                const value = $this.val().toLowerCase().trim();

                $rows.each(function () {
                    const $row = $(this);
                    const $cell = $row.find(`td[data-name="${key}"]`);

                    // Пропусни, ако съдържа <option> елементи (напр. в <select>)
                    const cellText = $cell.clone().find('select').remove().end().text().toLowerCase().trim();

                    const match = cellText.startsWith(value);
                    $row.toggle(match || value === '');
                });
            });
        },
    },

    'tableRow': {
        'position': {

            'getTitle': function ( ) { // tableRow - position
                var $row = $(this).closest('tr');
                var $movableRows = $(this).closest('tbody').find('tr').not('.colorRows');

                $(this).attr('title', LANG__global.table.rowPosition + ' ' + ( $movableRows.index($row) + 1 ) + '\n' + LANG__global.table.titleRowPosition);
            },

            'setPosition': function (e) { // tableRow - position
                var $row = $(this).closest('tr');
                var $table = $(this).closest('table');

// Вземаме само редовете, които нямат клас 'colorRows'
                var $movableRows = $table.find('tbody tr').not('.colorRows');
                var totalRows = $movableRows.length;
                var inputValid = false;

                do {
                    let inputPrompt = prompt(
                            LANG__global.table.rowPosition + ( $movableRows.index($row) + 1 ) + '\n' +
                            LANG__global.table.enterRowPosition, ''
                            );
                    let targetIndex = parseInt(inputPrompt);

                    if (inputPrompt === null)
                        return false; // Натиснат Cancel

                    if (inputPrompt === '' || isNaN(inputPrompt)) {
                        alert(LANG__global.table.onlyNumberRowPosition);
                        continue;
                    }

                    if (targetIndex <= 0) {
                        alert(LANG__global.table.isNulaRowPosition);
                        continue;
                    }

                    targetIndex = Math.min(targetIndex, totalRows); // ограничаваме до последния "валиден" ред

                    if (targetIndex - 1 === $movableRows.index($row)) {
                        inputValid = true; // същата позиция
                    }
                    else {
                        // Вземаме референтния ред – този, спрямо който ще местим
                        let $targetRow = $movableRows.eq(targetIndex - 1);

                        if ($movableRows.index($targetRow) < $movableRows.index($row)) {
                            $row.insertBefore($targetRow);
                        }
                        else {
                            $row.insertAfter($targetRow);
                        }
                        inputValid = true;
                    }
                }
                while (! inputValid);

                // Преномериране на позициите
                $table.find('tbody tr.colorRows').each(function (i) {
                    $(this).find('td.colorRows-data input.colorRows-pos').attr('value', $(this).index( ) - i);
                });

                e.stopImmediatePropagation();
            },
        },

        //местене на редове в таблицата
        'move': function (e) {
            $(".table tbody").tableDnD({onDrop: function (table, row) {
                    // промяна на позицията на цветния ред
                    $('.table tbody tr.colorRows').each(function (row, tr) {
                        $(this).find('td.colorRows-data input.colorRows-pos').attr('value', $(this).index( ) - row);
                    });
                }, onDragClass: "myDragClass", dragHandle: ".fa-arrows"});
        },

        // tableRow
        'delete': function (e) {
            e.stopImmediatePropagation( );
            var tr = $(this).closest('tr');
            var table = '#tbl_products';
            var productName = tr.find('td.productName').text( ).trim( );
            var confirmMsg = LANG__global.confirm.delete_tbl_row + productName;
            var btnSave = $(document).find('#save-ofer');
            var deletedProductIds = btnSave.attr('data-delete-product');
            var countResults = $('body').find('.countResults') || '';
            var newCountResults;
            var str = ',';

            tr.addClass('bg-danger');

            if (confirm(confirmMsg)) {
                // ако няма никакви с-ти
                if (typeof deletedProductIds == 'undefined' || btnSave.attr('data-delete-product') == '') {
                    str = '';
                }

                btnSave.attr('data-delete-product', ( typeof deletedProductIds !== 'undefined' ? deletedProductIds : '' ) + str + tr.data('id'));

                tr.remove( );

                // ako трябва да се изчисли сумата в футъра
                if ($(this).data('totalinfooter') !== undefined) {
                    Ta.getTotal_inFooter({'table': table});
                }

                if (countResults.length) {
                    newCountResults = countResults.text() - 1;
                    countResults.text(newCountResults);
                }

                // намаляне позиц на цветния ред
                // промяна на позицията на цветния ред
                $(table + ' ' + 'tbody tr.colorRows').each(function (row, tr) {
                    $(this).find('td.colorRows-data input.colorRows-pos').attr('value', $(this).index( ) - row);
                });
            }

            tr.removeClass('bg-danger');
        },

        // ako променим прдажна цена
        'change_zenaProdava': function (e) {
            e.stopImmediatePropagation( );

            $('#is_changedPrice').val(1).attr('value', 1);

        },

        // изв на ценоо ниво за всички продукти
        'get_priceLevel': function (e) {
            e.stopImmediatePropagation();

            var _this = $(this),
                    route = _this.data('route'),
                    level = _this.data('level'),
                    isAll = _this.parent().data('all') || false,
                    table = $('#tbl_products'),
                    requestData = {priceLevel: level},
                    rows = table.find('tbody tr:not(.colorRows)'),
                    productId = null;

            if (isAll) {
                if (! confirm('Тази операция ще промени продажната цена на всички продукти. Продължавате ли?'))
                    return false;

                requestData.productIdArr = rows.map(function () {
                    return $(this).data('id');
                }).get();
            }
            else {
                productId = _this.data('productId');
                requestData.productId = productId;
            }

            $.ajax({
                url: route,
                type: 'POST',
                data: requestData,
                dataType: 'json',
                success: function (response) {

                    if (isAll) {
                        ( response.allLevel || [ ] ).forEach(function (item) {
                            if (item.priceLevel !== '') {
                                table.find(`tbody tr[data-id="${item.product_id}"] .zenaProdava`).val(Lp.toFixed(item.priceLevel));
                            }
                        });

                        $('tbody input[type="text"]').trigger('change');
                        alert('Дълърските нива са обновени');
                    }
                    else {
                        if (response.priceLevel !== '') {
                            table.find(`tbody tr[data-id="${productId}"] .zenaProdava`).val(Lp.toFixed(response.priceLevel)).trigger('change');
                        }
                    }

                    $('body').click();
                    Ta.getTotal_inFooter({'table': '#' + table.attr('id')});
                }
            });
        },
    },

    'colorRow': {
        'edit': function (e) { // colorRow
            e.stopImmediatePropagation( );
            var $tr = $(this).closest('tr');
            var oldName = $tr.find('td.text');
            var newName = '';
            if (newName = prompt(LANG__global.prompt.colorRowName, oldName.text( ).trim( ))) {
                $tr.find('[name="colorRows[colorRows][][text]"]').attr('value', newName);
                oldName.text(newName);
            }
        },
        'delete': function (e) { // colorRow
            e.stopImmediatePropagation( );
            var $tr = $(this).closest('tr');
            var name = $tr.find('td.text');
            if (confirm(LANG__global.confirm.deleteColorRow + ' ' + name.text( ).trim( ) + '!')) {
                $tr.remove( );
            }
        }
    }

};
