<section id="block-modules" class="table-responsive hidden">
    <h2 class="my-3 section-title">Списък с модули и индивидуално настройване на бутони към модулите</h2>

    <label class="w-100">Легенда: с бутоните в хедъра на таблицата се  настройват бутоните за всички модули в съответната колона. <br> 
        <i class="fa fa-power-off">Активен - дали дадения модул ще бъде достъпен</i>
        <i class="fa fa-plus">Създаване на нова цен. листа или оферта</i> и т.н.
    </label>

    <br> <br>

    <?php
    $additionalModules = [
        'Настройки' => ['resource' => 'setings'],
        'Списъци'   => ['resource' => 'lists'],
    ];
    $actions           = [
        '1a'          => 'Активен',
        'plus'        => 'Нова',
        'edit'        => 'Редакция',
        'print'       => 'Предпечат',
        'trash'       => 'Изтриване',
        'clone'       => 'Клониране',
        'save'        => 'Запис',
        'upload'      => 'Качи файл',
        'refresh'     => 'Върни поръчка',
        'handshake-o' => 'Статус на поръчка',
        'cart-plus'   => 'Обедини поръчка',
    ];
    $modules           = [
        'Ценови листи'    => [
            'resource' => 'zenova',
            'allowed'  => filterActions($actions, ['refresh', 'clone', 'save', 'handshake-o', 'cart-plus']),
        ],
        'Дилъри оферти'   => [
            'resource' => 'special',
            'allowed'  => filterActions($actions, ['upload', 'refresh', 'save', 'save', 'handshake-o', 'cart-plus']),
        ],
        'Бизнес Оферти'   => [
            'resource' => 'bizKlient',
            'allowed'  => filterActions($actions, ['upload', 'refresh', 'save', 'handshake-o', 'cart-plus']),
        ],
        'Промоции'        => [
            'resource' => 'promo',
            'allowed'  => filterActions($actions, ['refresh', 'clone', 'save', 'handshake-o', 'cart-plus']),
        ],
        'Заявка за банер' => [
            'resource' => 'baner',
            'allowed'  => filterActions($actions, ['upload', 'refresh', 'save', 'handshake-o', 'cart-plus']),
        ],
        'Поръчки'         => [
            'resource' => 'order',
            'allowed'  => filterActions($actions, ['upload', 'save']),
        ],
        'Задачи'          => [
            'resource' => 'tasks',
            'allowed'  => filterActions($actions, ['upload', 'plus', 'refresh', 'edit', 'print', 'clone', 'handshake-o', 'cart-plus']),
        ],
        'Доставчици'      => [
            'resource' => 'provider',
            'allowed'  => filterActions($actions, ['upload', 'plus', 'refresh', 'edit', 'print', 'clone', 'handshake-o', 'cart-plus']),
        ],
    ];

    function filterActions(array $actions, array $removeKeys = []): array {
        return array_diff_key($actions, array_flip($removeKeys));
    }
    ?>

    <table class="table table-sm">
        <thead class="text-white">
            <tr>
                <th>#</th>
                <th>Модул</th>
                <?php foreach ($actions as $actKey => $actLabel): ?>
                    <th class="text-center" style="<?= $actKey === '1a' ? 'background: #fe9191;' : '' ?>">
                        <button id="selectAll<?= ucfirst($actKey) ?>" class="btn btn-sm text-white" type="button">
                            <i class="d-block fa fa-<?= $actKey === '1a' ? 'power-off' : $actKey ?>"></i>
                            <?= $actLabel ?> 
                            
                            <small class="d-block bg-white px-1">избери всички</small>
                        </button>
                    </th>
                <?php endforeach ?>
            </tr>

            <tr class="text-muted text-red font-size-14">
                <th colspan="3">Модули в началната страница</th>
            </tr>
        </thead>

        <tbody>
            <?php foreach ($modules as $modLabel => $modData): ?>
                <tr>
                    <td></td>

                    <td><?= $modLabel ?></td>

                    <?php foreach ($actions as $actKey => $actLabel): ?>
                        <td class="text-center align-bottom" style="<?= $actKey === '1a' ? 'background: #f6e1e1;' : '' ?>">

                            <?php
                            if (isset($modData['allowed'][$actKey])):
                                $isChecked  = $acl -> is_allowed($ctrl['selectedGroupId'], 'modules', 'mainPage.' . $modData['resource'], $actKey);
                                ?>

                                <i class="cursor-auto fa fa-<?= $actKey === '1a' ? '' : $actKey ?>"></i> 
                                <? // $actLabel  ?> 

                                <label class="switch" title="<?= $actLabel ?>">
                                    <?php
                                    $resource   = $modData['resource'];
                                    $inputName  = "modules[mainPage][{$resource}]";
                                    $inputClass = "module-{$actKey}";

                                    if ($actKey === '1a') {
                                        $isActive = $acl -> is_allowed($ctrl['selectedGroupId'], 'modules', "mainPage.{$resource}", 'isActive');
                                        $checked  = $isActive ? 'checked' : '';
                                        $name     = "{$inputName}[isActive]";
                                        $value    = '1';
                                    } else {
                                        $checked = $isChecked ? 'checked' : '';
                                        $name    = "{$inputName}[denyBtns][]";
                                        $value   = $actKey;
                                    }
                                    ?>
                                    <input class="<?= $inputClass ?>"
                                           name="<?= $name ?>"
                                           type="checkbox"
                                           value="<?= $value ?>"
                                           <?= $checked ?>>

                                    <span class="slider"></span>
                                </label>

                            <?php endif ?>
                        </td>
                    <?php endforeach ?>  
                </tr>
            <?php endforeach ?>

            <tr class="text-muted text-red notAutoNum noRowColor font-size-14">
                <td colspan="3">Модули в базовото меню</td>
            </tr>

            <?php foreach ($additionalModules as $modLabel => $modData): ?>
                <tr>
                    <td></td>
                    <td><?= $modLabel ?></td>

                    <td class="text-center" style="background: #f6e1e1;">
                        <?php $isActive = $acl -> is_allowed($ctrl['selectedGroupId'], 'menu', 'root.' . $modData['resource'], 'isActive'); ?>

                        <label class="switch">
                            <input type="checkbox"
                                   class="module-1a"
                                   name="menu[root][<?= $modData['resource'] ?>][isActive]"
                                   value="1"
                                   <?= $isActive ? 'checked' : '' ?>>
                            <span class="slider"></span>
                        </label>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</section>
