<!-- Sidebar (Form for New User) -->
<aside class="sidebar">
    <h5 class="section-title mb-4 mt-3">Нов потребител</h5>

    <form id="form-user" method="post" action="<?= route_to('Users__save-user', 'null') ?>">
        <div class="mb-1">
            <label>Потребител</label>
            <b class="text-danger">*</b>

            <input class="form-control-sm" name="username" type="text">
        </div>

        <div class="mb-1">
            <label>Име</label>
            <input class="form-control-sm" name="first_name" type="text">
        </div>

        <div class="mb-1">
            <label>Email</label>
            <input class="form-control-sm" name="email" type="email">
        </div>

        <div class="mb-1">
            <label>Група</label>
            <b class="text-danger">*</b>

            <select class="form-control form-control-sm" name="groups">
                <option value=""></option>

                <?php foreach ($groups as $group) { ?>
                    <option value="<?= $group -> id ?>"><?= $group -> name ?></option>
                <?php } ?>
            </select>
        </div>

        <div class="mb-1">
            <label>Парола</label>
            <b class="text-danger">*</b>
            <input class="form-control-sm" name="password" type="password"  autocomplete="new-password" value="">
        </div>
        
        <div class="mb-1">
            <label>Повтори парола</label>
            <b class="text-danger">*</b>
            <input class="form-control-sm" name="againPassword" type="password"  autocomplete="new-password" value="">
        </div>

        <button id="new" class="btn btn-primary btn-sm btn-block mt-3">
            <i class="p-1 border-0 fa fa-save"></i>Запис
        </button>
    </form>
</aside>

<div class="p-3 main-content min-height-450">
    <ul class="breadcrum list-unstyled d-flex p-1">
        <li class="breadcrumb-item fa fa-home"></li>
        <li class="breadcrumb-item font-italic">Списъци</li>
        <li class="breadcrumb-item font-italic">Потребители</li>
        <li class="breadcrumb-item active">Потребители</li>
    </ul>

    <h1 class="section-title">Списък с потребители</h1>
    <div id="reloadDiv">
        <table id="tbl_users" class="table table-bordered table-sm my-2" cellspacing="0" width="100%" >
            <thead class="bg-black">
                <tr>
                    <th></th>
                    <th><input id="filter-username" class="filter"  type="text" placeholder="филтър"></th>
                    <th><input id="filter-firstname" class="filter" type="text" placeholder="филтър"></th>
                    <th><input id="filter-email" class="filter" type="text" placeholder="филтър"></th>

                    <th>
                        <select id="filter-group" class="filter w-100">
                            <option value=""></option>
                            <?php foreach ($groups as $group) { ?>
                                <option value="<?= $group -> name ?>"><?= $group -> name ?></option>
                            <?php } ?>
                        </select>
                    </th>

                    <th colspan="3"></th>
                </tr>

                <tr>
                    <th class="col-0-5">#</th>
                    <th class="col-2"><?= lang('Auth.index_username_th'); ?></th>
                    <th class="col-3"><?= lang('Auth.index_fname_th'); ?></th>
                    <th class="col-3"><?= lang('Auth.index_email_th'); ?></th>
                    <th class="col-1"><?= lang('Auth.index_groups_th'); ?></th>
                    <th class="col-2">Парола</th>
                    <th class="col-2 text-center"><?= lang('Auth.index_status_th'); ?></th>
                    <th class="col-1"></th>
                </tr>
            </thead>

            <tbody>
                <?php foreach ($users as $user) { ?>
                    <tr data-id="<?= $user -> id ?>">
                        <td></td>

                        <td data-name="username">
                            <input class="border-0"
                                   name="username"
                                   type="hidden" 
                                   value="<?= $user -> username ?>">

                            <span> <?= $user -> username ?></span>
                        </td>

                        <td data-name="firstname">
                            <input class="border-0"
                                   name="first_name"
                                   type="hidden" 
                                   value="<?= $user -> first_name ?>">

                            <span><?= $user -> first_name ?></span>
                        </td>

                        <td data-name="email">
                            <input class="border-0"
                                   name="email"
                                   type="hidden" 
                                   value="<?= $user -> email ?>">

                            <span><?= $user -> email ?></span>
                        </td>

                        <td class="groups" data-name="group">
                            <select class="hide w-100" name="groups">
                                <?php foreach ($groups as $group) { ?>
                                    <option value="<?= $group -> id ?>"><?= $group -> name ?></option>
                                <?php } ?>
                            </select>

                            <?php
                            if ($user -> groups) {
                                echo '<span>' . $user -> groups[0] -> name . '</span>';
                            }
                            ?>
                        </td>

                        <td class="text-center"> 
                            <input class="border-0"
                                   name="password"
                                   type="hidden"
                                   autocomplete="new-password"
                                   value="">

                            <span><?= $user -> password == '' ? '' : 'Y' ?></span>
                        </td>

                        <td class="text-center">
                            <?php if ($user -> id != 1) { ?>
                                <a  class="switch-link" href="<?= $user -> active ? route_to('Users__deactivate', $user -> id) : route_to('Users__activate', $user -> id) ?>"
                                    onclick="return confirm('Сигурни ли сте, че искате да <?= $user -> active ? 'деактивирате' : 'активирате' ?> потребител - <?= $user -> username ?>?')">
                                        <?= $user -> active ? lang('Auth.index_active_link') : lang('Auth.index_inactive_link') ?>

                                    <label class="switch" style="cursor: pointer;">
                                        <input type="checkbox" disabled <?= $user -> active ? 'checked' : '' ?>>
                                        <span class="slider"></span>
                                    </label>
                                </a>
                            <?php } ?> 
                        </td>

                        <td class="action text-center">
                            <?php if ($user -> id != 1) { ?>

                                <div class="btnGroup1 btn-group btn-group-sm">
                                    <button type="button" class="edit btn p-0">
                                        <i class="btn-outline-primary p-1 border-0 fa fa-edit"></i>
                                    </button>

                                    <button type="button" class="btn p-0">
                                        <a href="<?= route_to('Users__delete-user', $user -> id, $user -> username) ?>" onclick="javascript: return confirm('Сигурнили сте, че искате да изтриете потребител - <?= $user -> username ?>')">
                                            <i class="btn-outline-danger p-1 border-0 fa fa-trash"></i>
                                        </a>
                                    </button>
                                </div>

                                <div class="btnGroup2 btn-group btn-group-sm hide">
                                    <button type="button" class="save btn" data-route="<?= route_to('Users__save-user', $user -> id) ?>">
                                        <i class="btn-outline-primary p-1 border-0 fa fa-save"></i>
                                    </button>

                                    <button type="button" class="cansel btn">
                                        <i class="btn-outline-secondary p-1 border-0 fa fa-reply-all"></i>
                                    </button>
                                </div>
                            <?php } ?> 
                        </td>
                    </tr>
                <?php } ?>
            </tbody> 
        </table> 
    </div>
</div>
