<?php
$settings = service('settings') -> get('App.general') ?? [];
helper('print_colorRows'); // Load the helper

$_priceAccuracy = $settings['priceAccuracy'] ?? 2;
$preval         = $settings['preval'] ?? [];
$currency       = $preval['base_currency'] ?? 'BGN';

$_defaultValutaSymbol = match ($currency) {
    'EUR' => '€',
    'USD' => '$',
    default => 'лв',
};
?>
<div id="shablon_header" class="text-center pt-2">
    <?php
    $search               = array('док№/дата', 'customerBlock', 'oferName');
    $replace              = array('', '', '<div class="oferName_norm" >' . $ofer -> offersName . '</div>');

    echo str_replace($search, $replace, $ofer -> shablon_header);

    //  echo $ofer -> shablon_header ?? '';
//echo preg_replace('/\r?\n/', "<br>", $list[0]['belezka_oferta']) . '<br><br>';

    $_products    = [];
    $_productData = array_column($list, null, 'product_id');

    foreach ($category_attribute as $row) {
        $_catCharId = $row['category_characteristic_id'];
        $_productId = $row['product_id'] ?? null;

        if ($_productId && isset($_productData[$_productId]) && $row['category_id'] == $_productData[$_productId]['category_id']) {
            // Initialize the product_id group if it doesn't exist
            if (!isset($_products[$_productId])) {
                $_products[$_productId] = [];
            }

            // Append the current row data to the product_id group
            $_products[$_productId][] = [
                'category_characteristic_value'   => $row['category_characteristic_value'],
                'product_characteristic_value_id' => $row['product_characteristic_value_id'] ?? '',
                'product_characteristic_text'     => $row['product_characteristic_text'] ?? '',
                'category_characteristic_id'      => $row['category_characteristic_id'],
                'category_id'                     => $row['category_id'],
                'is_visible_inCatalog'            => $row['is_visible_inCatalog']
            ];
        }
    }

    // dd($_products);
    ?>
</div>

<table id="tbl_products" class="css-product table-bordered" width="100%" cellspacing="0" role="presentation">
    <thead class="akrobatExtraBold" style="background: #42a8f8;font-weight: 700;color: #fff;">
        <tr class="text-center">
            <th class="w-8">Марка</th>
            <th class="w-15">Продукт</th>
            <th class="w-20"><?= lang('LANG__printPreview.tbl.th.desc'); ?></th>
            <th class="kod w-6" style="display: none;">Код</th>
            <th class="cenaB w-7">Цена Б</th>
            <th class="cenaA w-7">Цена А</th>
            <th class="cenaSpec w-7">Спец.</th>
            <th class="cenaKl w-7">Kл. клиент</th>
            <th class="cenaKKC w-7">ККЦ</th>
            <th class="w-7">Налич.</th>
            <th class="w-13 dw-20"><?= lang('LANG__printPreview.tbl.th.img'); ?></th>
        </tr>
    </thead>

    <tbody>
        <?php foreach ($list ?? [] as $key => $row): ?>
            <?php
            $_colorRows = isset($row['colorRows']) ? json_decode($row['colorRows'], true) : [];
            $_clRow     = generate_colorRows_inPrint(['list' => $list, 'key' => $key, 'colspan' => 10, 'colorRows' => $_colorRows]);

            $_img      = empty($row['image']) ? '' : $_ENV['app.imageDir'] . $row['image'];
            $_imgBrand = empty($row['image_brand']) ? '' : $_ENV['app.imageDir'] . $row['image_brand'];

            $_cenaBFormatted    = sprintf('%0.' . $_priceAccuracy . 'f', $row['cenaB']) . ' ' . $_defaultValutaSymbol;
            $_cenaAFormatted    = sprintf('%0.' . $_priceAccuracy . 'f', $row['cenaA']) . ' ' . $_defaultValutaSymbol;
            $_cenaSpecFormatted = sprintf('%0.' . $_priceAccuracy . 'f', $row['cenaSpec']) . ' ' . $_defaultValutaSymbol;
            $_cenaKlFormatted   = sprintf('%0.' . $_priceAccuracy . 'f', $row['cenaKl']) . ' ' . $_defaultValutaSymbol;
            $_cenaKKCFormatted  = sprintf('%0.' . $_priceAccuracy . 'f', $row['cenaKKC']) . ' ' . $_defaultValutaSymbol;

            $_nalichnostText = empty($row['nalichnost']) ? 'с поръчка' : 'на склад';
            $_nalichnostInfo = empty($row['nalichnost']) ? '' : '<br>' . $row['nalichnost'] . ' бр.';

            $_imageLabelHtml = match ($row['badge_index']) {
                '1' => '<p class="mb-1 text-left position-absolute"><img class="w-40" src="' . $_ENV['app.imageDataDir'] . 'labels/new_label.png"></p>',
                '2' => '<div class = "mb-1 text-left position-absolute"><img class = "w-40" src = "' . $_ENV['app.imageDataDir'] . 'labels/feature_label.png"></div>',
                '3' => '<p class="mb-1 text-left position-absolute"><img class="w-40" src="' . $_ENV['app.imageDataDir'] . 'labels/hotSell.png"></p>',
                '4' => '<p class="mb-1 text-left position-absolute"><img class="w-40" src="' . $_ENV['app.imageDataDir'] . 'labels/fix_label.png"></p>',
                default => '',
            };
            ?>
            <tr class="text-center" data-id="<?= $row['product_id'] ?>" data-category-name="<?= $row['category_name'] ?? 0 ?>">
                <td class="p-2">
                    <img class="mw-100 mh-220px m-auto d-inline" src="<?= $_imgBrand; ?>" onerror="this.onerror=null;this.src='';" alt="">
                </td>

                <td class="text-break text-left"><?= $row['product_name'] ?></td>

                <td class="opisanie text-left text-break">
                    <b class="desk"><?= $row['description'] ?></b>

                    <?php if ($row['gensoft_item_id']) : ?>
                        <ul class="attr p-0 m-0 list-unstyled" style="display: none;">
                            <?php
                            foreach ($_products[$row['product_id']] ?? [] as $a) {
                                $_prodCharText = $a['product_characteristic_text'] ?? '';

                                if (!empty($_prodCharText)) {
                                    echo '<li><label class="m-0 p-0">' . ($a['category_characteristic_value'] ?? '') . ':</label> ' . $_prodCharText . '</li>';
                                }
                            }
                            ?>
                        </ul>
                    <?php else: ?> 
                        <b class="attr" style="display: none;"><?= $row['description'] ?></b>
                    <?php endif ?>
                </td>

                <td class="kod text-break" style="display: none;"><?= $row['kod'] ?></td>
                <td class="cenaB"><?= $_cenaBFormatted ?></td>
                <td class="cenaA"><?= $_cenaAFormatted ?></td>
                <td class="cenaSpec"><?= $_cenaSpecFormatted ?></td>
                <td class="cenaKl"><?= $_cenaKlFormatted ?></td>
                <td class="cenaKKC"><?= $_cenaKKCFormatted ?></td>

                <td class="nalichnost">
                    <span class="first"><?= $_nalichnostText ?></span>
                    <span class="second"></span> 
                    <span class="infoNalichno"><?= $_nalichnostInfo ?></span>
                </td>

                <td class="p-2">
                    <div>
                        <?= $_imageLabelHtml ?>
                        <img class="mw-100 mh-220px m-auto d-inline" src="<?= $_img; ?>" onerror="this.onerror=null;this.src='';" alt=""> 
                    </div>
                </td>
            </tr>
            <?= implode('', $_clRow) ?>
        <?php endforeach ?>
    </tbody>
</table>

<br>

<div class="belezka_oferta"><?= $ofer -> belezka_oferta ?? '' ?></div>

<?= $ofer -> shablon_footer ?? '' ?>
