
<?php
$_orderTip      = $_GET['orderTip'] ?? '';
$settings       = service('settings') -> get('App.general') ?? [];
$_defaultFirma  = service('settings') -> get('App.firma');

$_priceAccuracy = $settings['priceAccuracy'] ?? 2;
$_dds           = $settings['dds'];
$preval         = $settings['preval'] ?? [];
$currency       = $preval['base_currency'] ?? 'BGN';

$_valutaSymbol = match ($currency) {
    'EUR' => '€',
    'USD' => '$',
    default => 'лв',
};

$_totalQty     = 0;
$_totalPrice   = 0;
$_searchValuta = array_search('Y', array_column($valuta, 'valuta_isDefault'));
$_arrValuta    = array_column($valuta, null, "valuta_id");
$priceAccuracy = service('settings') -> get('App.general')['priceAccuracy'];

//$_valutaSymbol = '';
//$_valutaCode   = '';

//if ($_searchValuta !== false) {
//    $_valutaSymbol = $valuta[$_searchValuta]['valuta_symbol'];
//}

$_orderId = $_GET['orderId'];
$_title   = match ($_orderTip) {
    'K' => 'КЛИЕНТСКА',
    'site' => 'ДИЛЪРСКА',
    'L' => 'ДИЛЪРСКА ЛОКАЛНА'
};

if ($_orderTip == 'K') {
    $_deliveryJson  = json_decode($ofer -> delivery_json ?? '[]', true);
    $_deliveryAdres = $_deliveryJson['ofis'] ?? (
            (str_contains($_deliveryJson['izborKurier'], 'door')) ? implode(',', [
                'кв.' . $_deliveryJson['quarter'] ?? '',
                'ул.' . $_deliveryJson['street'] ?? '',
                '№.' . $_deliveryJson['street_num'] ?? '',
                'друго ' . $_deliveryJson['other'] ?? ''
            ]) : '');

    $_mapKurier = match ($_deliveryJson['izborKurier'] ?? '') {
        'speedy_machina' => 'до автомат на Speedy',
        'speedy_office' => 'до офис с Speedy',
        'speedy_door' => 'до адрес с Speedy',
        'econt_machina' => 'до еконтомат с Еконт',
        'econt_office' => 'до офис с Еконт',
        'econt_door' => 'до адрес с Еконт',
        default => ''
    };

    $_klientBlock = <<<EOD
                    <div class="py-1 fw-bold">КУПУВАЧ: {$_deliveryJson['lice_zaKont']}</div>
                    <div class="py-1"><span class="fw-bold">населено място:</span> {$_deliveryJson['grad']}</div>
                    <div class="py-1"><span class="fw-bold">куриер:</span> {$_mapKurier}</div>
                    <div class="py-1"><span class="fw-bold">адрес:</span> {$_deliveryAdres}</div>
                    <div class="py-1"><span class="fw-bold">тел.:</span> {$_deliveryJson['tel']}</div>
                EOD;
} elseif (in_array($_orderTip, ['site', 'L'])) {
    $_klientBlock = <<<EOD
                    <div class="py-1 fw-bold">КУПУВАЧ: {$ofer -> klient_name}</div>
                    <div class="py-1"><span class="fw-bold">адрес:</span> {$ofer -> klient_adres}</div>
                    <div class="py-1"><span class="fw-bold">ЕИК/VAT/:</span> {$ofer -> bulstat}</div>
                    <div class="py-1"><span class="fw-bold">М.О.Л.:</span> {$ofer -> klient_mol}</div>
                EOD;
}

$_header = <<<EOD
    <div class='text-center'>
        <h1>$_title ПОРЪЧКА</h1>
        <span class="akrobatExtraBold">No:</span> {$ofer -> order_id}, <span class="akrobatExtraBold">от дата:</span> {$ofer -> date_added}
        <br>
        ДАТА НА СПЕДИЦИЯ - {$ofer -> date_shipping}
    </div>
        
        <br> 
        
    <div class='row justify-content-between'>   
        <div class='col-5'>   
            <fieldset class="mb-2 px-2" style="border: 2px solid #4238ca;">
               $_klientBlock
            </fieldset>
        </div>
        
         <div class='col-5'>   
            <fieldset class="mb-2 px-2" style="border: 2px solid #4238ca;">
               <div class="py-1 fw-bold">ПРОДАВАЧ: {$_defaultFirma['f_name']}</div>
               <div class="py-1"><span class="fw-bold">адрес:</span> {$_defaultFirma['f_adres']}</div>
               <div class="py-1"><span class="fw-bold">ЕИК/VAT/:</span> {$_defaultFirma['f_bulstat']}</div>
               <div class="py-1"><span class="fw-bold">М.О.Л.:</span> {$_defaultFirma['f_mol'] }</div>
            </fieldset>
        </div>
    </div>
EOD;

echo $ofer -> shablon_header ?? $_header;
//echo preg_replace('/\r?\n/', "<br>", $list[0]['belezka_oferta']) . '<br><br>';
?>

<table id="tbl_products" class="css-product table table-sm border-2" cellspacing="0" width="100%">
    <thead>
        <tr class="fw-bold">
            <th class="w-1">№</th>
            <th class="w-10"><?= lang('LANG__printPreview.tbl.th.item') ?></th>
            <th class="w-5">Код</th>
            <th class="w-1">Кол.</th>
            <th class="w-1">Ед.цена <br>в лв.</th>
            <th class="w-1">Стойност<br>в лв.</th>
        </tr>
    </thead>

    <tbody>
<?php
foreach ($list as $k => $row) {
    $_product_gensoftJson = json_decode($row['product_json'] ?? '');

    $_qty   = $_product_gensoftJson -> {$row['product_id']} -> qty ?? '';
    $_price = $_product_gensoftJson -> {$row['product_id']} -> price ?? '';
    $_total = (float) $_qty * (float) $_price;

    $_totalQty   += (float) $_qty;
    $_totalPrice += (float) $_total;
    ?>
            <tr class="text-center" data-id="<?= $row['product_id'] ?>">
                <td><?= $k + 1 ?></td>
                <td class="productName text-left"><?= empty($row['gensoft_productName']) ? $row['product_name'] : $row['gensoft_productName'] ?></td>
                <td class="qty"><?= $row['kod'] ?></td>
                <td class="qty"><?= $_qty ?></td>
                <td class="price text-right"><?= sprintf('%0.' . $priceAccuracy . 'f', $_price) ?> <?= $_valutaSymbol ?></td>
                <td class="total text-right"><?= sprintf('%0.' . $priceAccuracy . 'f', $_total) ?> <?= $_valutaSymbol ?></td>
            </tr>
<?php } ?>
    </tbody>

    <tfoot>
        <tr class="notAutoNum">
            <td colspan="5">&nbsp;</td>
        </tr>

<?php if (in_array($_orderTip, ['site', 'L'])): ?>
            <tr class="notAutoNum">
                <td colspan="4"></td>
                <td class="text-right akrobatExtraBold">Всичко</td>
                <td class="text-right"><?= sprintf('%0.' . $priceAccuracy . 'f', $_totalPrice) . ' ' . $_valutaSymbol ?></td>
            </tr>

            <tr class="notAutoNum">
                <td colspan="4"></td>
                <td class="text-right akrobatExtraBold">ДДС <?= $_dds ?>%</td>
                <td class="text-right"><?= sprintf('%0.' . $priceAccuracy . 'f', $_totalPrice * ($_dds / 100)) . ' ' . $_valutaSymbol ?></td>
            </tr>
<?php endif ?>

        <?php
        $_grandTotal     = in_array($_orderTip, ['site', 'L']) ? $_totalPrice + ( $_totalPrice * ($_dds / 100)) : $_totalPrice;
        ?>
        <tr class="notAutoNum">
            <td colspan="4"></td>
            <td class="text-right akrobatExtraBold">Общо:</td>

            <td class="text-right"><?= sprintf('%0.' . $priceAccuracy . 'f', $_grandTotal) . ' ' . $_valutaSymbol ?></td>
        </tr>

        <tr class="notAutoNum">
            <td class="text-left" colspan="7">(словом):&nbsp;<?= App\Controllers\PrintPreview::number2lv($_grandTotal) ?></td>
        </tr>
    </tfoot>
</table>

<br><br>

<?php
$_payment_method = match ($ofer -> payment_method) {
    'B' => 'Банков превод',
    'N' => 'В брой',
    default => ''
};
?>
<div>НАЧИН НА ПЛАЩАНЕ: <?= $_payment_method ?></div>
<hr>


<div class="row justify-content-between">
    <div class="col">Стоката получена от:

    </div>
    <div class="col">Съставил:&nbsp;<?= $userName_label ?>  </div>
</div>

<br>

<div class="row justify-content-between">
    <div class="col">Подпис:

    </div>
    <div class="col">/ подпис и печат / 

    </div>
</div>

<?= $ofer -> shablon_footer ?? '' ?>

