<?php
$settings = service('settings') -> get('App.general') ?? [];

$_priceAccuracy = $settings['priceAccuracy'] ?? 2;
$preval         = $settings['preval'] ?? [];
$currency       = $preval['base_currency'] ?? 'BGN';

$_valutaSign = match ($currency) {
    'EUR' => '€',
    'USD' => '$',
    default => 'лв',
};
?>
<style>
    .print-section {
        background-image: url('<?= $_ENV['app.imageDataDir'] ?>tabelka/osnova.jpg');
    }
</style>

<section class="row content-header p-1 align-items-center position-fixed w-100 bg-white" style="border-bottom: 1px solid #c3c3c3;top:40px;z-index: 1">
    <div class="col-6 float-left">
        <div class="row col">
            <h5 class="m-0 text-dark">Предпечат   с характеритики - </h5> 
            <span id="oferName" class="p-1"><?= $ofer -> offersName ?? '' ?></span>  
        </div>
    </div>

    <?php if ($arg == 'zenova') { ?>
        <div class="col">
            <label class="my-0">Ценово ниво:</label>
            <input class="chk ml-1" type="checkbox" value="cenaB">Б 
            <input class="chk ml-1" type="checkbox" value="cenaA">А
            <input class="chk ml-1" type="checkbox" value="cenaSpec">Спец.
            <input class="chk ml-1" type="checkbox" value="cenaKl">Ключ. клиент
            <input class="chk ml-1" type="checkbox" value="cenaKKC">ККЦ
        </div>
    <?php } ?>

    <div class="col-1 d-flex float-right justify-content-end align-items-center">
<!--        <a id="createPdf" class="dropdown-item" data-route="<? //route_to('PrintPreview-exportPdf')                                                                     ?>" data-is-catalog="1" href="javascript:;">
            <i class="fa fa-file-pdf-o"></i>&nbsp;<? // lang('LANG__printPreview.header.label.expPdf')                                                                     ?>
        </a>-->

        <select id="fontSizeSelect"> 
            <option value="">--размер на текста за х-ки 14px--</option>
            <option value="12">12px</option>
            <option value="12">13px</option>
            <option value="16">15px</option>
            <option value="16">16px</option>
            <option value="18">18px</option>
            <option value="20">20px</option>
        </select>

        <button id="print" style="float: right;">Print</button>
    </div>
</section>

<div id="printArea" class="container mt-5">


    <?php
    $_products    = [];
    $_productData = array_column($list, null, 'product_id');

    foreach ($category_attribute as $row) {
        $_catCharId = $row['category_characteristic_id'];
        $_productId = $row['product_id'] ?? null;

        if ($_productId && isset($_productData[$_productId]) && $row['category_id'] == $_productData[$_productId]['category_id']) {
            // Initialize the product_id group if it doesn't exist
            if (!isset($_products[$_productId])) {
                $_products[$_productId] = [];
            }

            // Append the current row data to the product_id group
            $_products[$_productId][] = [
                'category_characteristic_value'   => $row['category_characteristic_value'],
                'product_characteristic_value_id' => $row['product_characteristic_value_id'] ?? '',
                'product_characteristic_text'     => $row['product_characteristic_text'] ?? '',
                'category_characteristic_id'      => $row['category_characteristic_id'],
                'category_id'                     => $row['category_id'],
                'is_visible_inCatalog'            => $row['is_visible_inCatalog']
            ];
        }
    }

    // dd($products);

    foreach ($list as $key => $v) {
        // d($v['product_id']);
        $_rowCssTop = match ($key % 5) {
            0 => 'top:80px;',
            1 => 'top:90px;',
            2 => 'top:110px;',
            3 => 'top:130px;',
            4 => 'top:145px;',
            default => ''
        };

        $_qtyPrice_json = json_decode($v['qtyPrice_json'] ?? '') ?? [];
        $_price         = '';

        if (!empty($_qtyPrice_json)) {
            $_price = preg_replace('/\.([0-9]*)/', '<sup class="">.$1</sup>', sprintf('%0.2f', $_qtyPrice_json -> {$v['product_id']} -> price));
        }

        $_cenaBFormatted    = preg_replace('/\.([0-9]*)/', '<sup class="">.$1</sup>', sprintf('%0.2f', $v['cenaB'])) . ' ' . $_valutaSign;
        $_cenaAFormatted    = preg_replace('/\.([0-9]*)/', '<sup class="">.$1</sup>', sprintf('%0.2f', $v['cenaA'])) . ' ' . $_valutaSign;
        $_cenaSpecFormatted = preg_replace('/\.([0-9]*)/', '<sup class="">.$1</sup>', sprintf('%0.2f', $v['cenaSpec'])) . ' ' . $_valutaSign;
        $_cenaKlFormatted   = preg_replace('/\.([0-9]*)/', '<sup class="">.$1</sup>', sprintf('%0.2f', $v['cenaKl'])) . ' ' . $_valutaSign;
        $_cenaKKCFormatted  = preg_replace('/\.([0-9]*)/', '<sup class="">.$1</sup>', sprintf('%0.2f', $v['cenaKKC'])) . ' ' . $_valutaSign;

        $_img = $_ENV['app.imageDir'] . ( empty($v['image_catalog']) || $v['image_catalog'] == '' ? $v['image'] : $v['image_catalog']);

        if ($key % 5 == 0) {
            echo '<div class="print-section m-auto border-1">';
        }
        ?> 

        <div class="row py-1 m-auto no-gutters" data-id="<?= $v['product_id'] ?>" style="height:232px;<?= $_rowCssTop ?>position: relative;">
            <!-- imageBlock-->
            <div class=" mx-3 mh-100" style="width:200px;">
                <img class="mh-100 mw-100" src="<?= $_img; ?>" onerror="this.onerror=null;this.src='';" alt="">
            </div>

            <!-- attrBlock -->
            <div class="my-1 ml-4 mr-3 pl-1" style="width:500px;">
                <h4 class="m-0 akrobatExtraBold"><?= $v['brandTxt']; ?></h4>  

                <ul class="attributes p-0 m-0" style="list-style:none;font-size: 14px">
                    <?php
                    foreach ($_products[$v['product_id']] ?? [] as $a) {
                        $_prodCharText = $a['product_characteristic_text'] ?? '';

                        if (!empty($_prodCharText)) {
                            echo '<li><label class="m-0 p-0">' . ($a['category_characteristic_value'] ?? '') . ':</label> ' . $_prodCharText . '</li>';
                        }
                    }
                    ?>
                </ul>
            </div>

            <!-- tabelkaBlock-->
            <div class="my-auto ml-3" style="width:150px;">
                <img class="mw-100 mh-100" src="<?= $_ENV['app.imageDataDir'] ?>tabelka/osnova_price_bac.png" onerror="this.onerror=null;this.src='';" alt="">

                <h3 class="price m-0" data-product-name="<?= $v['product_name'] ?>">
                    <span class="cenaB section akrobatExtraBold hide"><?= $_cenaBFormatted ?></span>
                    <span class="cenaA section akrobatExtraBold hide"><?= $_cenaAFormatted ?></span>
                    <span class="cenaSpec section akrobatExtraBold hide"><?= $_cenaSpecFormatted ?></span>
                    <span class="cenaKl section akrobatExtraBold hide"><?= $_cenaKlFormatted ?></span>
                    <span class="cenaKKC section akrobatExtraBold hide"><?= $_cenaKKCFormatted ?></span>

                    <?php if ($arg !== 'zenova') { ?>
                        <span class="section akrobatExtraBold"><?= $_price ?></span>
                    <?php } ?>
                </h3>

                <span style="position: absolute;bottom: 78px;right: 50px;">Лева без ДДС</span>
            </div>
        </div>

        <?php
        if ($key % 5 == 4) {
            echo '</div><div class="page-break my-2"></div>';
        }
    }
    ?>
</div>
<script>
    ( function ($, window, document, undefined) {

        var printPreview = printPreview || {};
        let v = printPreview;

        var printPreview = {
            '__var': {
                table: '#tbl_products'
            },
            'init': function () {
                v = this.__var;
                this.setUpListeners();
            },
            'setUpListeners': function ( ) {
                // EVENT
                $(document).on('change', '#fontSizeSelect', this.event.fontSizeSelect);

                // BTN
                $(document)
                        .on('click', '#print', this.btn.print)
                        .on('change', '.chk', this.btn.izborCena);

            },

            'event': {
                'fontSizeSelect': function (e) {
                    var selectedFontSize = $(this).val() || '';

                    $('.attributes').css('font-size', selectedFontSize ? selectedFontSize + 'px' : '');
                }
            },

            'btn': {
                'print': function (e) {
                    e.stopImmediatePropagation();

                    let missingPriceProducts = [ ];

                    $('.price').each(function () {
                        let visibleText = $(this).find('.section:visible').text().trim();
                        let productName = $(this).data('productName');
                        let isNumber = parseFloat(visibleText);

                        if (visibleText === '' || isNaN(isNumber) || isNumber === 0) {
                            missingPriceProducts.push(productName);
                        }
                    });

                    if (missingPriceProducts.length > 0) {
                        alert('Има продукти без цена: \n' + missingPriceProducts.join('\n'));
                    }
                    else {
                        window.print();
                    }
                },

                'izborCena': function (e) {
                    e.stopImmediatePropagation();

                    let chkInputs = $('input.chk');
                    let _this = $(this);

                    chkInputs.not(this).prop("checked", false);

                    $('.section').addClass('hide');

                    if (_this.is(':checked')) {
                        $('.' + _this.val()).toggleClass('hide');
                    }

                }
            }
        };
        printPreview.init( );

    } )(jQuery, window, document);
</script>
