<div id="shablon_header" class="text-center pt-2">
    <?php
    $settings       = service('settings') -> get('App.general') ?? [];
    $_priceAccuracy = $settings['priceAccuracy'] ?? 2;
    //$_valutaSign    = service('settings') -> get('App.default_valutaSymbol');
    $preval         = $settings['preval'] ?? [];
    $currency       = $preval['base_currency'] ?? 'BGN';

    $_valutaSign = match ($currency) {
        'EUR' => '€',
        'USD' => '$',
        default => 'лв',
    };

    $_labels = match ($ofer -> ofer_lang) {
        'en' => [
    'marka'            => 'Brand',
    'totalPrice'       => 'Total Price',
    'product'          => 'Product',
    'description'      => 'Description',
    'qty'              => 'Qty/m',
    'kkc'              => 'KKC',
    'unitPrice'        => 'Unit price',
    'picture'          => 'Picture',
    'priceFor'         => 'price for:',
    'in_stock'         => 'in stock',
    's_porachka'       => 'with order',
    'vat'              => 'VAT',
    'total_witout_vat' => 'Total without VAT',
    'total_vat'        => 'Total with VAT',
    'at'               => 'To the attention<br>of',
    'from'             => $ofer -> klient_adres != '' ? 'from' : '',
    'tel'              => $ofer -> klient_tel != '' ? 'Tel.:' : ''
        ],
        default => [
    'marka'            => 'Марка',
    'totalPrice'       => 'Стойност',
    'product'          => 'Продукт',
    'description'      => 'Описание',
    'qty'              => 'Бр./м',
    'unitPrice'        => 'Ед. цена',
    'picture'          => 'Снимка',
    'kkc'              => 'ККЦ',
    'priceFor'         => 'цена за:',
    'in_stock'         => 'в наличност',
    's_porachka'       => 'с поръчка',
    'vat'              => 'ДДС',
    'total_witout_vat' => 'Сума без вкл. ДДС:',
    'total_vat'        => 'Сума тотал с вкл. ДДС:',
    'at'               => 'На вниманието<br>на',
    'from'             => $ofer -> klient_grad != '' ? 'от' : '',
    'tel'              => $ofer -> klient_tel != '' ? 'Тел.:' : ''
        ],
    };

    $_customerBlock = <<<HTML
                        <div class="customer_block for_pdf">
                          <div id="customer">{$_labels['at']}
                              <label>{$ofer -> klient_name}</label>
                          </div>
                          <div id="customerGrad">{$_labels['from']} 
                              <label>{$ofer -> klient_grad}</label>
                          </div>
                          <div id="customerAdres">
                              <label>{$ofer -> klient_adres}</label>
                          </div>
                          <div id="customerTel">{$_labels['tel']} 
                              <label>{$ofer -> klient_tel}</label>
                          </div>
                      </div>
                HTML;

    $dateCreate = (new DateTime($ofer -> date_create)) -> format('d-m-Y');
    $dateCustom = (new DateTime($ofer -> date_custom)) -> format('d-m-Y');
    $dateFinal  = $dateCustom == '' ? $dateCreate : $dateCustom;

    $search  = array('док№/дата', 'customerBlock', 'oferName');
    $replace = array($ofer -> customNo != '' ? '№: ' . $ofer -> customNo . ' / ' . $dateFinal . ' г.' : '', $_customerBlock, '<div class="oferName_norm" >' . $ofer -> offersName . '</div>');

    echo str_replace($search, $replace, $ofer -> shablon_header);

    $_products    = [];
    $_productData = array_column($list, null, 'product_id');

    foreach ($category_attribute as $row) {
        $_catCharId = $row['category_characteristic_id'];
        $_productId = $row['product_id'] ?? null;

        if ($_productId && isset($_productData[$_productId]) && $row['category_id'] == $_productData[$_productId]['category_id']) {
            // Initialize the product_id group if it doesn't exist
            if (!isset($_products[$_productId])) {
                $_products[$_productId] = [];
            }

            // Append the current row data to the product_id group
            $_products[$_productId][] = [
                'category_characteristic_value'   => $row['category_characteristic_value'],
                'product_characteristic_value_id' => $row['product_characteristic_value_id'] ?? '',
                'product_characteristic_text'     => $row['product_characteristic_text'] ?? '',
                'category_characteristic_id'      => $row['category_characteristic_id'],
                'category_id'                     => $row['category_id'],
                'is_visible_inCatalog'            => $row['is_visible_inCatalog']
            ];
        }
    }
    ?>
</div>

<span class="clear"></span>

<table id="tbl_products" class="css-product table-bordered" width="100%" cellspacing="0">
    <thead class="akrobatExtraBold bg-black">
        <tr class="text-center">
            <th class="brand w-10"><?= $_labels['marka'] ?></th>
            <th class="product w-20" style="display:none"><?= $_labels['product'] ?></th>
            <th class="w-20"><?= $_labels['description'] ?></th>
            <th class="qty w-6"><?= $_labels['qty'] ?></th>
            <th class="w-7"><?= $_labels['unitPrice'] ?></th>
            <th class="total w-7"><?= $_labels['totalPrice'] ?></th>
            <th class="img w-11"><?= $_labels['picture'] ?></th>
        </tr>
    </thead>

    <tbody>
        <?php foreach ($list as $key => $row): ?>
            <?php
            $_qtyPrice_json = json_decode($row['qtyPrice_json'] ?? '');
            $_price         = sprintf('%0.' . $_priceAccuracy . 'f', $_qtyPrice_json -> {$row['product_id']} -> price);
            $_quantity      = $_qtyPrice_json -> {$row['product_id']} -> qty ?? '';
            $_img           = empty($row['image']) ? '' : $_ENV['app.imageDir'] . $row['image'];
            $_imgBrand      = empty($row['image_brand']) ? '' : $_ENV['app.imageDir'] . $row['image_brand'];
            ?>
            <tr data-id="<?= $row['product_id'] ?>" data-symbol="<?= $_valutaSign ?>" data-category-name="<?= $row['category_name'] ?? 0 ?>">

                <td class="brand p-2 text-center">
                    <img class="w-100 m-auto" src="<?= $_imgBrand; ?>" onerror="this.onerror=null;this.src='';" alt="">
                </td>

                <td class="product text-break" style="display:none"><?= $row['product_name'] ?></td>

                <td class="opisanie text-break" >
                    <b class="desk maxHeight"><?= $row['description'] ?></b>

                    <?php if ($row['gensoft_item_id']) : ?>
                        <ul class="attr p-0 m-0 list-unstyled" style="display: none;">
                            <?php
                            foreach ($_products[$row['product_id']] ?? [] as $a) {
                                $_prodCharText = $a['product_characteristic_text'] ?? '';

                                if (!empty($_prodCharText)) {
                                    echo '<li><label class="m-0 p-0">' . ($a['category_characteristic_value'] ?? '') . ':</label> ' . $_prodCharText . '</li>';
                                }
                            }
                            ?>
                        </ul>
                    <?php else: ?> 
                        <b class="attr" style="display: none;"><?= $row['description'] ?></b>
                    <?php endif ?>

                    <span class="belezka"><?= $row['belezka'] != '' ? '<br><br><label class="belezka_label"><u>Бележка</u></label>:<br>' . $row['belezka'] : '' ?></span>       
                </td>

                <td class="qty text-center">
                    <?= $_quantity ? $_quantity . ' ' . $row['mqrka_unit'] : '' ?>
                </td>

                <td class="zenaProdava text-center "><?= empty($_price) ? '' : $_price . ' ' . $_valutaSign ?></td>

                <td class="total text-right"></td>

                <td class="img p-2 text-center">
                    <?=
                    match ($row['badge_index']) {
                        '1' => '<div class="mb-1 text-left position-absolute"><img class="new_label w-40" src="' . $_ENV['app.imageDataDir'] . 'labels/new_label.png"></div>',
                        '2' => '<div class = "mb-1 text-left position-absolute"><img class = "w-40" src = "' . $_ENV['app.imageDataDir'] . 'labels/feature_label.png"></div>',
                        '3' => '<div class="mb-1 text-left position-absolute"><img class="w-40" src="' . $_ENV['app.imageDataDir'] . 'labels/hotSell.png"></div>',
                        '4' => '<div class="mb-1 text-left position-absolute"><img class="w-40" src="' . $_ENV['app.imageDataDir'] . 'labels/fix_label.png"></div>',
                        default => '',
                    }
                    ?>
                    <img class="w-100 m-auto" src="<?= $_img; ?>" onerror="this.onerror=null;this.src='';" alt="">
                </td>
            </tr>
        <?php endforeach ?>
    </tbody>

    <tfoot style="font-size: 17px;">
        <tr id="total_bez_dds" style="font-weight: bold">
            <th class="text-right" colspan="4"><?= $_labels['total_witout_vat'] ?></th>
            <th class="suma text-right"></th>
            <th class="empty"></th>
        </tr>

        <?php if ($ofer -> is_dds) : ?>
            <tr id="dds" class="" style="font-weight: bold">
                <th class="text-right" colspan="4"><?= $_labels['vat'] ?> <?= service('settings') -> get('App.general')['dds'] ?? '' ?>%</th>
                <th class="suma text-right"></th>
                <th class="empty"></th>
            </tr>

            <tr id="total_s_dds" class="" style="font-weight: bold">
                <th class="text-right" colspan="4"><?= $_labels['total_vat'] ?></th>
                <th class="suma text-right"></th>
                <th class="empty"></th>
            </tr>
            <?php endIf ?>
    </tfoot>
</table>

<br>

<div class="belezka_oferta"><?= $ofer -> belezka_oferta; ?></div>

<div class="shablon_footer"><?= $ofer -> shablon_footer ?></div>


<br> <br>

<div class="clear"><?= $ofer -> date_expire == '' ? '' : ' ВАЛИДНОСТ НА ОФЕРТАТА ДО ' . $ofer -> date_expire . 'г.' ?></div>

<br>

<div class="date clear">
    <span><?php echo 'ДАТА: ' . $dateFinal . 'г.'; ?></span>
    <span class="sastavil float-right">СЪСТАВИЛ : <?= $userName_label ?></span> 
</div>

<!-- --- ЗАРЕЖДАНЕ НА JS ОТ CONTROLLER --- -->
<?php if (isset($addJS) && is_array($addJS)) { ?>
    <?php foreach ($addJS as $js) { ?>
        <script src="<?= auto('assets/' . $js . '.js'); ?>"></script>
    <?php } ?>
<?php } ?>

<script>
    var SETTINGS = <?php echo (json_encode(service('settings') -> get('App.general', 'company'))) ?>;
    var SETTINGS_NUM_FIXED = SETTINGS.priceAccuracy;
    var SETTINGS_DDS = SETTINGS.dds;
    // var LANG__special = <?php print_r(json_encode(lang('LANG__special.js'))) ?>


    ( function ($, window, document) {
        var ddsPercent = typeof SETTINGS_DDS !== "undefined" ? SETTINGS_DDS / 100 : 0;
        var total = 0, valuta_sign = '', sum = 0;

        $('#tbl_products').find('tbody tr').each(function () {
            var $tr = $(this);
            var zena_prodava = $tr.find('td.zenaProdava');
            var qty = $tr.find('td.qty').text();

            valuta_sign = $tr.data('symbol') || '';

            sum = parseFloat(zena_prodava.text()) * parseFloat(qty);

            if (!isNaN(sum)) {
                total += sum;

                $tr.find('td.total').text(Lp.toFixed(sum) + ' ' + valuta_sign);// тотал
            }
            else {
                $tr.find('td.total').addClass('bg-danger');
            }
        });

        // тотал без ддс
        $('#tbl_products').find('tfoot tr#total_bez_dds th.suma').text(Lp.toFixed(total) + ' ' + valuta_sign);

        //ддс
        $('#tbl_products').find('tfoot tr#dds th.suma').text(Lp.toFixed(total * ddsPercent) + ' ' + valuta_sign);

        // тотал с ддс
        $('#tbl_products').find('tfoot tr#total_s_dds th.suma').text(Lp.toFixed(( total * ddsPercent ) + total) + ' ' + valuta_sign);
    }(window.jQuery, window, document) );


</script>	
