<?php
$preval        = service('settings') -> get('App.general')['preval'] ?? [];
$_currencyCode = $preval['base_currency'] ?? 'BGN';

function renderUserFilterSelect(array $users, string $orderTip, string $col): void {
    $options = '';
    $route   = route_to('tabOrder', 'orderTip=' . $orderTip) . '&isRefresh=1';

    foreach ($users as $row) {
        $username = htmlspecialchars($row['username']);
        $options  .= <<<HTML
                         <option value="{$username}">{$username}</option>
                     HTML;
    }

    echo <<<HTML
        <div class="d-flex">
            <select id="filter_users" class="css-dropdown-p css-focus-strong css-border-none w-100 px-3 p-1" data-route="{$route}" data-sort_col="{$col}">
                <option value="">--филтър--</option>
                {$options}
            </select>
            <a class="filter-status-clear" style="position: absolute; cursor: pointer; margin-left: 5px; color: red;">×</a>
        </div>
    HTML;
}
?>

<table id="tbl_order" class="ui-responsive table table-striped table-sm my-2" cellspacing="0" width="100%">
    <thead class="css-background">
        <tr class="css-bg-purple">
            <th></th>
            <th class="w-01"></th>
            <th></th>

            <th>
                <input class="filter css-input-p css-focus-strong css-border-none css-max-input-width" type="search" placeholder="<?= lang('LANG__mainPage.tbl.th.filter') ?>" data-route="<?= route_to('tabOrder', 'orderTip=' . $_GET['orderTip']) . '&isRefresh=1' ?>" data-sort_col="order_id" >
            </th>

            <th>
                <div class="d-flex">
                    <select id="filter_curier" class="css-dropdown-p css-focus-strong css-border-none w-100 px-3 p-1" data-route="<?= route_to('tabOrder', 'orderTip=' . $_GET['orderTip']) . '&isRefresh=1' ?>" data-sort_col="delivery_json">
                        <option value="">--Куриер--</option>
                        <option value="econt" <?= ($_GET['searchName'] ?? '') == 'econt' ? 'selected' : '' ?>>Еконт</option>
                        <option value="speedy" <?= ($_GET['searchName'] ?? '') == 'speedy' ? 'selected' : '' ?>>Speedy</option>
                    </select>

                    <a class="filter-status-clear" style="position: absolute; cursor: pointer;margin-left: 5px; color: red;">×</a>
                </div>
            </th>

            <th>
                <input class="filter css-input-p css-focus-strong css-border-none css-max-input-width" type="search" placeholder="<?= lang('LANG__mainPage.tbl.th.filter') ?>" data-route="<?= route_to('tabOrder', 'orderTip=' . $_GET['orderTip']) . '&isRefresh=1' ?>" data-sort_col="klient_name" value="<?= $_GET['searchName'] ?? '' ?>">
            </th>

            <th colspan="2"></th>

            <th>
                <input id="filter_date" class="css-input-p css-focus-strong css-border-none css-max-input-width" type="date" data-route="<?= route_to('tabOrder', 'orderTip=' . $_GET['orderTip']) . '&isRefresh=1' ?>" data-sort_col="date_added">
            </th>

            <?php if ($_GET['orderTip'] == 'L'): ?>
                <th>
                    <?php
                    renderUserFilterSelect($users, $_GET['orderTip'] ?? '', 'userName_create');
                    ?>
                </th>
            <?php endif ?>

            <th>
                <?php renderUserFilterSelect($users, $_GET['orderTip'] ?? '', 'userName_modify') ?>
            </th>

            <th>
                <div class="d-flex">
                    <select id="filter_status" class="css-dropdown-p css-focus-strong css-border-none w-100 px-3 p-1" data-route="<?= route_to('tabOrder', 'orderTip=' . $_GET['orderTip']) . '&isRefresh=1' ?>" data-sort_col="status_name">
                        <option value="">--филтър--</option>

                        <?php foreach ($status as $row): ?>
                            <option value="<?= $row['status_name'] ?>" <?= ($_GET['searchName'] ?? '') == $row['status_name'] ? 'selected' : '' ?>>
                                <?= $row['status_name'] ?>
                            </option>
                        <?php endforeach ?>
                    </select>

                    <a class="filter-status-clear" style="position: absolute; cursor: pointer;margin-left: 5px; color: red;">×</a>
                </div>
            </th>

            <th></th>
        </tr>

        <tr class="labels">
            <th class="w-01">№</th>

            <th>
                <input id="select-allOrders" data-route="<?= route_to('BaseController-setSession') ?>" type="checkbox" title="Маркиране на всички поръчки">
            </th>

            <th class="w-3">
                <?= lang('LANG__mainPage.tbl.th.site') ?>
                <i class="sort pointer-cursor float-right fa fa-<?= $_icon[1] ?>" data-sql='{"col":"site_name","sort":"<?= $_sort ?>"}'></i>
            </th>

            <th class="w-2">
                <?= lang('LANG__mainPage.tbl.th.orderId') ?>
                <i class="sort pointer-cursor float-right fa fa-<?= $_icon[2] ?>" data-sql='{"col":"order_id","sort":"<?= $_sort ?>"}'></i>
            </th>

            <th class="w-4">
                <input class="filter css-input-p css-focus-strong css-border-none css-max-input-width" type="search" placeholder="<?= lang('LANG__mainPage.tbl.th.filter') ?> №" data-route="<?= route_to('tabOrder', 'orderTip=' . $_GET['orderTip']) . '&isRefresh=1' ?>" data-sort_col="tavaritelniza_no">Товарителница №
            </th>

            <th class="w-8"><?= lang('LANG__mainPage.tbl.th.klient') ?>
                <i class="sort pointer-cursor float-right fa fa-<?= $_icon[3] ?>" data-sql='{"col":"klient_name","sort":"<?= $_sort ?>"}'></i>
            </th>

            <th class="w-10">Адрес</th>
            <th class="w-3">Общо с ДДС (<?= $_currencyCode ?>)</th>
            <th class="w-1"><?= lang('LANG__mainPage.tbl.th.dateCreate') ?>
                <i class="sort pointer-cursor float-right fa fa-<?= $_icon[4] ?>" data-sql='{"col":"date_added","sort":"<?= $_sort ?>"}'></i>
            </th>

            <?php if ($_GET['orderTip'] == 'L'): ?>
                <th class="w-5">Потребител</th>
            <?php endif ?>

            <th class="w-5">Последна промяна</th>

            <th class="w-3"><?= lang('LANG__mainPage.tbl.th.orderStatus') ?></th>
            <th class="w-1"></th>
        </tr>
    </thead>

    <tbody> 
        <?php
        foreach ($list ?? [] as $row) {
            $deliveryJson = json_decode($row['delivery_json'] ?? '[]', true);

            $_deliveryAdres = '';

            if (!empty($deliveryJson)) {
                $_deliveryAdres = trim(($deliveryJson['grad'] ?? '') . ', ' . (!empty($deliveryJson['ofis']) ? 'офис: ' . $deliveryJson['ofis'] : ''), ', ');
            }
            ?> 

            <tr data-id="<?= $row['order_id'] ?>"> 
                <td class="fw-400 align-middle text-center"></td> 

                <td class="chk_orderRow fw-400 align-middle text-center">
                    <?php if (!in_array($row['sp_status_id'], [4, 5])): ?>
                        <input type="checkbox" data-route="<?= route_to('BaseController-setSession') ?>" <?= in_array($row['order_id'], $sesion_unionOrderIds) ? 'checked' : '' ?> title="обединяване на поръчки за избраният клиент">
                    <?php endif ?>
                </td>

                <td class="offerName align-middle fw-400"><?= $row['site_name'] ?? $row['order_name'] ?? '' ?></td> 
                <td class="text-center align-middle fw-400"><?= $row['order_id'] ?></td> 

                <?php
                $ko             = json_decode($row['delivery_json'] ?? '[]');
                $shippingCode   = $ko -> izborKurier ?? '';
                $_deliveryMetod = $row['delivery_method'] ?? '';

                $_isEcont  = $_deliveryMetod == 'curier' && in_array($shippingCode, ['econt_office', 'econt_machina', 'econt_door']);
                $_isSpeedy = $_deliveryMetod == 'curier' && in_array($shippingCode, ['speedy_office', 'speedy_machina', 'speedy_door']);
                ?>

                <td class="align-middle text-center fw-400 <?= ( in_array($row['sp_status_id'], [4, 6]) && empty($row['tavaritelniza_no']) && !empty($row['delivery_json']) && ($_isEcont || $_isSpeedy)) ? 'bg-danger' : '' ?>">
                    <div class="col input-group">
                        <div class="row justify-content-center input-group-append<?= $row['tavaritelniza_no'] ?? '' ?>">
                            <?php
                            $_dirLogo  = '/assets/images/curier/';
                            $_logoPath = $_isEcont ? $_dirLogo . 'EcontLogo.png' : ($_isSpeedy ? $_dirLogo . 'SpeedyLogo.png' : '');
                            $_logoSrc  = !empty($_logoPath) ? '<img class="w-50" src="' . $_logoPath . '" title="ръчно въвеждане на товарителница номер">' : '';

                            echo $_logoSrc;

                            if (!empty($row['tavaritelniza_no'])) {
                                echo $row['tavaritelniza_no'];
                            } elseif (in_array($row['sp_status_id'], [4, 6])) {
                                $_urlParams = urldecode(http_build_query(array(
                                    'orderTip'  => $_GET['orderTip'],
                                    'order_id'  => $row['order_id'],
                                    'klient_id' => $row['klient_id'],
                                )));

                                $_route = route_to('MainPage-save_tovaritelnizaNo', $_urlParams);

                                if ($_isEcont || $_isSpeedy) {
                                    $tooltipContent = <<<HTML
                                                <p>Може ръчно да въведете номер на товарителница<br> ако вече съществува за този клиент</p>
                                                <div class="input-group-prepend">
                                                    
                                                    <input class="border-0" type="text" placeholder="попълнете съществуваща товарителница №">
                                                    <i class="saveTovaritelnizaNo btn-outline-primary p-1 fa fa-save align-self-center" 
                                                       title="Запис на товарителница №" 
                                                       data-route="{$_route}"></i>
                                                </div>
                                                HTML;

                                    echo '<i class="px-2 py-0 input-group-text fa fa-plus" data-toggle="tooltip" title="' . htmlspecialchars($tooltipContent) . '"></i>';
                                }
                            }
                            ?>
                        </div>
                    </div>
                </td> 

                <td class="align-middle fw-400"><?= $row['klient_name'] ?></td>

                <td class="align-middle fw-400"><?= $row['klient_adres'] ?></td> 

                <!-- обща сума -->
                <td class="text-center align-middle fw-400"><?= sprintf('%0.' . $_priceAccuracy . 'f', ($row['total_price'] * $_dds + $row['transportenRazhod'])) ?></td>

                <!-- дата на създаване -->
                <td class="align-middle fw-400" data-sort="<?= strtotime($row['date_added']) ?>"><?= date('d-m-Y H:i:s', strtotime($row['date_added'])); ?></td> 

                <?php if ($_GET['orderTip'] == 'L'): ?>
                    <td><?= $row['userName_create'] ?></td>
                <?php endif ?>

                <!-- последна промяна -->
                <td class="fw-400"><?= ($row['userName_modify'] ?? '') . '<br>' . ($row['date_update'] ?? ''); ?></td>

                <?php
                $_cellBg    = $row['color'] ?? '';
                $_textColor = $row['text_color'] ?? 'text-white';
                $_bgClass   = $_cellBg . ' ' . $_textColor;
                ?>

                <!-- статус -->
                <td class="text-center align-middle fw-400 <?= $_bgClass ?>" style="<?= $row['sp_status_id'] == 6 ? 'background:#faf74c' : '' ?>"><?= $row['status_name'] ?? 'нова' ?></td> 

                <td  class="action text-center1 align-middle fw-400"> 
                    <?php
                    $_id        = $row['order_id'] ?? '';
                    $_name      = $row['order_id'] ?? '';
                    $_isLocal   = !empty($row['is_local']); // по-ясно като булева стойност

                    $urlParams = [
                        'tab'      => $_activeTab,
                        'orderTip' => $_GET['orderTip'] ?? '',
                        'orderId'  => $_id,
                        'name'     => $_name
                    ];

                    $urlParams = urldecode(http_build_query($urlParams));

                    $_classHideReturn       = !in_array($row['sp_status_id'], [4, 6]) ? 'hide' : '';
                    $_classHideChangeStatus = !in_array($row['sp_status_id'], [6]) ? 'hide' : '';
                    // Генериране на бутони
                    $btns                   = [
                        // printPreview
                        'print'     => ($_GET['orderTip'] ?? '') !== 'N' ? anchor(route_to('PrintPreview', $urlParams), '<i class="btn-outline-dark p-1 border-0 fa fa-print" title="' . lang('LANG__global.btn.printPreview') . '"></i>', 'target="_blank"') : '',
                        // редакция
                        'edit'      => anchor(route_to('Order-index', $urlParams), '<i class="btn-outline-primary p-1 border-0 fa fa-edit" title="' . lang('LANG__global.btn.edit') . '"></i>', "class='edit_ofer' data-id=\"$_id\""),
                        // връщане на поръчка
                        'refresh'   => anchor(route_to('MainPage-orderReturn', $urlParams), '<i class="btn-outline-danger p-1 border-0 fa fa-refresh" title="Връщане на поръчка"></i>', "class='$_classHideReturn' onclick=\"javasciprt: return confirm('Сигурнили сте, че искате да върнете поръчка: $_id')\" "),
                        // промяна статуса на поръчка на завършен
                        'cart-plus' => anchor(route_to('MainPage-completeOrder', $urlParams), '<i class="btn-outline-success p-1 border-0 fa fa-handshake-o" title="Промяна статуса на завършен на поръчката"></i>', "class='$_classHideChangeStatus' onclick=\"javasciprt: return confirm('Сигурнили сте, че искате да смените статуса на завършен за поръчка: $_id')\" "),
                        // клониране
                        'clone'     => anchor(route_to('MainPage-copy', $urlParams), '<i class="btn-outline-success p-1 border-0 fa fa-copy" title="' . lang('LANG__global.btn.clone') . '"></i>', array('class' => 'copyOfer')),
                        // изтриване
                        'trash'     => anchor(route_to('MainPage-orderDelete', $urlParams), '<i class="btn-outline-danger p-1 border-0 fa fa-trash" title="' . lang('LANG__global.btn.delete') . '"></i>', "onclick=\"javasciprt: return confirm('Сигурнили сте, че искате да изтриете поръчка: $_id')\" "),
                    ];

                    if (!empty($row['tavaritelniza_no'])) {
                        $btns['trash'] = anchor('', '<i class="btn-outline-danger p-1 border-0 fa fa-trash" title="' . lang('LANG__global.btn.delete') . '"></i>', "onclick=\"javasciprt: confirm('Има генерирана товарителница за поръчка: $_id и неможе да бъде изтрита.'); return false;\" ");
                    }

                    $_buttons = '';

                    // статус 4- завършен 5- върнат 6-авансово
                    if ($acl -> isAdmin == 'admin') {
                        $_buttons = match ((int) $row['sp_status_id']) {
                            5 => $btns['edit'] . $btns['clone'] . $btns['trash'],
                            default => implode('', $btns),
                        };
                    } else {
                        // ACL проверките за статус 5
                        if ((int) $row['sp_status_id'] === 5) {

                            // Само edit, clone, delete
                            foreach (['edit', 'clone', 'trash'] as $action) {
                                if ($acl -> is_allowed($userGroupId, 'modules', $_moduleKey, $action)) {
                                    $_buttons .= $btns[$action] ?? '';
                                }
                            }
                        } else {
                            foreach (['print', 'edit', 'refresh', 'cart-plus', 'clone', 'trash'] as $action) {
                                if ($acl -> is_allowed($userGroupId, 'modules', $_moduleKey, $action)) {
                                    $_buttons .= $btns[$action] ?? '';
                                }
                            }
                        }
                    }
                    ?> 

                    <div class = "btnGroup1 notAllowed btn-group btn-group-sm">
                        <?= $_buttons ?>
                    </div>
                </td> 
            </tr> 
        <?php } ?> 
    </tbody> 
</table>
