<?php
$_activeTab          = $_GET['tab'] ?? '';
$_userPreferences    = array_column($userPreferences ?? [], null, 'modul_name');
$_userPreferencesTip = $_userPreferences[$_activeTab] ?? [];
$_moduleKey          = "mainPage.$_activeTab";

$_sort = match ($_GET['sort_order'] ?? 'DESC') {
    'ASC' => 'DESC',
    'DESC' => 'ASC',
};

$_icon = array_fill(1, 7, 'unsorted');

$sortColumns = [
    'offersName'  => 1,
    'date_create' => 2
];

// Set the appropriate icon for the selected sort column, if applicable
if (isset($_GET['sort_col'], $sortColumns[$_GET['sort_col']])) {
    $index         = $sortColumns[$_GET['sort_col']];
    $_icon[$index] = $_sort === 'ASC' ? 'sort-alpha-desc' : 'sort-alpha-asc';
}
?>


<div id="currentView" class="visibleCols d-flex justify-content-end" data-view="<?= $_activeTab ?>">
    <div class="p-2 d-flex align-items-center order-0">
        <label><?= lang('LANG__mainPage.perPage.labelTxt') ?> 

            <?php
            $perPageParams = urldecode(http_build_query([
                'user_preferences_id' => $_userPreferencesTip['user_preferences_id'] ?? '',
                'tab'                 => $_activeTab]))
            ?>

            <select id="perPage" class="css-dropdown-p css-focus-strong css-border-none" data-id="<?= $_userPreferencesTip['user_preferences_id'] ?? '' ?>" data-route="<?= route_to('BaseController-userPreferences', $perPageParams) ?>">
                <?php
                $_options      = [10, 25, 50, 100];
                foreach ($_options as $opt) :
                    ?>
                    <option <?= ( $_userPreferencesTip['per_page'] ?? '') == $opt ? 'selected' : '' ?> value="<?= $opt ?>"><?= $opt ?></option>
                <?php endforeach; ?>
            </select> 
            <?= lang('LANG__mainPage.perPage.labelTxt2') ?></label>
    </div>

    <div class="p-2 d-flex align-items-center order-1">
        <label>Легенда: <span class="border-1" style="background: #d8ffbc;">&nbsp;&nbsp;&nbsp;</span> прикачен файл</label>
    </div>

    <div class="p-2 d-flex align-items-center order-2">
        <div class="input-group justify-content-end">
            <input id="uploadFileName" class="hide form-control notClear" name="is_file" type="text">

            <?php if (function_exists('groupAccess') && groupAccess($acl, $userGroupId, 'modules', 'upload')): ?>
                <label id="chooseFile" class="css-btn-close btn btn-outline-primary  round-10 fw-500">
                    <i class="fa fa-upload"></i>&nbsp;Избор на файл
                </label>
            <?php endif ?>

            <label id="canselFile" class="hide btn btn-outline-danger border-0 rounded-0">
                <i class="fa fa-trash"></i>
            </label>

            <label id="uploadFile" class="hide btn btn-outline-success border-0 rounded-0" data-route="<?= route_to('FileManager-uploadFile', 0, 'zenova') ?>">
                <i class="fa fa-upload"></i>&nbsp;Качи файл 
            </label>

            <input name="is_file" type="file" accept=".pdf,.xlsx,.xls" style="display:none">
        </div>
    </div>

    <!-- дали е активен бутона нова оферта -->
    <?php if (function_exists('groupAccess') && groupAccess($acl, $userGroupId, 'modules', 'plus')): ?>
        <div class="p-2 d-flex align-items-center order-3">
            <a class="btn btn-secondary round-10" href="<?= route_to('Zenova-new') ?>" style="background:#007BFF">
                <i class="fa fa-plus"></i>&nbsp;<?= lang('LANG__mainPage.btn-new.z') ?>
            </a>
        </div>
    <?php endif ?>
</div>

<table id="tbl_zenovaLista" class="css-background-transparent css-border-none table table-striped table-sm my-2" cellspacing="0" width="100%">
    <thead class="css-background">
        <tr class="css-bg-purple">
            <th></th>

            <th class="text-left">
                <input id="tbl-filter" class="css-input-p css-focus-strong css-border-none css-max-input-width" type="search" placeholder="<?= lang('LANG__mainPage.tbl.th.filter') ?>" value="<?= $_GET['searchName'] ?? '' ?>" data-route="<?= route_to('tabZenova') . '&isRefresh=1' ?>" >
            </th>

            <th colspan="4"></th>
        </tr>

        <tr class="labels">
            <th class="w-01">№</th>

            <th class="text-left w-25">
                <?= lang('LANG__mainPage.tbl.th.nameZenova') ?>
                <i class="sort pointer-cursor float-right fa fa-<?= $_icon[1] ?>" data-sql='{"col":"offersName","sort":"<?= $_sort ?>"}'></i> 
            </th>

            <th class="w-2">
                <?= lang('LANG__mainPage.tbl.th.dateCreate') ?>
                <i class="sort pointer-cursor float-right fa fa-<?= $_icon[2] ?>" data-sql='{"col":"date_create","sort":"<?= $_sort ?>"}'></i>

            </th>

            <th class="w-2">
                <?= lang('LANG__mainPage.tbl.th.user') ?>

                <a href="javascript:;" class="float-right" data-sql='{"col":"userName_create","sort":"<?= $_sort ?>"}'><i class="fa fa-" ></i></a>
            </th>

            <th class="w-5">
                <?= lang('LANG__mainPage.tbl.th.dateModify') ?>
                <a href="javascript:;" class="float-right" data-sql='{"col":"date_update","sort":"<?= $_sort ?>"}'><i class="fa fa-"></i></a> 
            </th>

            <th class="w-01"></th>
        </tr> 
    </thead>

    <tbody> 
        <?php
        $_page    = $_GET['page'];
        $_perPage = $_GET['perPage'];

        foreach ($list as $k => $row) {
            ?> 
            <tr class="notAutoNum" style="<?= $row['is_file'] ? 'background:#d8ffbc' : '' ?>" data-id="<?= $row['id'] ?>"> 
                <td><?= $_page == 1 ? $k + 1 : ($k + 1) + ($_perPage * ($_page - 1)) ?></td> 
                <td class="offersName">
                    <input type="hidden" value="<?= $row['offersName'] ?>">
                    <span><?= $row['offersName'] ?></span>
                </td> 
                
                <td class="text-center"><?= date('d-m-Y', strtotime($row['date_create'])) ?></td> 
                <td class="text-center"><?= $row['userName_create'] ?></td>
                <td class="text-center"><?= $row['userName_modify'] . ' ' . $row['date_update'] ?></td>
                <td class="action">
                    <?php
                    $_isFile  = (bool) $row['is_file'];
                    $_fileDir = $row['file_dir'] ?? '';
                    $_id      = $row['id'] ?? '';
                    $_name    = $row['offersName'] ?? '';

                    $urlParams = urldecode(http_build_query([
                        'tab'  => $_activeTab,
                        'id'   => $_id,
                        'name' => $_name,
                    ]));

                    // Генериране на бутони
                    $btns = [
                        'preview' => $_isFile ? '' // няма преглед, ако е файл
                        : anchor(route_to('Zenova-preview', $_id, 'preview'), '<i class="btn-outline-primary p-1 border-0 fa fa-search-plus" title="режим изглед"></i>', "data-id=\"$_id\""
                        ),
                        // printPreview
                        'print'   => $_isFile ? anchor($_ENV['app.imageDataDir'] . "docAsOfer/$_fileDir", '<i class="btn-outline-dark p-1 border-0 fa fa-download"></i>', 'download target="_blank" title="Изтегли файла"'
                        ) : anchor(route_to('PrintPreview', $urlParams), '<i class="btn-outline-dark p-1 border-0 fa fa-print" title="' . lang('LANG__global.btn.printPreview') . '"></i>', 'target="_blank"'),
                        // редакция
                        'edit'    => $_isFile ? '<a class="editFile"><i class="btn-outline-primary p-1 border-0 fa fa-edit" title="' . lang('LANG__global.btn.edit') . '"></i></a>' : anchor(route_to('Zenova-edit', $_id)
                                , '<i class="btn-outline-primary p-1 border-0 fa fa-edit" title="' . lang('LANG__global.btn.edit') . '"></i>', "class=\"edit_ofer\" data-id=\"$_id\""
                        ),
                        // изтриване
                        'trash'   => anchor($_isFile ? route_to('FileManager-deleteFile', $_id, 'zenova', 0) : route_to('MainPage-delete', $urlParams), '<i class="btn-outline-danger p-1 border-0 fa fa-trash" title="' . lang('LANG__global.btn.delete') . '"></i>', 'onclick="return confirm(\'' . lang('LANG__global.js.confirm.deleteOferta', [$_name]) . '\')"'
                        ),
                    ];

                    $_buttons = '';

                    if ($acl -> isAdmin == 'admin') {
                        $_buttons = implode('', $btns);
                    } else {
                        $_buttons .= $btns['preview']; // винаги се показва, ако няма файл

                        foreach (['print', 'edit', 'trash'] as $action) {
                            if ($acl -> is_allowed($userGroupId, 'modules', $_moduleKey, $action)) {
                                $_buttons .= $btns[$action] ?? '';
                            }
                        }
                    }
                    ?> 
                    <div class="btnGroup1 btn-group btn-group-sm">
                        <?= $_buttons ?>
                    </div>

                    <div class="btnGroup2 btn-group btn-group-sm hide">
                        <input class="newFileName hide form-control notClear" name="is_file" type="hidden" autocomplete="off">

                        <input name="is_file" type="file" accept=".pdf,.xlsx,.xls" style="display:none" autocomplete="off">

                        <a class="saveFile" data-route="<?= route_to('FileManager-saveFile', $row['id'], 'zenova', 0) ?>" title="Запис">
                            <i class="btn-outline-primary p-1 border-0 fa fa-save"></i>
                        </a>

                        <a class="uploadNewFile" data-route="<?= route_to('FileManager-uploadFile', $row['id'], 'zenova') ?>" title="Качване на нов файл">
                            <i class="btn-outline-primary p-1 border-0 fa fa-upload"></i>
                        </a>

                        <a class="canselEdit" title="Отмяна на редакцията">
                            <i class="btn-outline-secondary p-1 border-0 fa fa-reply-all"></i>
                        </a>
                    </div>
                </td> 
            </tr> 
        <?php } ?> 
    </tbody> 
</table>

<div id="refreshPagnitation">
    <div id="pagination" class="d-flex col mt-2 justify-content-between fw-500">
        <div>
            <span><?= lang('LANG__mainPage.tbl.footer.total') ?></span> 
            <span class="countResults"><?= $countTotalRecords ?></span>
            <span><?= lang('LANG__mainPage.tbl.footer.records') ?></span>
        </div>
        <ul class="pagination">
            <?= $pagination ?>
        </ul>
    </div> 
</div> 
