<?php
$_activeTab          = $_GET['tab'] ?? '';
$_userPreferences    = array_column($userPreferences ?? [], null, 'modul_name');
$_userPreferencesTip = $_userPreferences[$_activeTab] ?? [];
$_moduleKey          = "mainPage.$_activeTab";

$_sort = match ($_GET['sort_order'] ?? 'DESC') {
    'ASC' => 'DESC',
    'DESC' => 'ASC',
};

$_icon = array_fill(1, 7, 'unsorted');

$sortColumns = [
    'offersName'  => 1,
    'klient_name' => 2,
    'date_create' => 3
];

// Set the appropriate icon for the selected sort column, if applicable
if (isset($_GET['sort_col'], $sortColumns[$_GET['sort_col']])) {
    $index         = $sortColumns[$_GET['sort_col']];
    $_icon[$index] = $_sort === 'ASC' ? 'sort-alpha-desc' : 'sort-alpha-asc';
}
?>

<div id="currentView" class="visibleCols d-flex justify-content-end" data-view="<?= $_activeTab ?>">
    <div class="p-2 d-flex align-items-center order-0">
        <label class="fw-400"><?= lang('LANG__mainPage.perPage.labelTxt') ?> 

            <?php
            $perPageParams = urldecode(http_build_query([
                'user_preferences_id' => $_userPreferencesTip['user_preferences_id'] ?? '',
                //'tip'                 => $_GET['orderTip'],
                'tab'                 => $_activeTab]))
            ?>

            <select id="perPage" class="css-dropdown-p css-focus-strong css-border-none" data-id="<?= $_userPreferencesTip['user_preferences_id'] ?? '' ?>" data-route="<?= route_to('BaseController-userPreferences', $perPageParams) ?>">
                <?php
                $_options      = [10, 25, 50, 100];
                foreach ($_options as $opt) :
                    ?>
                    <option <?= ( $_userPreferencesTip['per_page'] ?? '') == $opt ? 'selected' : '' ?> value="<?= $opt ?>"><?= $opt ?></option>
                <?php endforeach; ?>
            </select> 
            <?= lang('LANG__mainPage.perPage.labelTxt2') ?></label>
    </div>

    <!-- дали е активен бутона нова оферта -->
    <?php if (function_exists('groupAccess') && groupAccess($acl, $userGroupId, 'modules', 'plus')): ?>
        <div class="p-2 order-2"> 
            <a class="btn btn-secondary rounded-0 align-self-end css-btn-save round-10" href="<?= route_to('Baner-new') ?>"  style="background:#007BFF">
                <i class="fa fa-plus"></i>&nbsp;<?= lang('LANG__mainPage.btn-new.s') ?>
            </a>
        </div>
    <?php endif ?>
</div>

<table id="tbl_special" class="css-background-transparent css-border-none ui-responsive table table-striped table-bordered table-sm my-4" cellspacing="0" width="100%">
    <thead class="css-background">
        <tr>
            <th></th>

            <th>
                <input id="tbl-filter" data-route="<?= route_to('tabBaner') . '&isRefresh=1' ?>" type="search" placeholder="<?= lang('LANG__mainPage.tbl.th.filter') ?>" value="<?= @$_GET['searchName'] ?>">
            </th>

            <th> 
                <input class="filter" data-route="<?= route_to('tabBaner') . '&isRefresh=1' ?>" type="search" data-sort_col="klient_name" value="<?= @$_GET['searchName'] ?>">
            </th>

            <th colspan="5"></th>
        </tr>

        <tr class="labels">
            <th class="w-1">№</th>
            <th class="w-15">Заявка за банер
                <i class="sort pointer-cursor float-right fa fa-<?= $_icon[1] ?>" data-sql='{"col":"offersName","sort":"<?= $_sort ?>"}'></i>
            </th>
            
            <th class="w-10">
                <?= lang('LANG__mainPage.tbl.th.custName') ?>
                <i class="sort pointer-cursor float-right fa fa-<?= $_icon[2] ?>" data-sql='{"col":"klient_name","sort":"<?= $_sort ?>"}'></i>
            </th>
            
            <th class="w-2"><?= lang('LANG__mainPage.tbl.th.dateCreate') ?>
                <i class="sort pointer-cursor float-right fa fa-<?= $_icon[3] ?>" data-sql='{"col":"date_create","sort":"<?= $_sort ?>"}'></i>
            </th>
            
            <th class="w-5"><?= lang('LANG__mainPage.tbl.th.user') ?></th>
            <th class="w-5"><?= lang('LANG__mainPage.tbl.th.dateModify') ?></th>
            <th class="w-5">Валидност</th>
            <th class="w-1"></th>
        </tr>
    </thead>

    <tbody> 
        <?php
        $_page    = $_GET['page'];
        $_perPage = $_GET['perPage'];

        foreach ($list as $k => $row) {
            ?> 
            <tr class="notAutoNum" data-id="<?= $row['id'] ?>"> 
                <td class="thN text-center"><?= $_page == 1 ? $k + 1 : ($k + 1) + ($_perPage * ($_page - 1)) ?></td> 
                <td class="offerName"><?= $row['offersName'] ?></td> 
                <td class="text-center"><?= $row['klient_name'] ?></td> 
                <td class="text-center" data-sort="<?= strtotime($row['date_create']) ?>"><?php echo $row['date_create'] ?></td> 
                <td class="text-center"><?= $row['userName_create'] ?></td>
                
                <td class="text-center">
                    <?= $row['userName_modify'] . ' ' . $row['date_update'] ?>

                    <?php if (!empty($row['is_changedPrice'])): ?>
                        <span class="text-danger">цените са променени</span>
                    <?php endif ?>
                </td>
                
                <td class="text-center"><?= $row['date_expire'] ?></td>
               
                <td  class="action text-center"> 
                    <?php
                    $_id   = $row['id'] ?? '';
                    $_name = $row['offersName'] ?? '';

                    $_isHasAttachmentFiles = dirname(getcwd()) . '/' . $_ENV['app.documentsDir'] . "documents/$_activeTab/$_id";

                    $urlParams = urldecode(http_build_query([
                        'tab'  => $_activeTab,
                        'id'   => $_id,
                        'name' => $_name,
                    ]));

                    // Генериране на бутони
                    $btns = [
                        // printPreview
                        'print'    => anchor(route_to('PrintPreview', $urlParams), '<i class="btn-outline-dark p-1 border-0 fa fa-print" title="' . lang('LANG__global.btn.printPreview') . '"></i>', 'target="_blank"'),
                        // свали прикачени файлове
                        'download' => is_dir($_isHasAttachmentFiles) ? anchor(route_to('MainPage-downloadFiles', $urlParams), '<i class="btn-outline-dark p-1 border-0 fa fa-download" title="Свали архив на прикачените файлове"></i>', 'target="_blank"') : '',
                        // редакция
                        'edit'     => anchor(route_to('Baner-edit', $_id), '<i class="btn-outline-primary p-1 border-0 fa fa-edit" title="' . lang('LANG__global.btn.edit') . '"></i>', "class='edit_ofer' data-id=\"$_id\""),
                        // клониране
                        'clone'    => anchor(route_to('MainPage-copy', $urlParams), '<i class="btn-outline-success p-1 border-0 fa fa-copy" title="' . lang('LANG__global.btn.clone') . '"></i>', array('class' => 'copyOfer')
                        ),
                        // изтриване
                        'trash'    => anchor(route_to('MainPage-delete', $urlParams), '<i class="btn-outline-danger p-1 border-0 fa fa-trash" title="' . lang('LANG__global.btn.delete') . '"></i>', 'onclick="return confirm(\'' . lang('LANG__global.js.confirm.deleteOferta', [$_name]) . '\')"'
                        )
                    ];

                    $_buttons = '';

                    if ($acl -> isAdmin == 'admin') {
                        $_buttons = implode('', $btns);
                    } else {
                        foreach (['print', 'edit', 'clone', 'trash'] as $action) {
                            if ($acl -> is_allowed($userGroupId, 'modules', $_moduleKey, $action)) {
                                $_buttons .= $btns[$action] ?? '';
                            }
                        }
                    }
                    ?>

                    <div class = "btnGroup1 btn-group btn-group-sm">
                        <?= $_buttons ?>
                    </div>
                </td> 
            </tr> 
        <?php } ?> 
    </tbody> 

</table>

<div id="refreshPagnitation">
    <div id="pagination" class="d-flex col mt-2 justify-content-between fw-500">
        <div>
            <span><?= lang('LANG__mainPage.tbl.footer.total') ?></span> 
            <span class="countResults"><?= $countTotalRecords ?></span>
            <span><?= lang('LANG__mainPage.tbl.footer.records') ?></span>
        </div>
        <ul class="pagination">
            <?= $pagination ?>
        </ul>
    </div> 
</div>
