<?php
$request = \Config\Services::request();

$_tabs = ['zenova', 'promo', 'bizKlient', 'baner', 'special', 'order'];

// Determine current tab (defaults to 'zenova' if invalid or missing)
$_currentTab = $request -> getGet('tab');
$_currentTab = in_array($_currentTab, $_tabs, true) ? $_currentTab : 'zenova';

// Active tab marker
$_isActive               = array_fill_keys($_tabs, '');
$_isActive[$_currentTab] = 'active';

// Map tabs to views using compact dynamic mapping
$_tabViews = array_combine($_tabs, array_map(fn($t) => $view__table[$t], $_tabs));
?>

<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper css-nomargin m-0 pb-0">
    <section class="content-header p-1">
        <div class="container-fluid">
            <div class="row">
                <div class="col-6"></div>
                <div class="col-6"><small><?php /* breadcrumbs if needed */ ?></small></div>
            </div>
        </div>
    </section>

    <div><?= $message ?? '' ?></div>

    <!-- Main content -->
    <section class="content" style="max-width: 1600px; margin: 0 auto;">
        <div class="row p-0">
            <div class="col round-10"> 

                <!-- Navigation Tabs -->
                <?// view('mainPage/VIEW__mainPage-links', ['_isActive' => $_isActive]) ?>

                <!-- Tab Content Container -->
                <div class="tab-content py-5">
                    <?php
                    // d( $acl -> is_allowed( 17,'forms',"view_zenova.header",'save'));
                    // d($acl -> is_allowed(1, 'modules', "home.zenova", 'edit'));
                    // Цикъл за динамично зареждане на табовете
                    foreach ($_tabs as $tab):
                        ?>
                        <div class="col tab-pane <?= $_isActive[$tab] ?>">

                            <?php
                            if ($_currentTab == $tab) {
                                // проверка дали потребителя има достъп до ресурса
                                if ($acl -> isAdmin !== 'admin' && !$acl -> is_allowed($userGroupId, 'modules', "mainPage.$tab", 'isActive')) {
                                    echo 'Достъпът е отказан!';
                                } else {
                                    echo view($_tabViews[$tab]);
                                }
                            }
                            ?>
                        </div>
                    <?php endforeach; ?>
                </div>

            </div>
        </div>
    </section>
</div>

<script>
    const LANG__mainPage = <?= json_encode(lang('LANG__mainPage.js')) ?>;

    $(document).ready(function () {
        // Future JS actions
    });
</script>
