
<div id="sidebar-overlay"></div>

<div id="sidebar-left" role="dialog">
    <div class="sidebar-header">
        <div class="sidebar-title" id="sidebar-title">Навигация • ERP / CRM</div>
        <button type="button" id="sidebar-close" aria-label="Затвори"><i class="fa fa-times"></i></button>
    </div> 

    <div class="sidebar-content">
        <?php
        if (!empty($nav)):
            $i = 0;

            // Сортираме секциите по position
            usort($nav, function ($a, $b) {
                return $a['position'] <=> $b['position'];
            });

            foreach ($nav as $title => $items):
                if (empty($items['visible'])) {
                    continue;
                }

                if (in_array($items['key'], ['list', 'settings']) && !($acl -> isAdmin == 'admin' || $acl -> is_allowed($userGroupId, 'menu', 'root.setings', 'isActive'))) {
                    continue;
                }
                ?>
                <section class="sidebar-section">
                    <div class="sidebar-group-title"><?= $items['title'] ?></div>

                    <?php
                    usort($items['items'], function ($a, $b) {
                        $posA = $a['position'] ?? 0;
                        $posB = $b['position'] ?? 0;
                        return $posA <=> $posB;
                    });

                    foreach ($items['items'] as $it):
                        $g         = 'g' . (($i++ % 8) + 1);
                        $isVisible = !empty($it['visible']);
                        $attrs     = '';

                        if (!empty($it['attrs'])) {

                            foreach ($it['attrs'] as $attrName => $attrValue) {
                                $attrs .= "$attrName='$attrValue'";
                            }
                        }
                        ?>
                        <a class="app-row <?= $g ?> <?= $isVisible ? '' : 'd-none' ?>" <?= $attrs ?? '' ?>>
                            <span class="app-icon">
                                <i class="<?= $it['icon'] ?? '' ?>"></i>
                            </span>
                            <span class="app-text"><?= $it['label'] ?? '' ?></span>
                        </a>
                    <?php endforeach ?>
                </section>
            <?php endforeach ?>
        <?php endif ?>
    </div>
</div>

