<?php
$allowedBtns = $ctrl['configMap']['allowedBtns'];
?>

<div id="listbox" class="position-relative border-1">
    <div class='text-center bg-primary fw-bold'><?= $ctrl['configMap']['headerTxt'] ?></div>

    <?php
    if (!empty($ctrl['errorMessage'])) {
        echo '<label class="w-100 text-center text-danger fw-bold">' . $ctrl['errorMessage'] . '</label>';
        return false;
    }
    ?>

    <?php if (in_array('chk', $allowedBtns)): ?>
        <div class="mb-1">
            <button class="js-toggleCheckbox btn btn-sm btn-outline-primary" data-route="<?= route_to($ctrl['configMap']['route']) ?>" data-check="1" type="button">Маркирай всички</button>
            <button class="js-toggleCheckbox btn btn-sm btn-outline-secondary" data-route="<?= route_to($ctrl['configMap']['route']) ?>" data-check="0" type="button">Ресет</button>
        </div>
    <?php endif ?>

    <div class="d-flex my-1 w-100">

        <input id="search-local"
               hx-get="<?= route_to('Dropdown-renderView', "tip={$ctrl['tip']}") ?>"              <?= !empty($ctrl['configMap']['htmlSelectors']) ? "hx-include='{$ctrl['configMap']['htmlSelectors']}'" : '' ?>
               hx-trigger="keyup changed"
               hx-vals='js:{"searchText": this.value}'
               hx-target="#listbox ul"
               hx-select="#hx_render ul>*"
               type="text"
               placeholder="филтър"
               value="<?= $ctrl['searchText'] ?? '' ?>">

        <?php if (in_array('save', $allowedBtns)): ?>
            <i id="insert" class="btn-outline-primary font-size-13 p-1 fa fa-save"
               data-attr='{
               "route":"<?= route_to('Dropdown-new', $ctrl['tip']) ?>",
               "routeRefresh":"<?= route_to('Dropdown-renderView', 'tip=' . $ctrl['tip']) ?>",
               "tip":"<?= $ctrl['tip'] ?>"}'>
               <?php endif ?>
        </i>
    </div>

    <div id="hx_render">
        <ul>
            <?php
            if (!empty($ctrl['searchText']) && empty($ctrl['results'])) {
                echo '<label class="w-100 text-center text-danger fw-bold">Няма намерени резултати</label>';
                return false;
            }
            ?>

            <li class="row" data-empty="1" data-tip="<?= $ctrl['tip'] ?>"
            <?php if ($ctrl['tip'] == 'prodCharValues'): ?>
                    data-route="<?= route_to('Dropdown-removeProductAttr') ?>"
                <?php endif ?>>

                <label class="col text-center text-secondary">---</label>
            </li>

            <?php

            function renderDataAttrs($configMap = [], $row = []): string {
                $dbCol = $configMap['dbColumns'];
                $out   = [];

                foreach ($configMap['dataAttr'] as $attr => $depend) {
                    $key = $dbCol[$depend] ?? null;
                    $val = $row[$key] ?? '';

                    if ($val) {
                        $out[] = sprintf('%s="%s"', $attr, $val);
                    }
                }

                if (!empty($configMap['route'])) {
                    $out[] = sprintf('%s="%s"', 'data-route', route_to($configMap['route'], $val));
                }

                return implode(' ', $out);
            }

            foreach ($ctrl['results'] ?? [] as $i => $b):
                // Генерираме атрибутите
                $dataAttrs = renderDataAttrs($ctrl['configMap'], $b);
                $label     = $ctrl['configMap']['dbColumns']['label'];
                ?>

                <li class="row" <?= $dataAttrs ?> data-tip="<?= $ctrl['tip'] ?>">
                    <?php
                    if (in_array('chk', $allowedBtns)):
                        $dbCol       = $ctrl['configMap']['dbColumns'];
                        $mainModelId = $ctrl['configMap']['linkToMainModelId'];
                        $id          = $dbCol['id'];
                        $isCheked    = !empty($b[$dbCol['cheked']]) ? 'checked' : '';
                        ?>
                        <div class="custom-control custom-checkbox">
                            <input id="<?= "i_$i" ?>" class="custom-control-input" type="checkbox"  value="<?= $b[$id] ?>" <?= $isCheked ?>>
                            <label class="custom-control-label mb-0 cursor-pointer" for="<?= "i_$i" ?>"><?= $b[$label]; ?></label>
                        </div>

                    <?php else: ?>
                        <label class="col m-0"><?= $b[$label]; ?></label>

                        <div class="button-group ml-auto">
                            <?php if (in_array('edit', $allowedBtns)): ?>
                                <i class="edit btn-outline-primary font-size-13 px-1 fa fa-edit" data-attr='{"route":"<?= route_to('Dropdown-edit') ?>","tip":"<?= $ctrl['tip'] ?>"}'></i>
                            <?php endif ?>

                            <?php if (in_array('delete', $allowedBtns)): ?>
                                <i class="delete btn-outline-danger font-size-13 px-1 fa fa-trash" data-attr='{"route":"<?= route_to('Dropdown-delete') ?>","routeRefresh":"<?= route_to('Dropdown-renderView', 'tip=' . $ctrl['tip']) ?>","tip":"<?= $ctrl['tip'] ?>"}'></i>
                            <?php endif ?>
                        </div>
                    <?php endif ?>
                </li>
            <?php endforeach ?>
        </ul>
    </div>
</div>
